/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.policy;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import java.util.HashMap;

public class PolicyParamConfigurator
extends ElementConfigurator {
    private static final HashMap<ParameterCodes, Object> listOfParams = new HashMap();

    public PolicyParamConfigurator() {
        super(ClassID.POLICY_PARAMS, "srPolicyParamTable", MibItem.DR_POLICY_PARAM_ROW_STATUS, MibItem.DR_POLICY_PARAM_TABLE_LAST_UPDATE);
    }

    SnmpCommKey getPolicyParamIndexNext(char agentIndex) throws SrCommException {
        String nextIndex = super.getIndexNext(this.myTableName, "1", null, true, agentIndex);
        return new SnmpCommKey(nextIndex, agentIndex);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        element.setCommKey(this.getPolicyParamIndexNext(element.getSnmpAgentFromParameter()));
        super.internalCreate(element);
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        PolicyTypeConstant type = PolicyTypeConstant.valueOf((SrOidType)element.getValue(ParameterCode.POLICY_PARAM_TYPE));
        element.setValue(ParameterCode.POLICY_PARAM_TYPE, type);
        PolicyParamConfigurator.convertParam1And2ToRunEvery(element);
    }

    public void stimulateRefreshPolicyParamsElements(char agentIndex) throws SrCommException {
        super.stimulateRefresh(agentIndex);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        return listOfParams;
    }

    public static void convertParam1And2ToRunEvery(ConfigElementData element) {
        PolicyTypeConstant type = (PolicyTypeConstant)element.getValue(ParameterCode.POLICY_PARAM_TYPE);
        if (type.equals(PolicyTypeConstant.REPLICATE_DATA_CHANGE)) {
            element.setValue(ParameterCode.POLICY_PARAM_RUN_EVERY, (SrType)element.getValue(ParameterCode.POLICY_PARAM_PARAM1));
        } else if (type.equals(PolicyTypeConstant.REPLICATE_PERIODIC)) {
            int hours = ((SrInteger)element.getValue(ParameterCode.POLICY_PARAM_PARAM1)).intValue();
            int minutes = ((SrInteger)element.getValue(ParameterCode.POLICY_PARAM_PARAM2)).intValue();
            element.setValue(ParameterCode.POLICY_PARAM_RUN_EVERY, new SrInteger(hours * 60 + minutes));
        }
    }

    static void convertRunEveryToParam1And2(ConfigElementData element) {
        PolicyTypeConstant type = (PolicyTypeConstant)element.getValue(ParameterCode.POLICY_PARAM_TYPE);
        if (type.equals(PolicyTypeConstant.REPLICATE_DATA_CHANGE)) {
            element.setValue(ParameterCode.POLICY_PARAM_PARAM1, (SrInteger)element.getValue(ParameterCode.POLICY_PARAM_RUN_EVERY));
            element.setValue(ParameterCode.POLICY_PARAM_PARAM2, new SrInteger(0));
        } else if (type.equals(PolicyTypeConstant.REPLICATE_PERIODIC)) {
            int totalMinutes = ((SrInteger)element.getValue(ParameterCode.POLICY_PARAM_RUN_EVERY)).intValue();
            int hours = totalMinutes / 60;
            int minutes = totalMinutes % 60;
            element.setValue(ParameterCode.POLICY_PARAM_PARAM1, new SrInteger(hours));
            element.setValue(ParameterCode.POLICY_PARAM_PARAM2, new SrInteger(minutes));
        } else {
            element.setValue(ParameterCode.POLICY_PARAM_PARAM1, new SrInteger(0));
            element.setValue(ParameterCode.POLICY_PARAM_PARAM2, new SrInteger(0));
        }
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        char agentIndex = aElement.getMyFirstSnmpAgentIndex();
        return new CommKeyClassId(this.getPolicyParamIndexNext(agentIndex), aElement.getClassId());
    }

    static {
        listOfParams.put(ParameterCode.POLICY_PARAM_PARAM1, null);
        listOfParams.put(ParameterCode.POLICY_PARAM_PARAM2, null);
        listOfParams.put(ParameterCode.POLICY_PARAM_TYPE, null);
    }
}

