/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.policy;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrOidType;
import java.util.HashMap;

public class PolicyConfigurator
extends ElementConfigurator {
    private static final HashMap<ParameterCodes, Object> listOfParams = new HashMap();

    public PolicyConfigurator() {
        super(ClassID.POLICY_START, "srPolicyTable", MibItem.DR_POLICY_ROW_STATUS, MibItem.DR_POLICY_TABLE_LAST_UPDATE);
    }

    SnmpCommKey getPolicyIndexNext(char agentIndex) throws SrCommException {
        String nextIndex = super.getIndexNext(this.myTableName, "1", null, true, agentIndex);
        return new SnmpCommKey(nextIndex, agentIndex);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        element.setCommKey(this.getPolicyIndexNext(element.getSnmpAgentFromParameter()));
        if (element.getValue(ParameterCode.POLICY_START_AT) == null) {
            element.removeParameter(ParameterCode.POLICY_START_AT);
        }
        super.internalCreate(element);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        return listOfParams;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        SrOidType paramOid = (SrOidType)element.getValue(ParameterCode.POLICY_POINTER_TO_PARAM);
        String index = DsnmpUtil.getRowIndexFromOidComponents((long[])paramOid.value());
        CommKeyClassId paramKey = new CommKeyClassId(new SnmpCommKey(index, agentIndex), ClassID.POLICY_PARAMS);
        element.setValue(ParameterCode.POLICY_PARAM_ID, paramKey);
    }

    public void stimulateRefreshPolicyElements(char agentIndex) throws SrCommException {
        super.stimulateRefresh(agentIndex);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        char agentIndex = aElement.getMyFirstSnmpAgentIndex();
        return new CommKeyClassId(this.getPolicyIndexNext(agentIndex), aElement.getClassId());
    }

    static {
        listOfParams.put(ParameterCode.POLICY_POINTER_TO_PARAM, null);
        listOfParams.put(ParameterCode.POLICY_START_AT, null);
    }
}

