/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.lu;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrScsiLUNFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.SCSILunStateConstant;
import java.util.HashMap;

public class SCSILunConfigurator
extends ElementConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static HashMap<ParameterCodes, Object> parameterList = new HashMap();

    public SCSILunConfigurator() {
        super(ClassID.SCSI_LUN, "scsiLuTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        return parameterList;
    }

    @Override
    public void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) {
        char agent = element.getMyFirstSnmpAgentIndex();
        String rowIndex = element.getSnmpKey().toString();
        int cutFrom = 0;
        int cutTo = rowIndex.lastIndexOf(46);
        SnmpCommKey key = new SnmpCommKey(rowIndex.substring(cutFrom, cutTo), agent);
        element.setValue(ParameterCode.SCSI_DEVICE_ID, new CommKeyClassId(key, ClassID.SCSI_TARGET));
        SrString state = (SrString)element.getValue(ParameterCode.SCSI_LUN_STATE);
        if (state != null) {
            element.setValue(ParameterCode.SCSI_LUN_STATE, SCSILunStateConstant.valueOf(state.toString()));
        }
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        CommKeyClassId scsiTargetID = (CommKeyClassId)element.removeParameter(ParameterCode.SCSI_DEVICE_ID);
        if (scsiTargetID != null) {
            char agentIndex = element.getSnmpAgentFromParameter();
            long lun = ((SrGauge)element.removeParameter(ParameterCode.LU_LUN_NUMBER)).longValue();
            SnmpCommKey scsiTargetKey = CommKeyUtil.getSpecificSnmpKey(scsiTargetID, agentIndex);
            if (scsiTargetKey != null) {
                ConfigElementDataList scsiLuns = this.getAll(this.myTableName, agentIndex, null, null);
                int i = scsiLuns.size();
                while (i-- > 0) {
                    ConfigElementData scsiLine = (ConfigElementData)scsiLuns.getElementDataAt(i);
                    SrScsiLUNFormat scsiLunFormat = (SrScsiLUNFormat)scsiLine.getValue(ParameterCode.SCSI_LUN_LU_NUMBER);
                    if (scsiLunFormat == null) {
                        theLogger.error(SrLogCategories.LEGACY, new NullPointerException("BUG 5158 recreated - Please look at the MIB browser and call NMS team!!!\n" + scsiLine.toString()), new Object[0]);
                        continue;
                    }
                    int scsiLunNumber = scsiLunFormat.toInt();
                    if (lun != (long)scsiLunNumber) continue;
                    element.removeAll();
                    element.setCommKeyClassId(scsiLine.getCommKeyClassId());
                    return;
                }
            }
        }
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        if (element.getCommKey() != null) {
            return super.readAfterCreate(element);
        }
        return true;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return aElement.getCommKeyClassId();
    }

    static {
        parameterList.put(ParameterCode.SCSI_LUN_LU_NUMBER, null);
        parameterList.put(ParameterCode.SCSI_LUN_REVISION_ID, null);
        parameterList.put(ParameterCode.SCSI_LUN_STATE, null);
        parameterList.put(ParameterCode.SCSI_LUN_STATUS, null);
    }
}

