/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.identity;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthorizationConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityNameConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityXConfigurator;
import com.sanrad.nms.server.mgr.identity.SRPCredentialsConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import java.util.HashMap;

public class IdentityConfigurator
extends ElementConfigurator {
    static Integer[] lastIdIndex = new Integer[0];
    private SrString[] m_identityNamesFroCreation = null;
    private CommKeyClassId m_idOfTargetForACLUpdate = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    public IdentityConfigurator() {
        super(ClassID.IDENTITY, "ipsAuthIdentAttributesTable", MibItem.IDENTITY_RS, MibItem.IDENTITY_EXTENTION_TBL_LAST_UPDATE, true);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.IDENTITY_DESCRIPTION, null);
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String index = element.getSnmpKey().toString();
        int pos = index.lastIndexOf(".") + 1;
        index = index.substring(pos);
        Integer idIndex = new Integer(index);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastIdIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastIdIndex, 0, newArray, 0, lastIdIndex.length);
            newArray[agentIndex] = idIndex;
            lastIdIndex = newArray;
        } else if (lastIdIndex[agentIndex] == null || idIndex > lastIdIndex[agentIndex]) {
            IdentityConfigurator.lastIdIndex[agentIndex] = idIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getSnmpAgentFromParameter();
        Integer[] integerArray = lastIdIndex;
        synchronized (lastIdIndex) {
            CommKeyClassId targetForACL;
            SrString[] names = (SrString[])element.removeParameter(ParameterCode.IDENTITY_NAMES);
            if (names != null) {
                this.m_identityNamesFroCreation = names;
            }
            if ((targetForACL = (CommKeyClassId)element.removeParameter(ParameterCode.ACL_ENTRY_TARGET_PARENT)) != null) {
                this.m_idOfTargetForACLUpdate = targetForACL;
            }
            if (lastIdIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastIdIndex, 0, newArray, 0, lastIdIndex.length);
                newArray[agentIndex] = new Integer(0);
                lastIdIndex = newArray;
            } else if (lastIdIndex[agentIndex] == null) {
                IdentityConfigurator.lastIdIndex[agentIndex] = new Integer(0);
            }
            this.getAll(agentIndex, null, null);
            int newIndex = lastIdIndex[agentIndex] + 1;
            SnmpCommKey snmpCommKey = new SnmpCommKey("1." + newIndex, agentIndex);
            element.setCommKey(snmpCommKey);
            super.internalCreate(element);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList identList = this.getAll(snmpAgentIndex, null, null);
        if (identList.size() > 0) {
            IdentityXConfigurator identXConfig = new IdentityXConfigurator();
            ConfigElementDataList identXList = identXConfig.getAll(snmpAgentIndex, null, null);
            this.mergeElementLists(identList, identXList, true);
            this.sendDiscoveredElementsToEventMgr(identList, vSwitchData);
        }
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList identList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (identList.size() > 0) {
            SRPCredentialsConfigurator srpCredConfig;
            ConfigElementDataList srpCredList;
            CHAPCredentialsConfigurator chapCredConfig;
            ConfigElementDataList chapCredList;
            IdentityXConfigurator identXConfig = new IdentityXConfigurator();
            ConfigElementDataList identXList = identXConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            this.mergeElementLists(identList, identXList, true);
            IdentityNameConfigurator identityNameConfig = new IdentityNameConfigurator();
            ConfigElementDataList identityNameList = identityNameConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            if (identityNameList.size() > 0) {
                identList.addAll(identityNameList);
            }
            if ((chapCredList = (chapCredConfig = new CHAPCredentialsConfigurator()).getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED)).size() > 0) {
                identList.addAll(chapCredList);
            }
            if ((srpCredList = (srpCredConfig = new SRPCredentialsConfigurator()).getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED)).size() > 0) {
                identList.addAll(srpCredList);
            }
        }
        return identList;
    }

    @Override
    public void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
        ClassID elementClassId = element.getClassId();
        SnmpCommKey elementCommKey = element.getSnmpKey();
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        ConfigElementData newElement = new ConfigElementData(elementCommKey, elementClassId);
        IdentityXConfigurator identXConfig = new IdentityXConfigurator();
        identXConfig.internalRead(newElement);
        element.addParameter(newElement.getParametersList());
        if (retrievedElements != null) {
            retrievedElements.add(element);
        }
        IdentityNameConfigurator identityNameConfig = new IdentityNameConfigurator();
        ConfigElementData identityNameElement = new ConfigElementData(ClassID.IDENTITY_NAME);
        ConfigElementDataList identityNamesList = identityNameConfig.internalReadForSuperPrefix(snmpAgentIndex, element, identityNameElement);
        if (retrievedElements != null) {
            retrievedElements.addAll(identityNamesList);
        }
        CHAPCredentialsConfigurator chapCredConfig = new CHAPCredentialsConfigurator();
        ConfigElementData chapCredElement = new ConfigElementData(ClassID.CHAP_CREDENTIALS);
        ConfigElementDataList chapCredsList = chapCredConfig.internalReadExtendedForSuperPrefix(snmpAgentIndex, element, chapCredElement);
        if (retrievedElements != null) {
            retrievedElements.addAll(chapCredsList);
        }
        SRPCredentialsConfigurator srpCredConfig = new SRPCredentialsConfigurator();
        ConfigElementData srpCredElement = new ConfigElementData(ClassID.SRP_CREDENTIALS);
        ConfigElementDataList srpCredsList = srpCredConfig.internalReadExtendedForSuperPrefix(snmpAgentIndex, element, srpCredElement);
        if (retrievedElements != null) {
            retrievedElements.addAll(srpCredsList);
        }
    }

    @Override
    public void postSendCreateEvent(ConfigElementData identityElement) throws SrCommException {
        if (this.m_identityNamesFroCreation != null && this.m_identityNamesFroCreation.length > 0) {
            IdentityNameConfigurator identityNameConfigurator = new IdentityNameConfigurator();
            identityNameConfigurator.addNamesToIdentityElement(identityElement, this.m_identityNamesFroCreation);
        }
        if (this.m_idOfTargetForACLUpdate != null) {
            TargetAuthorizationConfigurator aclEntriesConfigurator = new TargetAuthorizationConfigurator();
            aclEntriesConfigurator.attachIdentityToTargetACL(identityElement, this.m_idOfTargetForACLUpdate);
        }
    }

    public void changeIdentityPurpose(CommKeyClassId identityCommKeyclassId, IdentityPurposeConstant purpose) throws SrCommException {
        ConfigElementData identityElement = new ConfigElementData(identityCommKeyclassId);
        identityElement.addParameter(new Parameter(ParameterCode.IDENTITY_PURPOSE, purpose));
        this.internalChange(identityElement);
        this.internalReadFields(identityElement);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(identityElement, (Object)this);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return IdentityConfigurator.getNextIncrementalIndex(aElement.getCommKeyClassId());
    }
}

