/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.identity;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.identity.CredentialsExtentionConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.Util;
import java.util.HashMap;
import java.util.Vector;

public abstract class CredentialsConfigurator
extends ElementConfigurator {
    public static Vector<HashMap<Long, Long>> lastNameIndex = new Vector();
    public static SrOidType SRP_OID = new SrOidType("1.3.6.1.4.1.10059.1.11.4.1.1.1.2");
    public static SrOidType CHAP_OID = new SrOidType("1.3.6.1.4.1.10059.1.11.4.1.1.1.3");
    protected SrOidType myOidType;
    protected CredentialsExtentionConfigurator extentionConfigurator;

    public CredentialsConfigurator(ClassID classId) {
        super(classId, "ipsAuthCredentialAttributesTable", MibItem.CREDENTIALS_RS, MibItem.IDENTITY_EXTENTION_TBL_LAST_UPDATE);
        this.initExtentionConfigurator();
    }

    protected abstract void initExtentionConfigurator();

    public CredentialsConfigurator(ClassID classId, String tableName, MibItem rowStatus) {
        super(classId, tableName, rowStatus, MibItem.IDENTITY_EXTENTION_TBL_LAST_UPDATE);
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        this.keepTrackOfLastIndex(element, list);
        Object parent = element.getValue(ParameterCode.CREDENTIALS_PARENT);
        if (parent == null) {
            CommKey[] commKey = element.getCommKey();
            String key = commKey[0].getKey();
            int pos = key.lastIndexOf(".");
            key = key.substring(0, pos);
            ClassID classId = ClassID.IDENTITY;
            char snmpAgent = element.getMyFirstSnmpAgentIndex();
            if (snmpAgent >= lastNameIndex.size()) {
                lastNameIndex.addElement(this.getInitializeMap());
            }
            SnmpCommKey identCommKey = new SnmpCommKey(key, element.getMyFirstSnmpAgentIndex());
            CommKeyClassId commKeyClassId = new CommKeyClassId(identCommKey, classId);
            element.setValue(ParameterCode.CREDENTIALS_PARENT, commKeyClassId);
        }
    }

    private void keepTrackOfLastIndex(ConfigElementData element, CommVarBindList list) {
        String fullIndex = element.getSnmpKey().toString();
        long[] resolvedIndices = Util.stringToLongArray(fullIndex);
        long credIndex = resolvedIndices[resolvedIndices.length - 1];
        long identIndex = resolvedIndices[resolvedIndices.length - 2];
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastNameIndex.size() <= agentIndex || lastNameIndex.elementAt(agentIndex) == null) {
            Util.ensureCapacityAndAdd(lastNameIndex, agentIndex, this.getInitializeMap());
        } else {
            HashMap<Long, Long> map = lastNameIndex.get(agentIndex);
            Long recentLastCred = map.get(identIndex);
            if (recentLastCred == null || (long)recentLastCred.intValue() < credIndex) {
                map.put(identIndex, credIndex);
            }
        }
    }

    protected final HashMap<Long, Long> getInitializeMap() {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        map.put(0L, 0L);
        return map;
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList credList = this.getAllExtended(snmpAgentIndex, null, null);
        this.sendDiscoveredElementsToEventMgr(credList, vSwitchData);
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList credList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (credList.size() > 0) {
            for (int i = credList.size() - 1; i >= 0; --i) {
                ConfigElementData element = (ConfigElementData)credList.get(i);
                Object value = element.getValue(ParameterCode.CREDENTIALS_AUTH_METHOD);
                if (value.equals(this.myOidType)) continue;
                credList.remove(element);
            }
        }
        return credList;
    }

    @Override
    protected void convertParamsToVarBinds(ConfigElementData element, CommVarBindList list) {
        if (list.isEmpty()) {
            super.convertParamsToVarBinds(element, list);
            return;
        }
        CommKey[] commKeys = element.getCommKey();
        HashMap<ParameterCodes, Object> map = element.getParametersList();
        for (ParameterCode parameterCode : map.keySet()) {
            Object tmpObj = map.get(parameterCode);
            if (tmpObj != null) {
                SrType value = null;
                try {
                    value = (SrType)tmpObj;
                }
                catch (ClassCastException e) {
                    continue;
                }
                Parameter tmpParam = new Parameter(parameterCode, value);
                if (parameterCode.equals(ParameterCode.CREDENTIALS_AUTH_METHOD)) {
                    list.add(1, this.createCommVarBinds(commKeys, tmpParam).get(0));
                    continue;
                }
                list.add(this.createCommVarBinds(commKeys, tmpParam));
                continue;
            }
            Parameter tmpParam = new Parameter(parameterCode, null);
            list.add(this.createCommVarBinds(commKeys, tmpParam));
        }
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return CredentialsConfigurator.getNextIncrementalIndex(aElement.getCommKeyClassId());
    }
}

