/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr.cf;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.AnnexConfigurator;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.AnnexControlFunction;
import com.sanrad.nms.server.util.types.AnnexData;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.CFErrorReasonConstant;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import java.util.ArrayList;
import java.util.Collections;

public abstract class CfConfigurator
extends AnnexConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public CfConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib, ClassID sourceClassId) {
        super(classId, tableName, rowStatusMib, lastUpdateMib, sourceClassId);
    }

    @Override
    protected AnnexData generateAnnexValuesFromBase(ConfigElementData ced) {
        CommKeyClassId index = new CommKeyClassId(this.calculateCommKeyOfBase(ced), this.m_baseClassId);
        CFStateConstant cfState = (CFStateConstant)ced.removeParameter(MasterParameterCode.CF_STATE.getParameterCode(this.getListOfParams()));
        CFErrorReasonConstant reason = (CFErrorReasonConstant)ced.removeParameter(MasterParameterCode.CF_REASON.getParameterCode(this.getListOfParams()));
        SrType action = (SrType)ced.removeParameter(this.getCfActionParameterCode());
        return new AnnexControlFunction(index, action, cfState, reason);
    }

    @Override
    protected SnmpCommKey calculateCommKeyOfBase(ConfigElementData ced) {
        CommKey[] commKey = new CommKey[ced.getCommKey().length];
        commKey = ced.getCommKey();
        return CommKeyUtil.getParentCommKey(CommKeyUtil.getSnmpCommKey(commKey));
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        SrOidType action = (SrOidType)element.removeParameter(MasterParameterCode.CF_OID.getParameterCode(this.getListOfParams()));
        SrType value = (SrType)element.removeParameter(MasterParameterCode.CF_VALUE.getParameterCode(this.getListOfParams()));
        element.setValue(this.getCfActionParameterCode(), DsnmpUtil.getSrValueOfAction(action, value));
        super.readDiscoverPostOperation(element, list);
    }

    @Override
    protected void delay(ConfigElementData baseElement, CheckListConfigElementData annexElement) throws SrCommException {
        SrDateAndTime dateAndTime = (SrDateAndTime)baseElement.getParametersList().get(MasterParameterCode.CF_DATE_AND_TIME.getParameterCode(this.getListOfParams()));
        ConfigElementDataList annexValues = null;
        ArrayList list = null;
        SrDateAndTime date = null;
        boolean isCFTableEmpty = true;
        int counter = 0;
        do {
            if ((list = (annexValues = this.getAll(baseElement.getMyFirstSnmpAgentIndex(), null, annexElement)).getValues(MasterParameterCode.CF_DATE_AND_TIME.getParameterCode(this.getListOfParams()))).isEmpty()) {
                isCFTableEmpty = true;
            } else {
                date = (SrDateAndTime)Collections.max(list);
                isCFTableEmpty = false;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, e, "Interrupted during sleep for CF to take place. CF: ", annexElement);
            }
        } while ((isCFTableEmpty || date.equals(dateAndTime)) && counter++ < 5000);
    }

    protected abstract ParameterCode getCfActionParameterCode();

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

