/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.dr.PairConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.util.SrConstantsBundleKeys;
import java.util.HashMap;

public class SyncPairConfigurator
extends PairConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final HashMap<ParameterCodes, Object> listOfParams = new HashMap();

    public SyncPairConfigurator() {
        super(ClassID.SYNC_PAIR, "srSynchPairTable", MibItem.DR_PAIR_ROW_STATUS, MibItem.DR_SYNC_PAIR_TABLE_LAST_UPDATE, new ClassID[]{ClassID.CF_SYNC_PAIR});
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        return listOfParams;
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        element.setValue(ParameterCode.DR_PAIR_TYPE, DRPairTypeConstant.SYNC);
        char agentIndex = element.getSnmpAgentFromParameter();
        SnmpCommKey newPairIndex = super.getPairIndexNext(agentIndex);
        ConfigElementData pairElement = new ConfigElementData(newPairIndex, this.myClassId);
        super.addParametersForCreate(element, pairElement);
        super.internalCreate(pairElement);
        ConfigElementData syncPairElement = new ConfigElementData(pairElement.getCommKeyClassId());
        this.addParametersForCreate(element, syncPairElement);
        this.internalChange(syncPairElement);
        element.removeAll();
        element.setCommKeyClassId(syncPairElement.getCommKeyClassId());
    }

    @Override
    ConfigElementData addParametersForCreate(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_SYNC_PAIR_ROLE);
        return dest;
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        element.setClassId(this.myClassId);
        SrTrapType trapType = trap.getTrapType();
        if (trapType == SrTrapType.SYNC_PAIR_STATE_CHANGED) {
            if (element.getSnmpKey() == null || element.getSnmpKey() != null && element.getSnmpKey().getKey() != null) {
                ConfigElementData fullInfoElement = new ConfigElementData(element.getCommKeyClassId());
                this.internalRead(fullInfoElement);
                SrEventHandler.getEventMgr().sendChangeElementEvent(fullInfoElement, (Object)trap);
            }
        } else if (trapType == SrTrapType.PAIR_CREATED) {
            this.handleCreateTrap(element, trap);
        } else if (trapType == SrTrapType.PAIR_DELETED) {
            SrEventHandler.getEventMgr().sendRemoveElementEvent(element, trap);
        }
    }

    private void handleCreateTrap(ConfigElementData element, SrTrap trap) throws SrCommException {
        RowStatusConstants rowStatus = (RowStatusConstants)element.getValue(ParameterCode.DR_PAIR_ROW_STATUS);
        if (rowStatus.equals(RowStatusConstants.ROW_STATUS_ACTIVE)) {
            this.internalRead(element);
            SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)trap);
        }
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        super.internalChange(element);
        if (element.containsParameter(ParameterCode.DR_SYNC_PAIR_ACTIVATE)) {
            try {
                Thread.sleep(Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.WAIT_FOR_ACTIVATE_COMMAND)));
            }
            catch (InterruptedException e) {
                theLogger.logAndAssert(SrLogCategories.LEGACY, e);
            }
        }
    }

    static {
        listOfParams.put(ParameterCode.DR_PAIR_TYPE, null);
        listOfParams.put(ParameterCode.DR_PAIR_PRIMARY_ID, null);
        listOfParams.put(ParameterCode.DR_PAIR_SECONDARY_ID, null);
        listOfParams.put(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, null);
        listOfParams.put(ParameterCode.DR_PAIR_MODE, null);
        listOfParams.put(ParameterCode.DR_PAIR_STATE, null);
        listOfParams.put(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, null);
        listOfParams.put(ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED, null);
        listOfParams.put(ParameterCode.DR_SYNC_PAIR_ROLE, null);
        listOfParams.put(ParameterCode.DR_SYNC_PAIR_REPLICATION_STATE, null);
        listOfParams.put(ParameterCode.DR_SYNC_PAIR_ACTIVATE, null);
    }
}

