/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.util.Util;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class PiTConfigurator
extends ElementConfigurator {
    public PiTConfigurator(ClassID classId, String table) {
        super(classId, table, null, null);
    }

    @Override
    public void internalChange(ConfigElementData element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void internalCreate(ConfigElementData element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void internalRemove(ConfigElementData element) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String pitIndex = element.getSnmpKey().getKey();
        String parentIndex = pitIndex.substring(0, pitIndex.indexOf(46));
        SnmpCommKey parentCommKey = new SnmpCommKey(parentIndex, element.getMyFirstSnmpAgentIndex());
        element.setValue(ParameterCode.DR_PIT_PARENT_ID, new CommKeyClassId(parentCommKey, this.getParentClassID(parentIndex, element.getMyFirstSnmpAgentIndex())));
        String dateStr = pitIndex.substring(pitIndex.indexOf(46) + 1);
        long[] dateLongArr = Util.stringToLongArray(dateStr);
        element.setValue(ParameterCode.DR_PIT_DATE, new SrDateAndTime(dateLongArr));
    }

    @Override
    public void internalRead(ConfigElementData element) throws SrCommException {
        super.internalRead(element);
        if (element.getValue(ParameterCode.DR_PIT_LAST_UPDATE) == null) {
            SrTimeTicks time = (SrTimeTicks)this.getScalarFromComm(MibItem.VSWITCH_SYS_UP_TIME, element.getSnmpAgentFromParameter());
            element.setValue(ParameterCode.DR_PIT_LAST_UPDATE, time);
        }
    }

    @Override
    public ConfigElementDataList refreshTableFields(ConfigElementData fieldsData) throws SrCommException {
        CommKeyClassId parentKey = (CommKeyClassId)fieldsData.getValue(ParameterCode.DR_PIT_PARENT_ID);
        if (parentKey != null) {
            CommKeyClassId[] currentPits = (CommKeyClassId[])fieldsData.getValue(ParameterCode.DR_PIT_LIST);
            char agentIndex = fieldsData.getSnmpAgentFromParameter();
            SnmpCommKey parentIndex = CommKeyUtil.getSpecificSnmpKey(parentKey, agentIndex);
            ConfigElementDataList subTable = this.getAllByPrefix(agentIndex, parentIndex.getKey());
            SrTimeTicks time = (SrTimeTicks)this.getScalarFromComm(MibItem.VSWITCH_SYS_UP_TIME, agentIndex);
            if (subTable != null) {
                ArrayList<CommKeyClassId> currentPitsList = new ArrayList<CommKeyClassId>(Arrays.asList(currentPits));
                int i = subTable.size();
                while (i-- > 0) {
                    ConfigElementData pitElement = (ConfigElementData)subTable.getElementDataAt(i);
                    pitElement.setValue(ParameterCode.DR_PIT_LAST_UPDATE, time);
                    currentPitsList.remove(pitElement.getCommKeyClassId());
                }
                EventMgr.getInstance().sendRefreshElementEvent(subTable, (Object)this);
                i = currentPitsList.size();
                while (i-- > 0) {
                    CommKeyClassId deletedKey = currentPitsList.get(i);
                    if (CommKeyUtil.getSpecificCommKey(deletedKey, agentIndex) == null) continue;
                    ConfigElementData deletedElement = new ConfigElementData(deletedKey);
                    deletedElement.addParameterToElement(fieldsData, ParameterCode.VSWITCH_ID);
                    EventMgr.getInstance().sendRemoveElementEvent(deletedElement, this);
                }
            }
            ConfigElementData parentData = new ConfigElementData(parentKey);
            parentData.setValue(ParameterCode.DR_PIT_PARENT_LAST_UPDATE, time);
            parentData.addParameterToElement(fieldsData, ParameterCode.VSWITCH_ID);
            EventMgr.getInstance().sendChangeElementEvent(parentData, (Object)this);
            return new ConfigElementDataList();
        }
        return super.refreshTableFields(fieldsData);
    }

    protected abstract ClassID getParentClassID(String var1, char var2) throws SrCommException;

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

