/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.exception.ConfigurationErrorException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.LUNConfigurator;
import com.sanrad.nms.server.mgr.dr.AsyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.DRConfigurator;
import com.sanrad.nms.server.mgr.dr.SyncPairConfigurator;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import java.util.HashMap;

public class PairConfigurator
extends DRConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public PairConfigurator() {
        this(ClassID.GENERAL_PAIR, "srPairTable", null, null, null);
    }

    protected PairConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib, ClassID[] cf_classId) {
        super(classId, tableName, rowStatusMib, lastUpdateMib, cf_classId);
    }

    SnmpCommKey getPairIndexNext(char agentIndex) throws SrCommException {
        Integer nextIndex = (Integer)this.getScalarFromComm(MibItem.DR_PAIR_INDEX_NEXT, agentIndex).value();
        return new SnmpCommKey(nextIndex.toString(), agentIndex);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        this.prepareVolumeIDsForMIB(element);
        CommKeyClassId luID = (CommKeyClassId)element.removeParameter(ParameterCode.VIRTUAL_VOLUME_LU);
        SrString serialNumber = (SrString)element.removeParameter(ParameterCode.LU_SERIAL_NUMBER);
        if (luID != null && serialNumber != null) {
            CommKeyClassId luIDSpecific = CommKeyUtil.getSpecificCommKeyClassId(luID, element.getSnmpAgentFromParameter());
            ConfigElementData luData = new ConfigElementData(luIDSpecific);
            luData.setValue(ParameterCode.LU_SERIAL_NUMBER, serialNumber);
            LUNConfigurator luConfigurator = new LUNConfigurator();
            luConfigurator.internalChange(luData);
            luConfigurator.internalRead(luData);
            EventMgr.getInstance().sendChangeElementEvent(luData, (Object)this);
        }
        super.internalCreate(element);
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        this.prepareVolumeIDsForMIB(element);
        super.internalChange(element);
    }

    @Override
    public void postSendRemoveEvent(ConfigElementData element) throws SrCommException {
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        SrGauge primaryID = (SrGauge)element.getValue(ParameterCode.DR_PAIR_PRIMARY_ID);
        SrGauge secondaryID = (SrGauge)element.getValue(ParameterCode.DR_PAIR_SECONDARY_ID);
        if (primaryID != null) {
            CommKeyClassId primaryVolId = VolumeConfigurator.getCkidByVolumeIndex("1." + primaryID, agentIndex);
            if (primaryVolId == null) {
                throw new ConfigurationErrorException("Could not match DR Pair Volume ID 1." + primaryID + " to any volume");
            }
            element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, primaryVolId);
        }
        if (secondaryID != null) {
            CommKeyClassId secondaryVolId = VolumeConfigurator.getCkidByVolumeIndex("1." + secondaryID, agentIndex);
            if (secondaryVolId == null) {
                throw new ConfigurationErrorException("Could not match DR Pair Volume ID 1." + secondaryID + " to any volume");
            }
            element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, secondaryVolId);
        }
        super.readDiscoverPostOperation(element, list);
    }

    private void prepareVolumeIDsForMIB(ConfigElementData element) throws SrCommException {
        CommKeyClassId storageKey;
        ConfigElementData storageElement;
        CommKeyClassId primaryID = (CommKeyClassId)element.getValue(ParameterCode.DR_PAIR_PRIMARY_ID);
        CommKeyClassId secondaryID = (CommKeyClassId)element.getValue(ParameterCode.DR_PAIR_SECONDARY_ID);
        CommKeyClassId vSwitchID = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        if (primaryID != null) {
            SrGauge primaryVol = this.createVolumeIDForPair(primaryID, vSwitchID);
            element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, primaryVol);
            if (secondaryID == null) {
                storageElement = this.createISCSIStorage(element);
                storageKey = storageElement.getCommKeyClassId();
                element.setValue(ParameterCode.DR_PAIR_LOCAL_SECONDARY_ID, storageKey);
                SrGauge secondaryVol = this.createVolumeIDForPair(storageKey, vSwitchID);
                element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, secondaryVol);
            }
        }
        if (secondaryID != null) {
            SrGauge secondaryVol = this.createVolumeIDForPair(secondaryID, vSwitchID);
            element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, secondaryVol);
            if (primaryID == null) {
                storageElement = this.createISCSIStorage(element);
                storageKey = storageElement.getCommKeyClassId();
                element.setValue(ParameterCode.DR_PAIR_REMOTE_PRIMARY_ID, storageKey);
                SrGauge primaryVol = this.createVolumeIDForPair(storageElement.getCommKeyClassId(), vSwitchID);
                element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, primaryVol);
            }
        }
        CommKeyClassId configuredDisk = null;
        configuredDisk = (CommKeyClassId)element.removeParameter(ParameterCode.DR_PAIR_LOCAL_SECONDARY_ID);
        if (configuredDisk == null) {
            configuredDisk = (CommKeyClassId)element.removeParameter(ParameterCode.DR_PAIR_REMOTE_PRIMARY_ID);
        }
        if (configuredDisk != null) {
            CommKeyClassId configuredDiskSpecific = CommKeyUtil.getSpecificCommKeyClassId(configuredDisk, vSwitchID);
            SrType blockSize = (SrType)element.removeParameter(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
            SrType blocksNum = (SrType)element.removeParameter(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
            ConfigElementData storageElement2 = new ConfigElementData(configuredDiskSpecific);
            storageElement2.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, blockSize);
            storageElement2.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, blocksNum);
            new PhysicalStorageConfigurator().internalChange(storageElement2);
        }
    }

    private ConfigElementData createISCSIStorage(ConfigElementData dataSource) throws SrCommException {
        SrType target = (SrType)dataSource.removeParameter(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
        SrType lun = (SrType)dataSource.removeParameter(ParameterCode.PHYSICAL_STORAGE_LUN);
        PhysicalStorageConfigurator physConf = new PhysicalStorageConfigurator();
        ConfigElementData storageElement = null;
        boolean isStorageAlreadyExists = false;
        ConfigElementDataList disks = physConf.getAll(dataSource.getSnmpAgentFromParameter(), null, null);
        int i = disks.size();
        while (i-- > 0) {
            ConfigElementData disk = (ConfigElementData)disks.getElementDataAt(i);
            SrType diskTarget = (SrType)disk.getValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
            SrType diskLun = (SrType)disk.getValue(ParameterCode.PHYSICAL_STORAGE_LUN);
            if (!diskTarget.equals(target) || !diskLun.equals(lun)) continue;
            isStorageAlreadyExists = true;
            storageElement = disk;
        }
        if (!isStorageAlreadyExists) {
            storageElement = new ConfigElementData(ClassID.DIRECT_ACCESS_DEVICE);
            storageElement.addParameterToElement(dataSource, ParameterCode.VSWITCH_ID);
            storageElement.setValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, target);
            storageElement.setValue(ParameterCode.PHYSICAL_STORAGE_LUN, lun);
            storageElement.setValue(ParameterCode.PHYSICAL_STORAGE_TYPE, PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE);
            storageElement.setValue(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI);
            physConf.internalCreate(storageElement);
            physConf.internalRead(storageElement);
            EventMgr.getInstance().sendAddElementEvent(storageElement, (Object)this);
            physConf.postCreateEvent(storageElement);
        } else {
            EventMgr.getInstance().sendRefreshElementEvent(storageElement, (Object)this);
        }
        return storageElement;
    }

    private SrGauge createVolumeIDForPair(CommKeyClassId storageId, CommKeyClassId vSwitchData) throws SrCommException {
        String volDomainKey = null;
        if (storageId.getClassID().isVolume()) {
            volDomainKey = CommKeyUtil.getSpecificCommKey(storageId, vSwitchData.getMyFirstSnmpAgentIndex()).getKey();
        } else if (storageId.getClassID().isStorage()) {
            SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
            volDomainKey = simpleCnf.createSimpleVolume(storageId, vSwitchData).getKey();
        }
        if (volDomainKey != null) {
            return new SrGauge(volDomainKey.substring(volDomainKey.indexOf(46) + 1));
        }
        return null;
    }

    ConfigElementData addParametersForCreate(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_TYPE);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_PRIMARY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_SECONDARY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
        dest.addParameterToElement(src, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
        dest.addParameterToElement(src, ParameterCode.PHYSICAL_STORAGE_LUN);
        dest.addParameterToElement(src, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
        dest.addParameterToElement(src, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
        dest.addParameterToElement(src, ParameterCode.LU_SERIAL_NUMBER);
        dest.addParameterToElement(src, ParameterCode.VIRTUAL_VOLUME_LU);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_LOCAL_SECONDARY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_REMOTE_PRIMARY_ID);
        return dest;
    }

    @Override
    protected SrSnmpVarBind createRowStatusVarBind(CommKey commKey) {
        SrOid oid = new SrOid(this.myRowStatusMib.toString(), commKey.getKey());
        SrSnmpVarBind srVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_CREATE_AND_WAIT);
        return srVarBind;
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        SrTrapType type = trap.getTrapType();
        if (type == SrTrapType.PAIR_CREATED || type == SrTrapType.PAIR_DELETED) {
            DRPairTypeConstant pType = (DRPairTypeConstant)element.getValue(ParameterCode.DR_PAIR_TYPE);
            if (pType == DRPairTypeConstant.SYNC) {
                element.setClassId(ClassID.SYNC_PAIR);
                new SyncPairConfigurator().trapProccessingPostOperation(element, trap);
            } else if (pType == DRPairTypeConstant.ASYNC) {
                element.setClassId(ClassID.ASYNC_PAIR);
                new AsyncPairConfigurator().trapProccessingPostOperation(element, trap);
            }
        }
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        SrTrapType trapType = trap.getTrapType();
        if (SrTrapType.PAIR_CREATED.equals(trapType) || SrTrapType.PAIR_DELETED.equals(trapType)) {
            return MibItem.DR_PAIR_ROW_STATUS;
        }
        if (SrTrapType.ASYNC_PAIR_STATE_CHANGED.equals(trapType) || SrTrapType.SYNC_PAIR_STATE_CHANGED.equals(trapType)) {
            return MibItem.DR_PAIR_MODE;
        }
        return null;
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        boolean ret = super.readAfterCreate(element);
        char snmpAgent = element.getMyFirstSnmpAgentIndex();
        DataMgrAOImpl.getInstance().postPairCreationRefreshOperation(snmpAgent);
        return ret;
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList generalPairList = this.getAll("srPairTable", snmpAgentIndex, lastUpdate, null);
        ConfigElementDataList specificPairList = this.getAll(this.myTableName, snmpAgentIndex, lastUpdate, null);
        ConfigElementDataList mergedList = new ConfigElementDataList();
        HashMap<SnmpCommKey, ElementData> generalPairMap = this.createMapFromList(generalPairList);
        HashMap<SnmpCommKey, ElementData> specificPairMap = this.createMapFromList(specificPairList);
        for (SnmpCommKey key : generalPairMap.keySet()) {
            ConfigElementData generalPairElement = (ConfigElementData)generalPairMap.get(key);
            ConfigElementData specificPairElement = (ConfigElementData)specificPairMap.get(key);
            if (specificPairElement == null) continue;
            specificPairElement.addParameter(generalPairElement.getParametersList());
            mergedList.add(specificPairElement);
        }
        if (checkListElement != null) {
            this.buildCheckListElement(mergedList, checkListElement, snmpAgentIndex, lastUpdate);
        }
        return mergedList;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        char agentIndex = aElement.getSnmpAgentFromParameter();
        SnmpCommKey newPairIndex = this.getPairIndexNext(agentIndex);
        return new CommKeyClassId(newPairIndex, aElement.getClassId());
    }
}

