/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.dr.AsyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.ConsistencyGroupConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;

public class ExtendedPairConfigurator
extends ConsistencyGroupConfigurator {
    public ExtendedPairConfigurator() {
        super(ClassID.EXTENDED_PAIR);
    }

    public ConfigElementData getTestElement(char agentIndex) {
        ConfigElementData element = new ConfigElementData(new SnmpCommKey(agentIndex), this.myClassId);
        element.setValue(ParameterCode.VSWITCH_ID, new CommKeyClassId(new SnmpCommKey(agentIndex), ClassID.VSWITCH));
        element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, DRRoleConstant.LOCAL);
        element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_START_AT, new SrDateAndTime(new Long(8798L)));
        element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_TYPE, PolicyTypeConstant.REPLICATE_PERIODIC);
        element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_RUN_EVERY, new SrInteger(125));
        element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_START_AT, new SrDateAndTime(new Long(8798L)));
        element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_TYPE, PolicyTypeConstant.REPLICATE_PERIODIC);
        element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_RUN_EVERY, new SrInteger(125));
        element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_TYPE, PolicyTypeConstant.MERGE_ONLY_CURRENT);
        element.setValue(ParameterCode.DR_PAIR_TYPE, DRPairTypeConstant.ASYNC);
        element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, new CommKeyClassId(new SnmpCommKey("1.1.0.0.0.0.0.127.255.255", agentIndex), ClassID.SUB_DIRECT_ACCESS_DEVICE));
        element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, new CommKeyClassId(new SnmpCommKey("1.2", agentIndex), ClassID.DIRECT_ACCESS_DEVICE));
        element.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, DRPairInitialSyncTypeConstant.NONE);
        element.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, new CommKeyClassId(new SnmpCommKey("1.7", agentIndex), ClassID.JOURNAL_VOLUME));
        return element;
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getSnmpAgentFromParameter();
        AsyncPairConfigurator apConf = new AsyncPairConfigurator();
        SnmpCommKey newCGIndex = this.getConsistencyGroupIndexNext(agentIndex);
        element.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, new CommKeyClassId(newCGIndex, ClassID.EXTENDED_PAIR));
        apConf.internalCreate(element);
        SnmpCommKey newAsyncPairIndex = element.getSnmpKey();
        element.setClassId(this.myClassId);
        element.setCommKey(newCGIndex);
        super.internalChange(element);
        element.removeAll();
        element.setValue(ParameterCode.DR_ASYNC_PAIR_ID, new CommKeyClassId(newAsyncPairIndex, ClassID.ASYNC_PAIR));
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        CommKeyClassId asyncPairKey = (CommKeyClassId)element.getValue(ParameterCode.DR_ASYNC_PAIR_ID);
        if (asyncPairKey != null) {
            AsyncPairConfigurator apConf = new AsyncPairConfigurator();
            ConfigElementData apData = new ConfigElementData(asyncPairKey);
            apConf.addParametersForChange(element, apData);
            apConf.internalChange(apData);
        }
        super.internalChange(element);
    }

    @Override
    public boolean readAfterChange(ConfigElementData element) throws SrCommException {
        CommKeyClassId asyncPairKey = (CommKeyClassId)element.getValue(ParameterCode.DR_ASYNC_PAIR_ID);
        if (asyncPairKey != null) {
            AsyncPairConfigurator apConf = new AsyncPairConfigurator();
            ConfigElementData apData = new ConfigElementData(asyncPairKey);
            apConf.internalRead(apData);
            apData.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, element.getCommKeyClassId());
            SrEventHandler.getEventMgr().sendChangeElementEvent(apData, (Object)this);
        }
        ConfigElementData cgElement = new ConfigElementData(element.getCommKeyClassId());
        this.internalRead(cgElement);
        SrEventHandler.getEventMgr().sendChangeElementEvent(cgElement, (Object)this);
        return true;
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        boolean ret = super.readAfterCreate(element);
        DataMgrAOImpl.getInstance().postPairCreationRefreshOperation(element.getMyFirstSnmpAgentIndex());
        return ret;
    }
}

