/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.AsyncPairControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.CGControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.SyncPairControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyParamConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRGroupOwnedByConstant;
import com.sanrad.nms.server.util.types.constants.MibItemConstant;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import java.util.HashMap;
import java.util.Iterator;

public class DRDiscoveryConfigurator
extends ElementConfigurator {
    @Override
    public void discover(CommKeyClassId vSwitch) throws SrCommException {
        char agentIndex = vSwitch.getMyFirstSnmpAgentIndex();
        ConfigElementDataList consistencyGroupList = this.convertVarBindList(this.commGetAll("srDRGroupTable", agentIndex), ClassID.CONSISTENCY_GROUP, MibItem.DR_GROUP_ROW_STATUS);
        HashMap<SnmpCommKey, ElementData> consistencyGroupMap = this.createMapFromList(consistencyGroupList);
        ConfigElementDataList virtGroupList = this.convertVarBindList(this.commGetAll("srVirtGroupTable", agentIndex), null, null);
        HashMap<SnmpCommKey, ElementData> virtGroupMap = this.createMapFromList(virtGroupList);
        ConfigElementDataList pairList = this.convertVarBindList(this.commGetAll("srPairTable", agentIndex), null, null);
        HashMap<SnmpCommKey, ElementData> pairMap = this.createMapFromList(pairList);
        ConfigElementDataList asyncPairList = this.convertVarBindList(this.commGetAll("srAsyncPairTable", agentIndex), ClassID.ASYNC_PAIR, null);
        ConfigElementDataList syncPairList = this.convertVarBindList(this.commGetAll("srSynchPairTable", agentIndex), ClassID.SYNC_PAIR, null);
        ConfigElementDataList volumeList = new VolumeConfigurator().getAll(agentIndex, null, null);
        HashMap<SnmpCommKey, ElementData> volumeMap = this.createMapFromList(volumeList);
        ConfigElementDataList policyList = this.convertVarBindList(this.commGetAll("srPolicyTable", agentIndex), ClassID.POLICY_START, MibItem.DR_POLICY_ROW_STATUS);
        HashMap<SnmpCommKey, ElementData> policyMap = this.createMapFromList(policyList);
        ConfigElementDataList policyParamList = this.convertVarBindList(this.commGetAll("srPolicyParamTable", agentIndex), ClassID.POLICY_PARAMS, MibItem.DR_POLICY_PARAM_ROW_STATUS);
        this.sendPoliciesEvent(policyList);
        this.sendPolicyParamsEvent(policyParamList);
        this.sendConsistencyGroupsAndExtendedPairsEvent(consistencyGroupList, virtGroupMap, policyMap);
        this.sendAsyncPairsEvent(asyncPairList, pairMap, volumeMap, consistencyGroupMap);
        this.sendSyncPairsEvent(syncPairList, pairMap, volumeMap);
        new CGControlFunctionsConfigurator().discover(vSwitch);
        new AsyncPairControlFunctionsConfigurator().discover(vSwitch);
        new SyncPairControlFunctionsConfigurator().discover(vSwitch);
    }

    private void sendConsistencyGroupsAndExtendedPairsEvent(ConfigElementDataList consistencyGroupList, HashMap virtGroupMap, HashMap policyMap) {
        int i = consistencyGroupList.size();
        while (i-- > 0) {
            ConfigElementData cgData = (ConfigElementData)consistencyGroupList.getElementDataAt(i);
            ConfigElementData vgData = (ConfigElementData)virtGroupMap.get(cgData.getSnmpKey());
            if (vgData == null) continue;
            cgData.addParameter(vgData.getParametersList());
            MibItemConstant ownedBy = (MibItemConstant)cgData.getValue(ParameterCode.DR_CONSISTENCY_GROUP_OWNED_BY);
            if (ownedBy == DRGroupOwnedByConstant.SYSTEM) {
                cgData.setClassId(ClassID.EXTENDED_PAIR);
            }
            this.addPolicyParamsToConsistencyGroup(cgData, policyMap);
        }
        Iterator i2 = consistencyGroupList.iterator();
        while (i2.hasNext()) {
            SrEventHandler.getEventMgr().sendAddElementEvent((ConfigElementData)i2.next(), (Object)this);
        }
    }

    private void mergePairDataLists(ConfigElementDataList specificPairList, HashMap pairMap, HashMap volumeMap) {
        Iterator i = specificPairList.iterator();
        while (i.hasNext()) {
            ConfigElementData specificPairData = (ConfigElementData)i.next();
            char agentIndex = specificPairData.getMyFirstSnmpAgentIndex();
            ConfigElementData pairData = (ConfigElementData)pairMap.get(specificPairData.getSnmpKey());
            if (pairData != null) {
                specificPairData.addParameter(pairData.getParametersList());
                SnmpCommKey primaryVolumeKey = new SnmpCommKey("1." + pairData.getValue(ParameterCode.DR_PAIR_PRIMARY_ID), agentIndex);
                SnmpCommKey secondaryVolumeKey = new SnmpCommKey("1." + pairData.getValue(ParameterCode.DR_PAIR_SECONDARY_ID), agentIndex);
                ConfigElementData primaryVolumeData = (ConfigElementData)volumeMap.get(primaryVolumeKey);
                ConfigElementData secondaryVolumeData = (ConfigElementData)volumeMap.get(secondaryVolumeKey);
                if (primaryVolumeData == null || secondaryVolumeData == null) {
                    i.remove();
                    continue;
                }
                CommKeyClassId primaryID = null;
                CommKeyClassId secondaryID = null;
                primaryID = primaryVolumeData.getClassId() == ClassID.SIMPLE_VOLUME ? SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(agentIndex, primaryVolumeKey.getKey()) : primaryVolumeData.getCommKeyClassId();
                secondaryID = secondaryVolumeData.getClassId() == ClassID.SIMPLE_VOLUME ? SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(agentIndex, secondaryVolumeKey.getKey()) : secondaryVolumeData.getCommKeyClassId();
                specificPairData.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, primaryID);
                specificPairData.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, secondaryID);
                Object rs = pairData.getValue(ParameterCode.DR_PAIR_ROW_STATUS);
                if (rs != RowStatusConstants.ROW_STATUS_NOT_READY && rs != RowStatusConstants.ROW_STATUS_DESTROY) continue;
                i.remove();
                continue;
            }
            i.remove();
        }
    }

    private void sendSyncPairsEvent(ConfigElementDataList syncPairList, HashMap pairMap, HashMap volumeMap) {
        this.mergePairDataLists(syncPairList, pairMap, volumeMap);
        Iterator i = syncPairList.iterator();
        while (i.hasNext()) {
            SrEventHandler.getEventMgr().sendAddElementEvent((ConfigElementData)i.next(), (Object)this);
        }
    }

    private void sendAsyncPairsEvent(ConfigElementDataList asyncPairList, HashMap pairMap, HashMap volumeMap, HashMap consistencyGroupMap) {
        this.mergePairDataLists(asyncPairList, pairMap, volumeMap);
        int i = asyncPairList.size();
        while (i-- > 0) {
            ConfigElementData asyncPairData = (ConfigElementData)asyncPairList.getElementDataAt(i);
            char agentIndex = asyncPairData.getMyFirstSnmpAgentIndex();
            String groupID = asyncPairData.getValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID).toString();
            SnmpCommKey groupKey = new SnmpCommKey(groupID, agentIndex);
            ConfigElementData consistencyGroupData = (ConfigElementData)consistencyGroupMap.get(groupKey);
            asyncPairData.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, consistencyGroupData.getCommKeyClassId());
            String jourID = asyncPairData.getValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID).toString();
            SnmpCommKey jourKey = new SnmpCommKey("1." + jourID, agentIndex);
            asyncPairData.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, new CommKeyClassId(jourKey, ClassID.JOURNAL_VOLUME));
            Object snapVal = asyncPairData.getValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
            if (snapVal == null) continue;
            String snapID = snapVal.toString();
            SnmpCommKey snapKey = new SnmpCommKey("1." + snapID, agentIndex);
            asyncPairData.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, new CommKeyClassId(snapKey, ClassID.SNAPSHOT_VOLUME));
        }
        Iterator i2 = asyncPairList.iterator();
        while (i2.hasNext()) {
            SrEventHandler.getEventMgr().sendAddElementEvent((ConfigElementData)i2.next(), (Object)this);
        }
    }

    private void sendPoliciesEvent(ConfigElementDataList policyList) {
        for (ElementData data : policyList) {
            SrOidType oidType = (SrOidType)data.getValue(ParameterCode.POLICY_POINTER_TO_PARAM);
            String paramTableKey = DsnmpUtil.getRowIndexFromOidComponents((long[])oidType.value());
            SnmpCommKey snmpKey = new SnmpCommKey(paramTableKey, ((ConfigElementData)data).getMyFirstSnmpAgentIndex());
            data.setValue(ParameterCode.POLICY_PARAM_ID, new CommKeyClassId(snmpKey, ClassID.POLICY_PARAMS));
        }
        if (policyList.size() > 0) {
            SrEventHandler.getEventMgr().sendAddElementEvent(policyList, (Object)this);
        }
    }

    private void sendPolicyParamsEvent(ConfigElementDataList policyParamList) {
        for (ElementData element : policyParamList) {
            SrOidType type = (SrOidType)element.getValue(ParameterCode.POLICY_PARAM_TYPE);
            element.setValue(ParameterCode.POLICY_PARAM_TYPE, PolicyTypeConstant.valueOf(type));
            PolicyParamConfigurator.convertParam1And2ToRunEvery((ConfigElementData)element);
        }
        if (policyParamList.size() > 0) {
            SrEventHandler.getEventMgr().sendAddElementEvent(policyParamList, (Object)this);
        }
    }

    private void addPolicyParamsToConsistencyGroup(ConfigElementData consistencyGroupData, HashMap policyMap) {
        char agentIndex = consistencyGroupData.getMyFirstSnmpAgentIndex();
        SrOidType pitOid = (SrOidType)consistencyGroupData.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
        SrOidType transOid = (SrOidType)consistencyGroupData.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
        SrOidType mergeOid = (SrOidType)consistencyGroupData.getValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
        SnmpCommKey pitPolicyKey = new SnmpCommKey(DsnmpUtil.getRowIndexFromOidComponents((long[])pitOid.value()), agentIndex);
        SnmpCommKey transPolicyKey = new SnmpCommKey(DsnmpUtil.getRowIndexFromOidComponents((long[])transOid.value()), agentIndex);
        SnmpCommKey mergePolicyKey = new SnmpCommKey(DsnmpUtil.getRowIndexFromOidComponents((long[])mergeOid.value()), agentIndex);
        ConfigElementData pitPolicyData = (ConfigElementData)policyMap.get(pitPolicyKey);
        ConfigElementData transPolicyData = (ConfigElementData)policyMap.get(transPolicyKey);
        ConfigElementData mergePolicyData = (ConfigElementData)policyMap.get(mergePolicyKey);
        if (pitPolicyData != null) {
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, pitPolicyData.getCommKeyClassId());
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, (CommKeyClassId)pitPolicyData.getValue(ParameterCode.POLICY_PARAM_ID));
        } else {
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, (SrType)null);
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, (SrType)null);
        }
        if (transPolicyData != null) {
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, transPolicyData.getCommKeyClassId());
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, (CommKeyClassId)transPolicyData.getValue(ParameterCode.POLICY_PARAM_ID));
        } else {
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, (SrType)null);
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, (SrType)null);
        }
        if (mergePolicyData != null) {
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, mergePolicyData.getCommKeyClassId());
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, (CommKeyClassId)mergePolicyData.getValue(ParameterCode.POLICY_PARAM_ID));
        } else {
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, (SrType)null);
            consistencyGroupData.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, (SrType)null);
        }
    }

    private ConfigElementDataList convertVarBindList(CommVarBindList[] table, ClassID classId, MibItem rowStatusMibItem) {
        ConfigElementDataList list = new ConfigElementDataList();
        block0: for (int i = 0; i < table.length; ++i) {
            String key = ((CommVarBind)table[i].elementAt(0)).getIndexForCommKey();
            char agentIndex = table[i].getSnmpAgentIndex();
            SnmpCommKey commKey = new SnmpCommKey(key, agentIndex);
            ConfigElementData element = new ConfigElementData(commKey, classId);
            int j = table[i].size();
            while (j-- > 0) {
                CommVarBind varBind = (CommVarBind)table[i].elementAt(j);
                SrOid oid = (SrOid)varBind.getVarBindKey();
                if (rowStatusMibItem != null && oid.getOid().equals(rowStatusMibItem.toString()) && (varBind.getValue() == RowStatusConstants.ROW_STATUS_NOT_READY || varBind.getValue() == RowStatusConstants.ROW_STATUS_DESTROY)) continue block0;
                ParameterCode paramCode = varBind.getVarBindKey().getParameterCode();
                if (paramCode == null) continue;
                element.setValue(paramCode, varBind.getValue());
            }
            element.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(agentIndex));
            list.add(element);
        }
        return list;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

