/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.BaseConfigurator;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.dr.cf.CfConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public abstract class DRConfigurator
extends BaseConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public DRConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib, ClassID[] annex_classId) {
        super(classId, tableName, rowStatusMib, lastUpdateMib, annex_classId);
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        CfConfigurator cfConf = (CfConfigurator)DataMgrAOImpl.getElementConfigFromClassID(this.m_annexClassId[0]);
        CheckListConfigElementData annexElement = new CheckListConfigElementData(this.myClassId);
        annexElement.addParameter(new Parameter(MasterParameterCode.CF_DATE_AND_TIME.getParameterCode(cfConf.getListOfParams()), null));
        ConfigElementDataList cfList = cfConf.getAll(element.getMyFirstSnmpAgentIndex(), null, annexElement);
        ArrayList list = cfList.getValues(MasterParameterCode.CF_DATE_AND_TIME.getParameterCode(cfConf.getListOfParams()));
        super.internalChange(element);
        if (list != null && !list.isEmpty()) {
            element.addParameter(new Parameter(MasterParameterCode.CF_DATE_AND_TIME.getParameterCode(cfConf.getListOfParams()), Collections.max(list)));
        }
    }

    @Override
    protected void sendRefreshedElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (ElementData ced : list) {
            if (vSwitchData != null) {
                ((ConfigElementData)ced).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            theLogger.trace(SrLogCategories.LEGACY, "Refresh: ", ced.getClassId(), " CommKey is:", CommKeyUtil.getKeyForMessage(ced.getCommKey()));
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            SrEventHandler.getEventMgr().sendRefreshElementEvent((ConfigElementData)i.next(), (Object)this);
        }
    }

    @Override
    protected void sendDiscoveredElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (ElementData ced : list) {
            if (vSwitchData != null) {
                ((ConfigElementData)ced).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            theLogger.trace(SrLogCategories.LEGACY, "Discover: ", ced.getClassId(), " CommKey is:", CommKeyUtil.getKeyForMessage(ced.getCommKey()));
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            SrEventHandler.getEventMgr().sendAddElementEvent((ConfigElementData)i.next(), (Object)this);
        }
    }
}

