/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.dr.AsyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.DRConfigurator;
import com.sanrad.nms.server.mgr.dr.VirtGroupConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyParamConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyTablesConfigurator;
import com.sanrad.nms.server.mgr.volume.JournalVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRGroupOwnedByConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrDebugLogObject;
import java.util.ArrayList;
import java.util.HashMap;

public class ConsistencyGroupConfigurator
extends DRConfigurator {
    private static final String NO_POLICY_INDEX = "0";
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final HashMap<ParameterCodes, Object> listOfParams = new HashMap();

    public ConsistencyGroupConfigurator() {
        this(ClassID.CONSISTENCY_GROUP, "srDRGroupTable", MibItem.DR_GROUP_ROW_STATUS, null);
    }

    protected ConsistencyGroupConfigurator(ClassID classId) {
        this(classId, "srDRGroupTable", MibItem.DR_GROUP_ROW_STATUS, null);
    }

    public ConsistencyGroupConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        super(classId, tableName, rowStatusMib, lastUpdateMib, new ClassID[]{ClassID.CF_CONSISTENCY_GROUP});
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        return listOfParams;
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        this.handlePolicyUpdates(element, element.getSnmpAgentFromParameter());
        CommKeyClassId newPairIndex = null;
        this.tryInternalCreate(element, 3, null);
        if (element.getValue(ParameterCode.DR_PAIR_PRIMARY_ID) != null || element.getValue(ParameterCode.DR_PAIR_SECONDARY_ID) != null) {
            element.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, element.getCommKeyClassId());
            ConfigElementData pairElement = new ConfigElementData(element);
            pairElement.setClassId(ClassID.ASYNC_PAIR);
            pairElement.setCommKeys(null);
            new AsyncPairConfigurator().internalCreate(pairElement);
            newPairIndex = pairElement.getCommKeyClassId();
        }
        element.removeAll();
        if (newPairIndex != null) {
            element.setValue(ParameterCode.DR_ASYNC_PAIR_ID, newPairIndex);
        }
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        this.handlePolicyUpdates(element, element.getMyFirstSnmpAgentIndex());
        ConfigElementData cgData = new ConfigElementData(element.getCommKeyClassId());
        this.addParamentersForChange(element, cgData);
        super.internalChange(cgData);
        if (element.containsParameter(ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE)) {
            try {
                Thread.sleep(Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.WAIT_FOR_ACTIVATE_COMMAND)));
            }
            catch (InterruptedException e) {
                theLogger.logAndAssert(SrLogCategories.LEGACY, e);
            }
        }
        new PolicyConfigurator().stimulateRefreshPolicyElements(element.getSnmpAgentFromParameter());
        new PolicyParamConfigurator().stimulateRefreshPolicyParamsElements(element.getSnmpAgentFromParameter());
    }

    private void tryInternalCreate(ConfigElementData aAllCgDataElement, int aRetryIndex, SrCommException aOriginException) throws SrCommException {
        ConfigElementData cgCreateElement = null;
        try {
            char agentIndex = aAllCgDataElement.getSnmpAgentFromParameter();
            SnmpCommKey newCGIndex = this.getConsistencyGroupIndexNext(agentIndex);
            cgCreateElement = new ConfigElementData(newCGIndex, aAllCgDataElement.getClassId());
            this.addParamentersForCreate(aAllCgDataElement, cgCreateElement);
            super.internalCreate(cgCreateElement);
            aAllCgDataElement.setCommKeyClassId(cgCreateElement.getCommKeyClassId());
            ConfigElementData virtGroupElement = new ConfigElementData(cgCreateElement.getCommKeyClassId());
            VirtGroupConfigurator.addParamentersForVirtGroup(aAllCgDataElement, virtGroupElement);
            super.internalChange(virtGroupElement);
        }
        catch (SrCommException primException) {
            try {
                SrCommException originException = aOriginException != null ? aOriginException : primException;
                this.cleanErroneousCG(cgCreateElement);
                CommKeyClassId createdId = this.checkCgCreateSuccess(aAllCgDataElement);
                if (createdId != null) {
                    aAllCgDataElement.setCommKeyClassId(createdId);
                    return;
                }
                if (aRetryIndex <= 0) {
                    theLogger.error(SrLogCategories.INFORMATIVE, primException, "ERROR HANDLING, out of retries, rethrowing original exception.", originException.getMessage());
                    throw originException;
                }
                --aRetryIndex;
                CommKeyClassId indexNext = this.recalculateNextIndex(cgCreateElement);
                CommKeyClassId indexPrev = cgCreateElement.getCommKeyClassId();
                if (indexPrev.equals(indexNext)) {
                    theLogger.error(SrLogCategories.INFORMATIVE, primException, "ERROR HANDLING, can't generate a different creation index, rethrowing original exception.", originException.getMessage());
                    throw originException;
                }
                cgCreateElement.setCommKeyClassId(indexNext);
                this.tryInternalCreate(aAllCgDataElement, aRetryIndex, aOriginException);
                theLogger.error(SrLogCategories.INFORMATIVE, primException, new SrDebugLogObject("ERROR HANDLING, silently dropping failure, success after re-generating the creation index.", cgCreateElement));
                return;
            }
            catch (SrCommException secondException) {
                theLogger.error(SrLogCategories.EXCEPTION, secondException, "ERROR HANDLING, Exception during error-handling retry, element: " + cgCreateElement);
                throw aOriginException != null ? aOriginException : primException;
            }
        }
    }

    private CommKeyClassId checkCgCreateSuccess(ConfigElementData aAllCgDataElement) throws SrCommException {
        char agentIndex = aAllCgDataElement.getSnmpAgentFromParameter();
        SrString newCgAlias = (SrString)aAllCgDataElement.getValue(ParameterCode.DR_VIRT_GROUP_ALIAS);
        DRRoleConstant newCgRole = (DRRoleConstant)aAllCgDataElement.getValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
        ConfigElementDataList allCGs = this.getAllExtended(agentIndex, null, null);
        for (ElementData existElement : allCGs) {
            SrString existAlias = (SrString)existElement.getValue(ParameterCode.DR_VIRT_GROUP_ALIAS);
            DRRoleConstant existRole = (DRRoleConstant)existElement.getValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
            boolean matchAlias = existAlias.equals(newCgAlias);
            boolean matchRole = existRole.equals(newCgRole);
            if (!matchAlias || !matchRole) continue;
            return existElement.getCommKeyClassId();
        }
        return null;
    }

    private void cleanErroneousCG(ConfigElementData aCgData) {
        if (aCgData.getCommKey() != null) {
            try {
                this.internalRemove(aCgData);
            }
            catch (SrCommException e) {
                theLogger.error(SrLogCategories.INFORMATIVE, e, new SrDebugLogObject("ERROR HANDLING, silently dropping failure, cleaning a CG after failure.", aCgData));
            }
        }
    }

    @Override
    public void postSendRemoveEvent(ConfigElementData element) throws SrCommException {
        new PolicyConfigurator().stimulateRefreshPolicyElements(element.getSnmpAgentFromParameter());
        new PolicyParamConfigurator().stimulateRefreshPolicyParamsElements(element.getSnmpAgentFromParameter());
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        CommKeyClassId pairKey = (CommKeyClassId)element.getValue(ParameterCode.DR_ASYNC_PAIR_ID);
        if (pairKey != null) {
            ConfigElementData asyncPairElement = new ConfigElementData(pairKey);
            new AsyncPairConfigurator().internalRead(asyncPairElement);
            asyncPairElement.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, element.getCommKeyClassId());
            SrEventHandler.getEventMgr().sendAddElementEvent(asyncPairElement, (Object)this);
            this.postSendCreateEvent(asyncPairElement);
        }
        ConfigElementData cgElement = new ConfigElementData(element.getCommKeyClassId());
        this.internalRead(cgElement);
        SrEventHandler.getEventMgr().sendAddElementEvent(cgElement, (Object)this);
        return true;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        this.prepareGroupElementClassID(element);
        PolicyConfigurator policyConf = new PolicyConfigurator();
        this.readPostOperationOfPolicy(element, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, policyConf, agentIndex);
        this.readPostOperationOfPolicy(element, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, policyConf, agentIndex);
        this.readPostOperationOfPolicy(element, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, policyConf, agentIndex);
    }

    private void readPostOperationOfPolicy(ConfigElementData element, ParameterCode policyCode, ParameterCode policyParamCode, PolicyConfigurator policyConf, char agentIndex) throws SrCommException {
        SrOidType policyMibVal = (SrOidType)element.getValue(policyCode);
        if (policyMibVal != null) {
            String policyIndex = DsnmpUtil.getRowIndexFromOidComponents((long[])policyMibVal.value());
            if (!policyIndex.equals(NO_POLICY_INDEX)) {
                CommKeyClassId policyKey = new CommKeyClassId(new SnmpCommKey(policyIndex, agentIndex), ClassID.POLICY_START);
                element.setValue(policyCode, policyKey);
                ConfigElementData policyElement = new ConfigElementData(policyKey);
                policyConf.internalRead(policyElement);
                EventMgr.getInstance().sendRefreshElementEvent(policyElement, (Object)this);
                CommKeyClassId policyParamKey = (CommKeyClassId)policyElement.getValue(ParameterCode.POLICY_PARAM_ID);
                ConfigElementData policyParamElement = new ConfigElementData(policyParamKey);
                new PolicyParamConfigurator().internalRead(policyParamElement);
                EventMgr.getInstance().sendRefreshElementEvent(policyParamElement, (Object)this);
                element.setValue(policyParamCode, policyParamKey);
            } else {
                element.setValue(policyCode, (SrType)null);
                element.setValue(policyParamCode, (SrType)null);
            }
        }
    }

    SnmpCommKey getConsistencyGroupIndexNext(char agentIndex) throws SrCommException {
        Integer nextIndex = (Integer)this.getScalarFromComm(MibItem.DR_VIRT_GROUP_INDEX_NEXT, agentIndex).value();
        return new SnmpCommKey(nextIndex.toString(), agentIndex);
    }

    ConfigElementData addParamentersForCreate(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
        return dest;
    }

    ConfigElementData addParamentersForChange(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_VIRT_GROUP_ALIAS);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
        return dest;
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList cgList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        ConfigElementDataList virtGroupList = new VirtGroupConfigurator().getAll(snmpAgentIndex, null, null);
        this.mergeElementLists(cgList, virtGroupList, false);
        return cgList;
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        SrTrapType trapType = trap.getTrapType();
        if (trapType == SrTrapType.DR_GROUP_CREATED) {
            this.handleCreateTrap(element, trap);
        } else if (SrTrapType.DR_GROUP_DELETED.equals(trapType)) {
            this.handleDeleteTrap(element, trap);
        } else if (SrTrapType.DR_GROUP_STATE_CHANGED.equals(trapType)) {
            this.handleStateChangedTrap(element, trap);
        }
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        SrTrapType trapType = trap.getTrapType();
        if (SrTrapType.DR_GROUP_CREATED.equals(trapType) || SrTrapType.DR_GROUP_DELETED.equals(trapType)) {
            return MibItem.DR_GROUP_ROW_STATUS;
        }
        if (SrTrapType.DR_GROUP_STATE_CHANGED.equals(trapType)) {
            return MibItem.DR_GROUP_MODE;
        }
        return null;
    }

    private void handleCreateTrap(ConfigElementData element, SrTrap trap) throws SrCommException {
        RowStatusConstants rowStatus = (RowStatusConstants)element.getValue(ParameterCode.DR_CONSISTENCY_GROUP_ROW_STATUS);
        if (rowStatus != null && rowStatus.equals(RowStatusConstants.ROW_STATUS_ACTIVE)) {
            this.internalRead(element);
            SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)trap);
        } else if (rowStatus == null) {
            theLogger.warn(SrLogCategories.LEGACY, "Row status of ", element, " is null in handleCreateTrap");
        }
    }

    private void handleStateChangedTrap(ConfigElementData element, SrTrap trap) throws SrCommException {
        this.internalRead(element);
        SrEventHandler.getEventMgr().sendChangeElementEvent(element, (Object)trap);
    }

    private void handleDeleteTrap(ConfigElementData element, SrTrap trap) {
        this.prepareGroupElementClassID(element);
        SrEventHandler.getEventMgr().sendRemoveElementEvent(element, trap);
    }

    private void prepareGroupElementClassID(ConfigElementData element) {
        DRGroupOwnedByConstant ownedBy = (DRGroupOwnedByConstant)element.getValue(ParameterCode.DR_CONSISTENCY_GROUP_OWNED_BY);
        if (ownedBy == DRGroupOwnedByConstant.SYSTEM) {
            element.setClassId(ClassID.EXTENDED_PAIR);
        } else if (ownedBy == DRGroupOwnedByConstant.USER) {
            element.setClassId(ClassID.CONSISTENCY_GROUP);
        }
    }

    private void handlePolicyUpdates(ConfigElementData element, char agentIndex) throws SrCommException {
        SrOid policyOid;
        SnmpCommKey policyKey;
        ConfigElementData pitPolicy = this.createPITPolicyData(element);
        ConfigElementData transPolicy = this.createTransPolicyData(element);
        ConfigElementData mergePolicy = this.createMergePolicyData(element);
        ArrayList<ConfigElementData> policiesArray = new ArrayList<ConfigElementData>();
        if (pitPolicy != null) {
            policiesArray.add(pitPolicy);
        }
        if (transPolicy != null) {
            policiesArray.add(transPolicy);
        }
        if (mergePolicy != null) {
            policiesArray.add(mergePolicy);
        }
        new PolicyTablesConfigurator().updatePolicies(policiesArray.toArray(new ConfigElementData[policiesArray.size()]));
        if (pitPolicy != null) {
            policyKey = CommKeyUtil.getSpecificSnmpKey((CommKeyClassId)pitPolicy.getValue(ParameterCode.POLICY_ID), agentIndex);
            policyOid = new SrOid(MibItem.DR_POLICY_INDEX.toString(), policyKey.getKey());
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, new SrOidType(policyOid.getComponents()));
        }
        if (transPolicy != null) {
            policyKey = CommKeyUtil.getSpecificSnmpKey((CommKeyClassId)transPolicy.getValue(ParameterCode.POLICY_ID), agentIndex);
            policyOid = new SrOid(MibItem.DR_POLICY_INDEX.toString(), policyKey.getKey());
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, new SrOidType(policyOid.getComponents()));
        }
        if (mergePolicy != null) {
            policyKey = CommKeyUtil.getSpecificSnmpKey((CommKeyClassId)mergePolicy.getValue(ParameterCode.POLICY_ID), agentIndex);
            policyOid = new SrOid(MibItem.DR_POLICY_INDEX.toString(), policyKey.getKey());
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, new SrOidType(policyOid.getComponents()));
        }
    }

    private ConfigElementData createPITPolicyData(ConfigElementData src) {
        if (src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_TYPE) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_START_AT) == null) {
            return null;
        }
        ConfigElementData dest = new ConfigElementData(ClassID.POLICY_START);
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, ParameterCode.POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, ParameterCode.POLICY_PARAM_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_START_AT, ParameterCode.POLICY_START_AT);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_TYPE, ParameterCode.POLICY_PARAM_TYPE);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_RUN_EVERY, ParameterCode.POLICY_PARAM_RUN_EVERY);
        return dest;
    }

    private ConfigElementData createTransPolicyData(ConfigElementData src) {
        if (src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_TYPE) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_START_AT) == null) {
            return null;
        }
        ConfigElementData dest = new ConfigElementData(ClassID.POLICY_START);
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, ParameterCode.POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, ParameterCode.POLICY_PARAM_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_START_AT, ParameterCode.POLICY_START_AT);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_TYPE, ParameterCode.POLICY_PARAM_TYPE);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_RUN_EVERY, ParameterCode.POLICY_PARAM_RUN_EVERY);
        return dest;
    }

    private ConfigElementData createMergePolicyData(ConfigElementData src) {
        if (src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_TYPE) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID) == null) {
            return null;
        }
        ConfigElementData dest = new ConfigElementData(ClassID.POLICY_START);
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, ParameterCode.POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, ParameterCode.POLICY_PARAM_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_TYPE, ParameterCode.POLICY_PARAM_TYPE);
        return dest;
    }

    @Override
    public void postSendCreateEvent(ConfigElementData myElement) throws SrCommException {
        char snmpAgent = myElement.getMyFirstSnmpAgentIndex();
        super.postSendCreateEvent(myElement);
        JournalVolumeConfigurator journalVolumesConfigurator = new JournalVolumeConfigurator();
        ConfigElementDataList journalVolList = journalVolumesConfigurator.refreshJournalVolumesTable(snmpAgent);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(journalVolList, (Object)this);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return this.getNextMIBIndex(aElement.getCommKeyClassId(), MibItem.DR_VIRT_GROUP_INDEX_NEXT);
    }

    static {
        listOfParams.put(ParameterCode.DR_VIRT_GROUP_TYPE, null);
        listOfParams.put(ParameterCode.DR_VIRT_GROUP_ELEMENTS_COUNT, null);
        listOfParams.put(ParameterCode.DR_VIRT_GROUP_ALIAS, null);
        listOfParams.put(ParameterCode.DR_VIRT_GROUP_STATE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_MODE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_OWNED_BY, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_INITIAL_SYNC_STATE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_ROW_STATUS, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_NEXT_REPLICATION_SCHEDULE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE, null);
    }
}

