/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.discover;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.SrSnmpTable;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.FCNodeConfigurator;
import com.sanrad.nms.server.mgr.HardwareConfigurator;
import com.sanrad.nms.server.mgr.IScsiInstanceConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionConfigurator;
import com.sanrad.nms.server.mgr.IfConfigurator;
import com.sanrad.nms.server.mgr.IfStatisticConfigurator;
import com.sanrad.nms.server.mgr.IpRouteConfigurator;
import com.sanrad.nms.server.mgr.IscsiTargetQosGroupConfigurator;
import com.sanrad.nms.server.mgr.LUNConfigurator;
import com.sanrad.nms.server.mgr.NetConfigConfigurator;
import com.sanrad.nms.server.mgr.ScsiDeviceConfigurator;
import com.sanrad.nms.server.mgr.SnmpManagerConfigurator;
import com.sanrad.nms.server.mgr.SnmpTargetAddressConfigurator;
import com.sanrad.nms.server.mgr.StatisticConfigurator;
import com.sanrad.nms.server.mgr.TcpConnectionConfigurator;
import com.sanrad.nms.server.mgr.UDPListenerConfigurator;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthorizationConfigurator;
import com.sanrad.nms.server.mgr.dr.DRDiscoveryConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityNameConfigurator;
import com.sanrad.nms.server.mgr.identity.SRPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.lu.SCSILunConfigurator;
import com.sanrad.nms.server.mgr.raid.AttachedRaidConfigurator;
import com.sanrad.nms.server.mgr.srv.isns.ISNSServerConfigurator;
import com.sanrad.nms.server.mgr.srv.radius.RadiusServerConfigurator;
import com.sanrad.nms.server.mgr.storage.LUIdentifierMgr;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiPortalConfigurator;
import com.sanrad.nms.server.mgr.volume.JournalVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.mgr.volume.SnapshotSchedulerConfigurator;
import com.sanrad.nms.server.mgr.volume.SnapshotVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.StripeVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeChildrenConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class VswitchDiscoveryOperation {
    private CommKeyClassId m_vSwitchData;
    private char m_agentIndex;
    private boolean m_sessionDiscoveryActivated = false;
    private static SrLogger theLogger = SrLogger.getLogger();
    private HashMap<String, CommKeyClassId> m_transVolToPhysStorMap = new HashMap();
    private Object[][] m_parentChildVolumesData = null;
    private SrSnmpTable m_volumesTable = null;
    private SrSnmpTable m_stripVolumeTable = null;
    private SrSnmpTable m_snapshotVolumeTable = null;
    private SrSnmpTable m_journalVolumeTable = null;
    private ArrayList<String> mySnapshotVolumes = new ArrayList();
    private ArrayList<String> myJournalVolumes = new ArrayList();

    public VswitchDiscoveryOperation(CommKeyClassId aVswitchId) {
        this.m_agentIndex = aVswitchId.getMyFirstSnmpAgentIndex();
        this.m_vSwitchData = aVswitchId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SrCommException {
        try {
            SimpleVolumeMgr.getInstance().clear(this.m_agentIndex);
            LUIdentifierMgr.getInstance().clearLUIdPhysStorMap(this.m_agentIndex);
            this.vSwitchDiscovery();
            this.virtualizationDiscovery();
        }
        finally {
            SrEventHandler.getEventMgr().sendEndOfVswitchDiscovery(this.m_vSwitchData, this);
        }
    }

    private void setSessionDiscoveryActivated(boolean activate) {
        this.m_sessionDiscoveryActivated = activate;
    }

    public void addDiscoveredTransparentStorage(String transVolIndex, CommKeyClassId physStor) {
        if (transVolIndex.equals("1.0")) {
            return;
        }
        this.m_transVolToPhysStorMap.put(transVolIndex, physStor);
    }

    private void virtualizationDiscovery() throws SrCommException {
        this.iscsiTargetQosGroupsDiscovery();
        this.identitiesDiscovery();
        this.initiatorAndTargetDiscovery();
        this.physStorAndVolumesDiscovery();
        this.attachedRaidsDiscovery();
        this.policyDiscovery();
        if (!this.m_sessionDiscoveryActivated) {
            this.setSessionDiscoveryActivated(true);
        } else {
            this.sessionDiscovery();
        }
        this.disasterRecoveryDiscovery();
        this.simpleVolumesStateUpdate();
    }

    private void initiatorAndTargetDiscovery() throws SrCommException {
        ScsiDeviceConfigurator deviceConfig = new ScsiDeviceConfigurator();
        deviceConfig.discover(this.m_vSwitchData);
    }

    private void sessionDiscovery() throws SrCommException {
        IScsiSessionConfigurator iscsiSsnConfig = new IScsiSessionConfigurator();
        IScsiInstanceConfigurator iscsiInstConfig = new IScsiInstanceConfigurator();
        iscsiInstConfig.discover(this.m_vSwitchData);
        iscsiSsnConfig.discover(this.m_vSwitchData);
        this.setSessionDiscoveryActivated(false);
    }

    private void iscsiTargetQosGroupsDiscovery() throws SrCommException {
        IscsiTargetQosGroupConfigurator cfg = new IscsiTargetQosGroupConfigurator();
        cfg.discover(this.m_vSwitchData);
    }

    private void attachedRaidsDiscovery() throws SrCommException {
        AttachedRaidConfigurator config = new AttachedRaidConfigurator();
        config.discover(this.m_vSwitchData);
    }

    private void identitiesDiscovery() throws SrCommException {
        IdentityConfigurator identConfig = new IdentityConfigurator();
        IdentityNameConfigurator identNameConfig = new IdentityNameConfigurator();
        SRPCredentialsConfigurator srpCredConfig = new SRPCredentialsConfigurator();
        CHAPCredentialsConfigurator chapCredConfig = new CHAPCredentialsConfigurator();
        identConfig.discover(this.m_vSwitchData);
        identNameConfig.discover(this.m_vSwitchData);
        srpCredConfig.discover(this.m_vSwitchData);
        chapCredConfig.discover(this.m_vSwitchData);
    }

    private void physStorAndVolumesDiscovery() throws SrCommException {
        CommMgr commMgr = CommMgr.getInstance(this.m_agentIndex);
        this.m_volumesTable = commMgr.createTableRef("srVirtVolTable", this.m_agentIndex);
        VolumeConfigurator volConfig = new VolumeConfigurator();
        volConfig.removeNotReadyRows(this.m_volumesTable, this.m_vSwitchData);
        PhysicalStorageConfigurator physStorConfig = new PhysicalStorageConfigurator();
        ConfigElementDataList storList = physStorConfig.discover(this.m_agentIndex);
        VolumeConfigurator volumeConfig = new VolumeConfigurator();
        for (ElementData ced : storList) {
            SrType volId = (SrType)((ConfigElementData)ced).getValue(ParameterCode.PHYSICAL_STORAGE_VOLUME_ID);
            if (volId == null || volId.toString().equals("0")) continue;
            String volumeId = "1." + volId.toString();
            ConfigElementData volumeData = volumeConfig.getTableRow(this.m_volumesTable, new SnmpCommKey(volumeId, this.m_agentIndex), this.m_vSwitchData);
            if (volumeData == null) {
                throw new SrDatabaseException("Phys. Storage with Volume ID, but volume doesn't exist");
            }
            if (!volumeData.getClassId().equals(ClassID.TRANSPARENT_VOLUME)) continue;
            this.addDiscoveredTransparentStorage(volumeId, ((ConfigElementData)ced).getCommKeyClassId());
        }
        VolumeChildrenConfigurator volChildConfig = new VolumeChildrenConfigurator();
        this.m_parentChildVolumesData = volChildConfig.getAllForRebuild(this.m_agentIndex, null);
        this.m_stripVolumeTable = commMgr.createTableRef("srVirtVolSpecStrippedTable", this.m_agentIndex);
        this.m_snapshotVolumeTable = commMgr.createTableRef("srVirtVolSpecSnapshotTable", this.m_agentIndex);
        this.m_journalVolumeTable = commMgr.createTableRef("srVirtVolSpecJournalTable", this.m_agentIndex);
        new VolumeConfigurator().commRefreshTable(this.m_volumesTable, this.m_agentIndex);
        new StripeVolumeConfigurator().commRefreshTable(this.m_stripVolumeTable, this.m_agentIndex);
        new SnapshotVolumeConfigurator().commRefreshTable(this.m_snapshotVolumeTable, this.m_agentIndex);
        new JournalVolumeConfigurator().commRefreshTable(this.m_journalVolumeTable, this.m_agentIndex);
        for (int i = 0; i < this.m_parentChildVolumesData.length; ++i) {
            if (this.m_parentChildVolumesData[i][0] == null) continue;
            this.createVolume((String)this.m_parentChildVolumesData[i][0]);
        }
        VolumeOperationConfigurator volOperConfig = new VolumeOperationConfigurator();
        volOperConfig.discover(this.m_vSwitchData);
        this.snapshotAndSourceDiscovery();
        this.journalDiscovery();
        this.transparentVolumesDiscovery();
        LUNConfigurator luConfig = new LUNConfigurator();
        luConfig.discover(this.m_vSwitchData);
        new SCSILunConfigurator().discover(this.m_vSwitchData);
    }

    private void snapshotAndSourceDiscovery() throws SrCommException {
        for (String volumeId : this.mySnapshotVolumes) {
            SnapshotVolumeConfigurator snapshotConfig = (SnapshotVolumeConfigurator)DataMgrAOImpl.getElementConfigFromClassID(ClassID.SNAPSHOT_VOLUME);
            ConfigElementData snapData = snapshotConfig.getTableRow(this.m_snapshotVolumeTable, new SnmpCommKey("1." + volumeId, this.m_agentIndex), this.m_vSwitchData);
            theLogger.logAndAssert(SrLogCategories.ERROR, snapData != null, new Object[]{"returned value should never be null"});
            SrEventHandler.getEventMgr().sendChangeElementEvent(snapData, (Object)this);
        }
        new SnapshotSchedulerConfigurator().discover(this.m_vSwitchData);
    }

    private void journalDiscovery() throws SrCommException {
        for (String volumeId : this.myJournalVolumes) {
            JournalVolumeConfigurator journalConfig = (JournalVolumeConfigurator)DataMgrAOImpl.getElementConfigFromClassID(ClassID.JOURNAL_VOLUME);
            ConfigElementData journalData = journalConfig.getTableRow(this.m_journalVolumeTable, new SnmpCommKey("1." + volumeId, this.m_agentIndex), this.m_vSwitchData);
            theLogger.logAndAssert(SrLogCategories.ERROR, journalData != null, new Object[]{"returned value should never be null"});
            SrEventHandler.getEventMgr().sendChangeElementEvent(journalData, (Object)this);
        }
    }

    private void transparentVolumesDiscovery() throws SrCommException {
        if (this.m_transVolToPhysStorMap.size() == 0) {
            return;
        }
        for (String volumeId : this.m_transVolToPhysStorMap.keySet()) {
            CommKeyClassId[] physStor = new CommKeyClassId[]{this.m_transVolToPhysStorMap.get(volumeId)};
            VolumeConfigurator volumeConfig = new VolumeConfigurator();
            ConfigElementData newVolume = volumeConfig.getTableRow(this.m_volumesTable, new SnmpCommKey(volumeId, this.m_agentIndex), this.m_vSwitchData);
            if (newVolume.getClassId().equals(ClassID.TRANSPARENT_VOLUME)) {
                this.sendTransparentVolumeDataInPhysStor(newVolume);
                SrEventHandler.getEventMgr().sendAddElementEvent(newVolume, (Object)this);
                continue;
            }
            if (newVolume.getClassId().equals(ClassID.SIMPLE_VOLUME)) continue;
            String message = "Physical Storage " + CommKeyUtil.getKeyForMessage(physStor[0].getCommKeys()) + " has a Volume (VolumeId = " + volumeId + ") of illegal type";
            throw new TypeMismatchException(message);
        }
    }

    private void disasterRecoveryDiscovery() throws SrCommException {
        new DRDiscoveryConfigurator().discover(this.m_vSwitchData);
    }

    private CommKeyClassId createVolume(String volumeId) throws SrCommException {
        int i;
        VolumeConfigurator volumeConfig = new VolumeConfigurator();
        ConfigElementData newVolume = volumeConfig.getTableRow(this.m_volumesTable, new SnmpCommKey("1." + volumeId, this.m_agentIndex), this.m_vSwitchData);
        theLogger.logAndAssert(SrLogCategories.ERROR, newVolume != null, new Object[]{"returned value should never be null"});
        if (newVolume.getClassId().equals(ClassID.SIMPLE_VOLUME)) {
            return null;
        }
        if (newVolume.getClassId().equals(ClassID.STRIPE_VOLUME)) {
            SnmpCommKey snmpCommKey = new SnmpCommKey("1." + volumeId, this.m_agentIndex);
            ConfigElementData stripData = volumeConfig.getTableRow(this.m_stripVolumeTable, snmpCommKey, this.m_vSwitchData);
            theLogger.logAndAssert(SrLogCategories.ERROR, stripData != null, new Object[]{"returned value should never be null"});
            newVolume.addParameter(stripData.getParametersList());
        } else if (newVolume.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) {
            this.mySnapshotVolumes.add(volumeId);
        } else if (newVolume.getClassId().equals(ClassID.JOURNAL_VOLUME)) {
            this.myJournalVolumes.add(volumeId);
        }
        ArrayList<CommKeyClassId> childrenVector = new ArrayList<CommKeyClassId>();
        for (i = 0; !(i >= this.m_parentChildVolumesData.length || this.m_parentChildVolumesData[i][0] != null && this.m_parentChildVolumesData[i][0].equals(volumeId)); ++i) {
        }
        while (i < this.m_parentChildVolumesData.length && this.m_parentChildVolumesData[i][0] != null && this.m_parentChildVolumesData[i][0].equals(volumeId)) {
            String childId = (String)this.m_parentChildVolumesData[i][1];
            CommKeyClassId childData = this.createVolume(childId);
            if (childData == null && (childData = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(this.m_agentIndex, "1." + childId)) == null) {
                theLogger.error(SrLogCategories.ERROR, "In VS (" + this.m_agentIndex + "), Have a Simple Volume with no PhysStor point on it. Volume ID: 1.", childId);
            }
            childrenVector.add(childData);
            if (childData != null) {
                this.updateChildPosition(childData, (SrInteger)this.m_parentChildVolumesData[i][2]);
            }
            this.m_parentChildVolumesData[i][1] = null;
            this.m_parentChildVolumesData[i][0] = null;
            ++i;
        }
        CommKeyClassId myData = new CommKeyClassId(newVolume.getCommKey(), newVolume.getClassId());
        if (childrenVector.size() == 0) {
            return myData;
        }
        CommKeyClassId[] childrenData = new CommKeyClassId[childrenVector.size()];
        for (int j = 0; j < childrenVector.size(); ++j) {
            childrenData[j] = (CommKeyClassId)childrenVector.get(j);
        }
        newVolume.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childrenData));
        newVolume.addParameter(new Parameter(ParameterCode.VSWITCH_ID, this.m_vSwitchData));
        newVolume.removeParameter(ParameterCode.VIRTUAL_VOLUME_PARENT);
        SrEventHandler.getEventMgr().sendAddElementEvent(newVolume, (Object)this);
        return myData;
    }

    private void vSwitchDiscovery() throws SrCommException {
        VSwitchConfigurator vSwitchConfig = new VSwitchConfigurator();
        HardwareConfigurator hardwareConfig = new HardwareConfigurator();
        StatisticConfigurator statisticConfig = new StatisticConfigurator();
        IfStatisticConfigurator ifStatConfig = new IfStatisticConfigurator();
        TcpConnectionConfigurator tcpConConfig = new TcpConnectionConfigurator();
        UDPListenerConfigurator udpConConfig = new UDPListenerConfigurator();
        NetConfigConfigurator ipConfig = new NetConfigConfigurator();
        IfConfigurator ifConfig = new IfConfigurator();
        IscsiPortalConfigurator portalConfig = new IscsiPortalConfigurator();
        IpRouteConfigurator ipRouteConfig = new IpRouteConfigurator();
        SnmpTargetAddressConfigurator tgtAddressConfig = new SnmpTargetAddressConfigurator();
        SnmpManagerConfigurator mngConfig = new SnmpManagerConfigurator();
        RadiusServerConfigurator radiusServerConfig = new RadiusServerConfigurator();
        ISNSServerConfigurator isnsServerConfig = new ISNSServerConfigurator();
        FCNodeConfigurator fcNodeConfigurator = new FCNodeConfigurator();
        vSwitchConfig.discover(this.m_vSwitchData);
        ifConfig.discover(this.m_vSwitchData);
        ipConfig.discover(this.m_vSwitchData);
        ipRouteConfig.discover(this.m_vSwitchData);
        portalConfig.discover(this.m_vSwitchData);
        tgtAddressConfig.discover(this.m_vSwitchData);
        mngConfig.discover(this.m_vSwitchData);
        radiusServerConfig.discover(this.m_vSwitchData);
        isnsServerConfig.discover(this.m_vSwitchData);
        fcNodeConfigurator.discover(this.m_vSwitchData);
        hardwareConfig.discover(this.m_vSwitchData);
        statisticConfig.discover(this.m_vSwitchData, ClassID.STATISTIC_IP);
        statisticConfig.discover(this.m_vSwitchData, ClassID.STATISTIC_ICMP);
        statisticConfig.discover(this.m_vSwitchData, ClassID.STATISTIC_TCP);
        statisticConfig.discover(this.m_vSwitchData, ClassID.STATISTIC_UDP);
        ifStatConfig.discover(this.m_vSwitchData);
        tcpConConfig.discover(this.m_vSwitchData);
        udpConConfig.discover(this.m_vSwitchData);
        if (!this.m_sessionDiscoveryActivated) {
            this.setSessionDiscoveryActivated(true);
        } else {
            this.sessionDiscovery();
        }
    }

    private void policyDiscovery() throws SrCommException {
        TargetAuthorizationConfigurator targetAuthConfig = new TargetAuthorizationConfigurator();
        targetAuthConfig.discover(this.m_vSwitchData);
    }

    private void sendTransparentVolumeDataInPhysStor(ConfigElementData transVol) throws SrCommException {
        String volIndex = transVol.getSnmpKey().getKey();
        CommKeyClassId physStorData = this.m_transVolToPhysStorMap.get(volIndex);
        CommKeyClassId transVolCommKeyClassId = new CommKeyClassId(transVol.getCommKey(), transVol.getClassId());
        ConfigElementData physStor = new ConfigElementData(physStorData.getCommKeys(), physStorData.getClassID());
        physStor.setValue(ParameterCode.VSWITCH_ID, (SrType)transVol.getValue(ParameterCode.VSWITCH_ID));
        physStor.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, transVolCommKeyClassId);
        SrEventHandler.getEventMgr().sendChangeElementEvent(physStor, (Object)this);
    }

    private void updateChildPosition(CommKeyClassId childData, SrInteger position) {
        ConfigElementData childElement = new ConfigElementData(childData.getCommKeys(), childData.getClassID());
        childElement.setValue(ParameterCode.VOLUME_POSITION, position);
        childElement.setValue(ParameterCode.VSWITCH_ID, this.m_vSwitchData);
        SrEventHandler.getEventMgr().sendChangeElementEvent(childElement, (Object)this);
    }

    private void simpleVolumesStateUpdate() throws SrCommException {
        theLogger.traceEntering();
        Set<String> simples = SimpleVolumeMgr.getInstance().getAllSimpleVolumes(this.m_agentIndex);
        Iterator<String> i$ = simples.iterator();
        while (i$.hasNext()) {
            VolumeConfigurator volumeConfig = new VolumeConfigurator();
            String curSimple = i$.next();
            ConfigElementData newVolume = volumeConfig.getTableRow(this.m_volumesTable, new SnmpCommKey(curSimple, this.m_agentIndex), this.m_vSwitchData);
            if (newVolume != null) {
                volumeConfig.sendSimpleVolumeDataInPhysStor(newVolume);
                continue;
            }
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple volume " + curSimple + " appears in the internal DM mapping, " + "but does not appear in the SrVirtVol table in the MIB.");
        }
        theLogger.traceExiting();
    }
}

