/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.config;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.exception.SrConnectionException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthorizationConfigurator;
import com.sanrad.nms.server.mgr.config.ChangeElementOperation;
import com.sanrad.nms.server.mgr.config.CreateElementOperation;
import com.sanrad.nms.server.mgr.config.MultiOperations;
import com.sanrad.nms.server.mgr.config.ReadElementOperation;
import com.sanrad.nms.server.mgr.config.ReadFieldsOperation;
import com.sanrad.nms.server.mgr.config.RefreshTableFieldsOperation;
import com.sanrad.nms.server.mgr.config.RemoveElementOperation;
import com.sanrad.nms.server.mgr.config.VSwitchDataAO_AG;
import com.sanrad.nms.server.mgr.config.VolumeOperation;
import com.sanrad.nms.server.mgr.discover.VswitchDiscoveryOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.mgr.polling.PollingGroup;
import com.sanrad.nms.server.mgr.polling.PollingGroupState;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.polling.groups.KeepAliveTask;
import com.sanrad.nms.server.mgr.polling.groups.PollingAclGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingGDRVirtualizationGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingGeneralGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingISCSIRemoteInitiatorsStatisticsGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingISCSISessionsStatisticsGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingIScsiGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingNetworkAndInterfaceGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingSCSIInitiatorPortStatisticsGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingSCSITargetPortStatisticsGroup;
import com.sanrad.nms.server.mgr.polling.groups.PollingVirtualizationGroup;
import com.sanrad.nms.server.mgr.polling.groups.statistic.PollingIcmpGroup;
import com.sanrad.nms.server.mgr.polling.groups.statistic.PollingInterfaceGroup;
import com.sanrad.nms.server.mgr.polling.groups.statistic.PollingIpGroup;
import com.sanrad.nms.server.mgr.polling.groups.statistic.PollingTcpGroup;
import com.sanrad.nms.server.mgr.polling.groups.statistic.PollingUdpGroup;
import com.sanrad.nms.server.mgr.volume.JournalVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrDouble;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class VSwitchDataAOImpl
extends VSwitchDataAO_AG {
    private static SrLogger theLogger = SrLogger.getLogger();
    private AgentPollingMgr myPollingMgr;
    protected CommKeyClassId myVswitchId;
    private boolean myIsConnected = true;

    public VSwitchDataAOImpl(ConfigElementData aVswitchCed) {
        if (aVswitchCed == null) {
            throw new IllegalArgumentException("aVsiwtchCed parameter cannot be null");
        }
        this.myVswitchId = aVswitchCed.getVswitchId();
        if (this.myVswitchId == null) {
            throw new IllegalArgumentException("aVsiwtchCed parameter must contain a V-Switch ID");
        }
        DataBaseCommKey commKey = this.myVswitchId.getDBCommKey();
        if (commKey == null) {
            throw new IllegalStateException("My VS ID does NOT contain a DB key. myVswitchId: " + this.myVswitchId);
        }
        this.setName("VS-" + commKey + "-DM");
        this.myPollingMgr = new AgentPollingMgr(aVswitchCed);
    }

    @Override
    public void shutdown() {
        this.myPollingMgr.stopAll();
        super.shutdown();
    }

    @Override
    protected Void __attachIdentityToTargetACL(ConfigElementData aIdentityCed, CommKeyClassId aTargetId) throws SrCommException {
        try {
            TargetAuthorizationConfigurator aclEntriesConfigurator = new TargetAuthorizationConfigurator();
            aclEntriesConfigurator.attachIdentityToTargetACL(aIdentityCed, aTargetId);
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(aIdentityCed, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __suspendAllPolling() {
        this.myPollingMgr.suspendAll();
        return null;
    }

    @Override
    protected Void __resumeAllPolling() {
        this.myPollingMgr.resumeAll();
        return null;
    }

    @Override
    protected Void __changeElement(ConfigElementData aCed) throws SrCommException {
        try {
            new ChangeElementOperation(aCed).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(aCed, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __createElement(ConfigElementData aCed) throws SrCommException {
        try {
            new CreateElementOperation(aCed).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(aCed, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __createElement(ConfigElementDataList aCedList) throws SrCommException {
        try {
            new CreateElementOperation(aCedList).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException((ConfigElementData)aCedList.get(0), e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __discover() throws SrCommException {
        try {
            new VswitchDiscoveryOperation(this.myVswitchId).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(null, e);
        }
        return null;
    }

    @Override
    protected Void __executeOperations(ElementOperationList aOperList) throws SrCommException {
        try {
            new MultiOperations(aOperList).execute();
        }
        catch (SrConnectionException e) {
            ElementOperation oper = (ElementOperation)aOperList.get(0);
            this.handleTimeoutException(oper.getElement(), e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __handleTrap(SrTrap aTrap) throws SrCommException {
        try {
            ClassID classId = this.getClassIdFromTrapType(aTrap.getTrapType());
            if (classId == null) {
                theLogger.warn(SrLogCategories.INFORMATIVE, "Could not find ClassID for trap ", aTrap);
                return null;
            }
            ElementConfigurator elementConfigurator = DataMgrAOImpl.getElementConfigFromClassID(classId);
            elementConfigurator.handleTrap(aTrap);
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(null, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __executeVolumeOperation(ConfigElementData aCed, VolumeOperationType aOperType) throws SrCommException {
        try {
            new VolumeOperation(aCed, aOperType).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(aCed, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __postPairCreationRefreshOperation() throws SrCommException {
        try {
            char snmpAgent = this.myVswitchId.getMyFirstSnmpAgentIndex();
            PollingData iscsiSessionPollData = new IScsiSessionConfigurator().getRefreshSessionsPollingData(snmpAgent);
            PollingGroup.sendPollingDataToEventMgr(iscsiSessionPollData, "VSwitchDataAOImpl(" + this.myVswitchId + ").postPairCreationRefreshOperation");
            JournalVolumeConfigurator journalVolumesConfigurator = new JournalVolumeConfigurator();
            journalVolumesConfigurator.refreshJournalVolumesTable(snmpAgent);
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(null, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __readElement(ConfigElementData aCed) throws SrCommException {
        try {
            new ReadElementOperation(aCed).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(aCed, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __readElementFields(ConfigElementData aCed) throws SrCommException {
        try {
            new ReadFieldsOperation(aCed).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(aCed, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __refreshTableFields(ConfigElementData aCed) throws SrCommException {
        try {
            new RefreshTableFieldsOperation(aCed).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(aCed, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __removeElement(ConfigElementData aCed) throws SrCommException {
        try {
            new RemoveElementOperation(aCed).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException(aCed, e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __removeElement(ConfigElementDataList aCedList) throws SrCommException {
        try {
            new RemoveElementOperation(aCedList).execute();
        }
        catch (SrConnectionException e) {
            this.handleTimeoutException((ConfigElementData)aCedList.get(0), e);
            throw e;
        }
        return null;
    }

    @Override
    protected Void __setPollingInterval(PollingGroupType aPollingType, long aPollingInterval) {
        this.myPollingMgr.setPollingInterval(aPollingType, aPollingInterval);
        return null;
    }

    @Override
    protected Void __startPollingProcess() {
        this.myPollingMgr.startPolling(PollingGroupType.KEPP_ALIVE);
        this.myPollingMgr.startPolling(PollingGroupType.GENERAL_GROUP_TYPE);
        this.myPollingMgr.startPolling(PollingGroupType.GDR_VIRTUALIZATION_GROUP_TYPE);
        this.myPollingMgr.startPolling(PollingGroupType.ACL_GROUP_TYPE);
        this.myPollingMgr.startPolling(PollingGroupType.NETWORKING_AND_INTERFACE_GROUP_TYPE);
        this.myPollingMgr.startPolling(PollingGroupType.ISCSI_GROUP_TYPE);
        return null;
    }

    @Override
    protected Void __startPolling(PollingGroupType aPollingType) {
        this.myPollingMgr.startPolling(aPollingType);
        return null;
    }

    @Override
    protected Void __stopPolling(PollingGroupType aPollingType) {
        this.myPollingMgr.stopPolling(aPollingType);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void __poll(SrFuture<Void> aFuture, PollingGroupType aPollingType) throws SrCommException {
        block8: {
            SrCommException exp = null;
            try {
                theLogger.info(SrLogCategories.INFORMATIVE, "polling group: ", aPollingType);
                ((PollingGroup)this.myPollingMgr.myPollingGroupsMap.get(aPollingType)).execute();
                if (exp == null) {
                    aFuture.set(null);
                    break block8;
                }
                aFuture.setException(exp);
            }
            catch (SrCommException e) {
                block9: {
                    try {
                        exp = e;
                        if (exp == null) {
                            aFuture.set(null);
                            break block9;
                        }
                        aFuture.setException(exp);
                    }
                    catch (Throwable throwable) {
                        if (exp == null) {
                            aFuture.set(null);
                        } else {
                            aFuture.setException(exp);
                        }
                        PollingGroup pollingGroup = (PollingGroup)this.myPollingMgr.myPollingGroupsMap.get(aPollingType);
                        theLogger.logAndAssert(SrLogCategories.ERROR, pollingGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr ", this.myVswitchId, " for polling type ", aPollingType});
                        pollingGroup.getPollingState().setRunning(false);
                        this.myPollingMgr.reschedulePolling(aPollingType, aFuture);
                        throw throwable;
                    }
                }
                PollingGroup pollingGroup = (PollingGroup)this.myPollingMgr.myPollingGroupsMap.get(aPollingType);
                theLogger.logAndAssert(SrLogCategories.ERROR, pollingGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr ", this.myVswitchId, " for polling type ", aPollingType});
                pollingGroup.getPollingState().setRunning(false);
                this.myPollingMgr.reschedulePolling(aPollingType, aFuture);
            }
        }
        PollingGroup pollingGroup = (PollingGroup)this.myPollingMgr.myPollingGroupsMap.get(aPollingType);
        theLogger.logAndAssert(SrLogCategories.ERROR, pollingGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr ", this.myVswitchId, " for polling type ", aPollingType});
        pollingGroup.getPollingState().setRunning(false);
        this.myPollingMgr.reschedulePolling(aPollingType, aFuture);
    }

    @Override
    protected Void __handleColdReset() {
        this.myPollingMgr.resetPollingLastUpdate(PollingGroupType.GENERAL_GROUP_TYPE);
        this.myPollingMgr.resetPollingLastUpdate(PollingGroupType.GDR_VIRTUALIZATION_GROUP_TYPE);
        this.myPollingMgr.resetPollingLastUpdate(PollingGroupType.ACL_GROUP_TYPE);
        this.myPollingMgr.resetPollingLastUpdate(PollingGroupType.NETWORKING_AND_INTERFACE_GROUP_TYPE);
        this.myPollingMgr.resetPollingLastUpdate(PollingGroupType.ISCSI_GROUP_TYPE);
        return null;
    }

    @Override
    protected Void __configureElements(ConfigElementDataList aCedList) throws Exception {
        for (ElementData element : aCedList) {
            ConfigElementData ced = (ConfigElementData)element;
            ElementConfigurator config = DataMgrAOImpl.getElementConfigFromClassID(ced.getClassId());
            config.executeConfiguration(ced);
        }
        return null;
    }

    @Override
    protected Void __suspendPolling(PollingGroupType aPollingType) throws Exception {
        this.myPollingMgr.suspendPolling(aPollingType);
        return null;
    }

    @Override
    protected Void __resumePolling(PollingGroupType aPollingType) throws Exception {
        this.myPollingMgr.resumePolling(aPollingType);
        return null;
    }

    private void handleTimeoutException(ConfigElementData aCed, SrConnectionException aTimeoutException) {
        this.myIsConnected = false;
        SnmpErrorEvent event = null;
        event = aCed != null ? new SnmpErrorEvent(this, aTimeoutException.getMessage(), this.myVswitchId, aCed, 1) : new SnmpErrorEvent((Object)this, aTimeoutException.getMessage(), this.myVswitchId, 1);
        SrEventHandler.getSnmpErrorMgr().sendSnmpTimeOutEvent(event);
        this.myPollingMgr.suspendAll();
    }

    private ClassID getClassIdFromTrapType(SrTrapType trapType) {
        switch (trapType.getTrapId()) {
            case 0: 
            case 1: 
            case 2: 
            case 12: {
                return ClassID.GENERAL_SCSI_DEVICE;
            }
            case 11: {
                return ClassID.SUB_DIRECT_ACCESS_DEVICE;
            }
            case 5: {
                return ClassID.MIRROR_SYNC;
            }
            case 4: {
                return ClassID.VOLUME_OPERATION;
            }
            case 3: {
                return ClassID.GENERAL_VOLUME;
            }
            case 6: {
                return ClassID.LUN;
            }
            case 7: {
                return ClassID.NEIGHBORE;
            }
            case 8: 
            case 9: 
            case 14: {
                return ClassID.VSWITCH;
            }
            case 15: 
            case 16: {
                return ClassID.INTERFACE;
            }
            case 13: 
            case 35: {
                return ClassID.SNAPSHOT_VOLUME;
            }
            case 17: {
                return ClassID.HARDWARE;
            }
            case 18: {
                return ClassID.HARDWARE;
            }
            case 19: {
                return ClassID.HARDWARE;
            }
            case 23: {
                return ClassID.ISCSI_INITIATOR;
            }
            case 22: {
                return ClassID.ISCSI_TARGET;
            }
            case 21: {
                return ClassID.ISCSI_INSTANCE;
            }
            case 20: {
                return ClassID.HARDWARE;
            }
            case 24: {
                return ClassID.JOURNAL_VOLUME;
            }
            case 25: 
            case 26: {
                return ClassID.GENERAL_PAIR;
            }
            case 27: {
                return ClassID.SYNC_PAIR;
            }
            case 28: {
                return ClassID.ASYNC_PAIR;
            }
            case 29: 
            case 30: 
            case 31: {
                return ClassID.CONSISTENCY_GROUP;
            }
            case 32: {
                return ClassID.CF_CONSISTENCY_GROUP;
            }
            case 34: {
                return ClassID.CF_SYNC_PAIR;
            }
            case 33: {
                return ClassID.CF_ASYNC_PAIR;
            }
            case 36: {
                return ClassID.STORAGE_NOTIFICATION;
            }
            case 37: {
                return ClassID.STORAGE_NOTIFICATION;
            }
        }
        return null;
    }

    private class AgentPollingMgr {
        private Map<PollingGroupType, PollingGroup> myPollingGroupsMap = new HashMap<PollingGroupType, PollingGroup>();

        public AgentPollingMgr(ConfigElementData aPollingIntervalData) {
            CommKeyClassId vswitchId = aPollingIntervalData.getVswitchId();
            SrDouble genGroupInterval = (SrDouble)aPollingIntervalData.getValue(ParameterCode.GENERAL_POLL_INTERVAL);
            PollingGeneralGroup genGroup = new PollingGeneralGroup(vswitchId, genGroupInterval);
            SrDouble virtGroupInterval = (SrDouble)aPollingIntervalData.getValue(ParameterCode.VIRTUALIZATION_POLL_INTERVAL);
            PollingGDRVirtualizationGroup virtGroup = new PollingGDRVirtualizationGroup(vswitchId, virtGroupInterval);
            PollingVirtualizationGroup virtNonGdrGroup = new PollingVirtualizationGroup(vswitchId, virtGroupInterval);
            SrDouble aclGroupInterval = (SrDouble)aPollingIntervalData.getValue(ParameterCode.ACL_POLL_INTERVAL);
            PollingAclGroup aclGroup = new PollingAclGroup(vswitchId, aclGroupInterval);
            SrDouble netGroupInterval = (SrDouble)aPollingIntervalData.getValue(ParameterCode.NET_POLL_INTERVAL);
            PollingNetworkAndInterfaceGroup netGroup = new PollingNetworkAndInterfaceGroup(vswitchId, netGroupInterval);
            SrDouble iscsiGroupInterval = (SrDouble)aPollingIntervalData.getValue(ParameterCode.ISCSI_POLL_INTERVAL);
            PollingIScsiGroup iscsiGroup = new PollingIScsiGroup(vswitchId, iscsiGroupInterval);
            SrDouble statGroupInterval = (SrDouble)aPollingIntervalData.getValue(ParameterCode.STATISTIC_POLL_INTERVAL);
            PollingInterfaceGroup ifGroup = new PollingInterfaceGroup(vswitchId, statGroupInterval);
            PollingIpGroup ipGroup = new PollingIpGroup(vswitchId, statGroupInterval);
            PollingIcmpGroup icmpGroup = new PollingIcmpGroup(vswitchId, statGroupInterval);
            PollingTcpGroup tcpGroup = new PollingTcpGroup(vswitchId, statGroupInterval);
            PollingUdpGroup udpGroup = new PollingUdpGroup(vswitchId, statGroupInterval);
            PollingISCSIRemoteInitiatorsStatisticsGroup iscsiRemInitGroup = new PollingISCSIRemoteInitiatorsStatisticsGroup(vswitchId, statGroupInterval);
            PollingISCSISessionsStatisticsGroup iscsiSessStatGroup = new PollingISCSISessionsStatisticsGroup(vswitchId, statGroupInterval);
            PollingSCSITargetPortStatisticsGroup scsiTarPortGroup = new PollingSCSITargetPortStatisticsGroup(vswitchId, statGroupInterval);
            PollingSCSIInitiatorPortStatisticsGroup scsiInitPortGroup = new PollingSCSIInitiatorPortStatisticsGroup(vswitchId, statGroupInterval);
            this.myPollingGroupsMap.put(PollingGroupType.KEPP_ALIVE, new KeepAliveTask(VSwitchDataAOImpl.this.myVswitchId));
            this.myPollingGroupsMap.put(genGroup.getPollingType(), genGroup);
            this.myPollingGroupsMap.put(virtNonGdrGroup.getPollingType(), virtNonGdrGroup);
            this.myPollingGroupsMap.put(virtGroup.getPollingType(), virtGroup);
            this.myPollingGroupsMap.put(aclGroup.getPollingType(), aclGroup);
            this.myPollingGroupsMap.put(netGroup.getPollingType(), netGroup);
            this.myPollingGroupsMap.put(iscsiGroup.getPollingType(), iscsiGroup);
            this.myPollingGroupsMap.put(PollingGroupType.INTERFACE_GROUP_TYPE, ifGroup);
            this.myPollingGroupsMap.put(PollingGroupType.IP_GROUP_TYPE, ipGroup);
            this.myPollingGroupsMap.put(PollingGroupType.ICMP_GROUP_TYPE, icmpGroup);
            this.myPollingGroupsMap.put(PollingGroupType.TCP_GROUP_TYPE, tcpGroup);
            this.myPollingGroupsMap.put(PollingGroupType.UDP_GROUP_TYPE, udpGroup);
            this.myPollingGroupsMap.put(PollingGroupType.ISCSI_REMOTE_INITIATOR_STATISTICS_GROUP_TYPE, iscsiRemInitGroup);
            this.myPollingGroupsMap.put(PollingGroupType.ISCSI_SESSIONS_STATISTICS_GROUP_TYPE, iscsiSessStatGroup);
            this.myPollingGroupsMap.put(PollingGroupType.SCSI_TARGET_PORT_STATISTICS_GROUP_TYPE, scsiTarPortGroup);
            this.myPollingGroupsMap.put(PollingGroupType.SCSI_INITIATOR_PORT_STATISTICS_GROUP_TYPE, scsiInitPortGroup);
        }

        void reschedulePolling(PollingGroupType aPollingType, SrFuture<Void> aPrevPollFuture) {
            try {
                theLogger.logAndAssert(SrLogCategories.ERROR, aPrevPollFuture.isDone(), new Object[]{"The future must be 'done' before calling this method, the following 'get()' should never block."});
                aPrevPollFuture.get();
                if (!VSwitchDataAOImpl.this.myIsConnected && aPollingType.equals(PollingGroupType.KEPP_ALIVE)) {
                    theLogger.info(SrLogCategories.INFORMATIVE, "VS (", VSwitchDataAOImpl.this.myVswitchId, ") reconnected.");
                    VSwitchDataAOImpl.this.myIsConnected = true;
                    this.resumeAll();
                }
            }
            catch (ExecutionException e) {
                if (!(e instanceof SrExecutionException)) {
                    throw new IllegalStateException("Got a non SrExecutionException in SrActiveObject: ", e);
                }
                SrExecutionException srExecutionException = (SrExecutionException)e;
                Set<Throwable> causes = srExecutionException.getCauses();
                for (Throwable throwable : causes) {
                    if (throwable instanceof SrConnectionException) {
                        if (PollingGroupType.KEPP_ALIVE.equals(aPollingType)) continue;
                        VSwitchDataAOImpl.this.handleTimeoutException(null, (SrConnectionException)throwable);
                        continue;
                    }
                    theLogger.error(SrLogCategories.EXCEPTION, throwable, "Got a non-connection exception during polling.");
                }
            }
            catch (InterruptedException e) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, e);
            }
            PollingGroup pollTask = this.myPollingGroupsMap.get(aPollingType);
            PollingGroupState state = pollTask.getPollingState();
            if (state.getPollInterval() < 0L) {
                theLogger.info(SrLogCategories.INFORMATIVE, "Setting '", aPollingType, "' as suspended, interval: ", state.getPollInterval());
                state.setSuspended(true);
            }
            if (VSwitchDataAOImpl.this.isShutdown()) {
                return;
            }
            if (!state.isActive() || state.isSuspended()) {
                return;
            }
            if (state.isRunning()) {
                return;
            }
            long currTime = System.currentTimeMillis();
            long nextPollDelay = aPrevPollFuture.getStartTime() + state.getPollInterval() - currTime;
            nextPollDelay = Math.max(0L, nextPollDelay);
            state.setRunning(true);
            VSwitchDataAOImpl.this.poll(nextPollDelay, aPollingType);
        }

        private void stopPolling(PollingGroupType aPollingType) {
            PollingGroup pGroup = this.myPollingGroupsMap.get(aPollingType);
            theLogger.logAndAssert(SrLogCategories.ERROR, pGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr " + VSwitchDataAOImpl.this.myVswitchId});
            theLogger.info(SrLogCategories.INFORMATIVE, "Setting '", aPollingType, "' as NON Active.");
            pGroup.getPollingState().setActive(false);
        }

        private void stopAll() {
            for (PollingGroup pollTask : this.myPollingGroupsMap.values()) {
                this.stopPolling(pollTask.getPollingType());
            }
        }

        private void startPolling(PollingGroupType aPollingType) {
            PollingGroup pGroup = this.myPollingGroupsMap.get(aPollingType);
            theLogger.logAndAssert(SrLogCategories.ERROR, pGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr " + VSwitchDataAOImpl.this.myVswitchId});
            theLogger.info(SrLogCategories.INFORMATIVE, "Setting '", aPollingType, "' as Active.");
            PollingGroupState state = pGroup.getPollingState();
            state.setActive(true);
            VSwitchDataAOImpl.this.myPollingMgr.reschedulePolling(aPollingType, new CompleteFuture<Void>("startPolling: " + aPollingType));
        }

        private void setPollingInterval(PollingGroupType aPollingType, long aPollingInterval) {
            PollingGroup pGroup = this.myPollingGroupsMap.get(aPollingType);
            theLogger.logAndAssert(SrLogCategories.ERROR, pGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr " + VSwitchDataAOImpl.this.myVswitchId});
            pGroup.getPollingState().setPollInterval(aPollingInterval);
            this.resumePolling(aPollingType);
        }

        private void suspendPolling(PollingGroupType aPollingType) {
            PollingGroup pGroup = this.myPollingGroupsMap.get(aPollingType);
            theLogger.logAndAssert(SrLogCategories.ERROR, pGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr " + VSwitchDataAOImpl.this.myVswitchId});
            theLogger.info(SrLogCategories.INFORMATIVE, "Setting '", aPollingType, "' as suspended.");
            pGroup.getPollingState().setSuspended(true);
        }

        private void resumePolling(PollingGroupType aPollingType) {
            PollingGroup pGroup = this.myPollingGroupsMap.get(aPollingType);
            theLogger.logAndAssert(SrLogCategories.ERROR, pGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr " + VSwitchDataAOImpl.this.myVswitchId});
            theLogger.info(SrLogCategories.INFORMATIVE, "Setting '", aPollingType, "' as resumed.");
            PollingGroupState state = pGroup.getPollingState();
            state.setSuspended(false);
            VSwitchDataAOImpl.this.myPollingMgr.reschedulePolling(aPollingType, new CompleteFuture<Void>("resumePolling: " + aPollingType));
        }

        private void suspendAll() {
            for (PollingGroup pollTask : this.myPollingGroupsMap.values()) {
                if (pollTask.getPollingType().equals(PollingGroupType.KEPP_ALIVE)) continue;
                this.suspendPolling(pollTask.getPollingType());
            }
        }

        private void resumeAll() {
            for (PollingGroup pollTask : this.myPollingGroupsMap.values()) {
                if (pollTask.getPollingType().equals(PollingGroupType.KEPP_ALIVE)) continue;
                this.resumePolling(pollTask.getPollingType());
            }
        }

        private void resetPollingLastUpdate(PollingGroupType aPollingType) {
            PollingGroup pGroup = this.myPollingGroupsMap.get(aPollingType);
            theLogger.logAndAssert(SrLogCategories.ERROR, pGroup != null, new Object[]{"A PollingGroup was not found in AgentPollingMgr " + VSwitchDataAOImpl.this.myVswitchId});
            pGroup.resetParameters();
        }
    }
}

