/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.config;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.exception.SrConnectionException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;

public abstract class SrConfigOperation {
    private static SrLogger theLogger = SrLogger.getLogger();
    private CommKeyClassId myVswitchId;
    private ConfigElementDataList myCedList = new ConfigElementDataList();

    protected SrConfigOperation(ConfigElementData aCED) {
        this(new ConfigElementDataList(aCED));
    }

    protected SrConfigOperation(ConfigElementDataList aCEDList) {
        for (ElementData cedObj : aCEDList) {
            this.assertVswitchID((ConfigElementData)cedObj);
        }
        this.myCedList.addAll(aCEDList);
    }

    private void assertVswitchID(ConfigElementData aCED) {
        boolean isPersistency;
        ClassID cid = aCED.getClassId();
        boolean bl = isPersistency = ClassID.VSWITCH.equals(cid) || ClassID.CLUSTER.equals(cid) || ClassID.SITE.equals(cid) || ClassID.ALARM_TYPE.equals(cid) || ClassID.EMAIL_CONTACT.equals(cid);
        if (!isPersistency) {
            CommKeyClassId cedVswitchId = aCED.getVswitchId();
            if (cedVswitchId == null) {
                throw new IllegalArgumentException("CED must contain a V-Switch ID, CED: " + aCED);
            }
            this.myVswitchId = cedVswitchId;
        }
    }

    public CommKeyClassId getVswitchId() {
        return this.myVswitchId;
    }

    public void execute() throws SrCommException {
        ConfigElementData ced2 = null;
        try {
            for (ConfigElementData ced2 : this.myCedList) {
                ElementConfigurator config = DataMgrAOImpl.getElementConfigFromElementData(ced2);
                this.internalExecute(ced2, config);
                this.readAfterExecute(ced2, config);
                this.sendEvent(ced2, config);
            }
        }
        catch (SrConnectionException e) {
            throw e;
        }
        catch (SrCommException e) {
            theLogger.error(SrLogCategories.ERROR, "calling operationFailed; ", ced2, "; ", e.getMessage());
            this.operationFailed(ced2);
            throw e;
        }
    }

    protected void sendTimeOutEvent(Object source, ConfigElementData aCed, SrSnmpTimeoutException e) {
        SnmpErrorEvent event = new SnmpErrorEvent(source, e.getMessage(), e.getVSwitchData(), aCed, 1);
        SrEventHandler.getSnmpErrorMgr().sendSnmpTimeOutEvent(event);
    }

    protected abstract void internalExecute(ConfigElementData var1, ElementConfigurator var2) throws SrCommException;

    protected abstract void readAfterExecute(ConfigElementData var1, ElementConfigurator var2) throws SrCommException;

    protected abstract void sendEvent(ConfigElementData var1, ElementConfigurator var2) throws SrCommException;

    protected abstract void operationFailed(ConfigElementData var1);

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (this.myVswitchId != null) {
            sb.append(':').append(this.myVswitchId);
        }
        return sb.toString();
    }
}

