/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.config;

import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.util.alarm.HistoryAlarmData;
import com.sanrad.util.concurrent.SrActiveObject;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.concurrent.SrTask;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public abstract class PersistencyDataAO_AG {
    protected SrActiveObject myAO;

    public PersistencyDataAO_AG() {
        this.myAO = new SrActiveObject("PersistencyDataAO");
    }

    public PersistencyDataAO_AG(Comparator<? super Runnable> aComparator) {
        this.myAO = new SrActiveObject("PersistencyDataAO", aComparator);
    }

    public void shutdown() {
        this.myAO.shutdownNow();
    }

    public boolean isShutdown() {
        return this.myAO.isShutdown();
    }

    public void setName(String aName) {
        this.myAO.setName(aName);
    }

    public SrFuture<Void> changeElement(ConfigElementData aCed) {
        return this.myAO.submit(new ChangeElementTask_1(aCed));
    }

    protected abstract Void __changeElement(ConfigElementData var1) throws Exception;

    public SrFuture<Void> createElement(ConfigElementData aCed) {
        return this.myAO.submit(new CreateElementTask_2(aCed));
    }

    protected abstract Void __createElement(ConfigElementData var1) throws Exception;

    public SrFuture<Void> removeElement(ConfigElementData aCed) {
        return this.myAO.submit(new RemoveElementTask_3(aCed));
    }

    protected abstract Void __removeElement(ConfigElementData var1) throws Exception;

    public SrFuture<ConfigElementDataList> load() {
        return this.myAO.submit(new LoadTask_4());
    }

    protected abstract ConfigElementDataList __load() throws Exception;

    public SrFuture<List<HistoryAlarmData>> loadFromFile(String aFileName) {
        return this.myAO.submit(new LoadFromFileTask_5(aFileName));
    }

    protected abstract List<HistoryAlarmData> __loadFromFile(String var1) throws Exception;

    public SrFuture<Void> setToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms) {
        return this.myAO.submit(new SetToFileTask_6(aFileName, aAlarms));
    }

    protected abstract Void __setToFile(String var1, Iterable<? extends HistoryAlarmData> var2) throws Exception;

    public SrFuture<Void> setPropertiesToFile(String aFileName, Properties aProperties) {
        return this.myAO.submit(new SetPropertiesToFileTask_7(aFileName, aProperties));
    }

    protected abstract Void __setPropertiesToFile(String var1, Properties var2) throws Exception;

    public SrFuture<Properties> loadPropertiesFromFile(String aFileName) {
        return this.myAO.submit(new LoadPropertiesFromFileTask_8(aFileName));
    }

    protected abstract Properties __loadPropertiesFromFile(String var1) throws Exception;

    public SrFuture<ConfigElementDataList> loadCluster(String aCluster) {
        return this.myAO.submit(new LoadClusterTask_5(aCluster));
    }

    protected abstract ConfigElementDataList __loadCluster(String var1) throws Exception;

    public SrFuture<List<String>> getAllVSs(String aCluster, String aSite) {
        return this.myAO.submit(new GetAllVSsTask_12(aCluster, aSite));
    }

    protected abstract List<String> __getAllVSs(String var1, String var2) throws Exception;

    private class GetAllVSsTask_12
    extends SrTask<List<String>> {
        private String myCluster;
        private String mySite;

        GetAllVSsTask_12(String aCluster, String aSite) {
            super("GetAllVSsTask: String Cluster = " + aCluster + "; String Site = " + aSite + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myCluster = aCluster;
            this.mySite = aSite;
        }

        @Override
        protected void execute(SrFuture<List<String>> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__getAllVSs(this.myCluster, this.mySite));
        }
    }

    private class LoadClusterTask_5
    extends SrTask<ConfigElementDataList> {
        private String myCluster;

        LoadClusterTask_5(String aCluster) {
            super("LoadClusterTask: String Cluster = " + aCluster + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myCluster = aCluster;
        }

        @Override
        protected void execute(SrFuture<ConfigElementDataList> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__loadCluster(this.myCluster));
        }
    }

    private class LoadPropertiesFromFileTask_8
    extends SrTask<Properties> {
        private String myFileName;

        LoadPropertiesFromFileTask_8(String aFileName) {
            super("LoadPropertiesFromFileTask: String FileName = " + aFileName + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myFileName = aFileName;
        }

        @Override
        protected void execute(SrFuture<Properties> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__loadPropertiesFromFile(this.myFileName));
        }
    }

    private class SetPropertiesToFileTask_7
    extends SrTask<Void> {
        private String myFileName;
        private Properties myProperties;

        SetPropertiesToFileTask_7(String aFileName, Properties aProperties) {
            super("SetPropertiesToFileTask: String FileName = " + aFileName + "; Properties Properties = " + aProperties + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myFileName = aFileName;
            this.myProperties = aProperties;
        }

        @Override
        protected void execute(SrFuture<Void> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__setPropertiesToFile(this.myFileName, this.myProperties));
        }
    }

    private class SetToFileTask_6
    extends SrTask<Void> {
        private String myFileName;
        private Iterable<? extends HistoryAlarmData> myObject;

        SetToFileTask_6(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms) {
            super("SetToFileTask: String FileName = " + aFileName + "; Alarms = " + aAlarms + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myFileName = aFileName;
            this.myObject = aAlarms;
        }

        @Override
        protected void execute(SrFuture<Void> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__setToFile(this.myFileName, this.myObject));
        }
    }

    private class LoadFromFileTask_5
    extends SrTask<List<HistoryAlarmData>> {
        private String myFileName;

        LoadFromFileTask_5(String aFileName) {
            super("LoadFromFileTask: String FileName = " + aFileName + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myFileName = aFileName;
        }

        @Override
        protected void execute(SrFuture<List<HistoryAlarmData>> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__loadFromFile(this.myFileName));
        }
    }

    private class LoadTask_4
    extends SrTask<ConfigElementDataList> {
        LoadTask_4() {
            super("LoadTask", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
        }

        @Override
        protected void execute(SrFuture<ConfigElementDataList> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__load());
        }
    }

    private class RemoveElementTask_3
    extends SrTask<Void> {
        private ConfigElementData myCed;

        RemoveElementTask_3(ConfigElementData aCed) {
            super("RemoveElementTask: ConfigElementData Ced = " + aCed + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myCed = aCed;
        }

        @Override
        protected void execute(SrFuture<Void> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__removeElement(this.myCed));
        }
    }

    private class CreateElementTask_2
    extends SrTask<Void> {
        private ConfigElementData myCed;

        CreateElementTask_2(ConfigElementData aCed) {
            super("CreateElementTask: ConfigElementData Ced = " + aCed + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myCed = aCed;
        }

        @Override
        protected void execute(SrFuture<Void> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__createElement(this.myCed));
        }
    }

    private class ChangeElementTask_1
    extends SrTask<Void> {
        private ConfigElementData myCed;

        ChangeElementTask_1(ConfigElementData aCed) {
            super("ChangeElementTask: ConfigElementData Ced = " + aCed + "", PersistencyDataAO_AG.this.myAO.getAndIncrementNextTaskIndex());
            this.myCed = aCed;
        }

        @Override
        protected void execute(SrFuture<Void> aCtrlFuture) throws Exception {
            aCtrlFuture.set(PersistencyDataAO_AG.this.__changeElement(this.myCed));
        }
    }
}

