/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.config;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.AlarmTypeConfigurator;
import com.sanrad.nms.server.mgr.ClusterConfigurator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.EmailContactConfigurator;
import com.sanrad.nms.server.mgr.SiteConfigurator;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.config.ChangeElementOperation;
import com.sanrad.nms.server.mgr.config.CreateElementOperation;
import com.sanrad.nms.server.mgr.config.PersistencyDataAO_AG;
import com.sanrad.nms.server.mgr.config.RemoveElementOperation;
import com.sanrad.nms.server.mgr.storage.LUIdentifierMgr;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.util.alarm.HistoryAlarmData;
import java.util.List;
import java.util.Properties;

public class PersistencyDataAOImpl
extends PersistencyDataAO_AG {
    private static SrLogger theLogger = SrLogger.getLogger();

    @Override
    protected Void __changeElement(ConfigElementData aCed) throws SrCommException {
        new ChangeElementOperation(aCed).execute();
        return null;
    }

    @Override
    protected Void __createElement(ConfigElementData aCed) throws SrCommException {
        new CreateElementOperation(aCed).execute();
        return null;
    }

    @Override
    protected ConfigElementDataList __load() throws SrCommException {
        SiteConfigurator site = new SiteConfigurator();
        site.getAll();
        SrEventHandler.getEventMgr().sendEndOfSystemDiscovery(this);
        ClusterConfigurator cluster = new ClusterConfigurator();
        cluster.getAll();
        SrEventHandler.getEventMgr().sendEndOfSiteDiscovery(this);
        VSwitchConfigurator vsConfigurator = new VSwitchConfigurator();
        ConfigElementDataList allvSwitches = vsConfigurator.getAll(null, null, null);
        for (ElementData element : allvSwitches) {
            CommKeyClassId vSwtichData = new CommKeyClassId(element.getCommKey(), ClassID.VSWITCH);
            LUIdentifierMgr.getInstance().addVswitch(vSwtichData);
            CommKeyUtil.addVSwitch(vSwtichData);
            SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(vSwtichData);
        }
        AlarmTypeConfigurator alramTypesConfig = new AlarmTypeConfigurator();
        alramTypesConfig.getAll();
        EmailContactConfigurator emailContactConfig = new EmailContactConfigurator();
        emailContactConfig.getAll();
        return allvSwitches;
    }

    @Override
    protected List<HistoryAlarmData> __loadFromFile(String aFileName) throws SrDatabaseException {
        return CommMgr.getInstance('z').loadHistoryAlarmsFromFile(aFileName);
    }

    public List<HistoryAlarmData> synchLoadFromFile(String aFileName) throws SrDatabaseException {
        return CommMgr.getInstance('z').loadHistoryAlarmsFromFile(aFileName);
    }

    @Override
    protected Void __removeElement(ConfigElementData aCed) throws SrCommException {
        new RemoveElementOperation(aCed).execute();
        return null;
    }

    @Override
    protected Void __setToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms) throws SrDatabaseException {
        CommMgr.getInstance('z').setToFile(aFileName, aAlarms);
        return null;
    }

    public void synchSetToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms) throws SrDatabaseException {
        CommMgr.getInstance('z').setToFile(aFileName, aAlarms);
    }

    @Override
    protected Void __setPropertiesToFile(String aFileName, Properties aProperties) throws Exception {
        CommMgr.getInstance('z').setPropertiesToFile(aFileName, aProperties);
        return null;
    }

    @Override
    protected Properties __loadPropertiesFromFile(String aFileName) throws Exception {
        return CommMgr.getInstance('z').loadPropertiesFromFile(aFileName);
    }

    @Override
    protected ConfigElementDataList __loadCluster(String aCluster) throws Exception {
        if (aCluster == null) {
            throw new IllegalArgumentException("The parameters should not be null.");
        }
        Integer clusterId = -1;
        ClusterConfigurator cluster = new ClusterConfigurator();
        ConfigElementDataList clusters = cluster.getAll();
        for (ElementData curCED : clusters) {
            if (!aCluster.equals(curCED.getValue(ParameterCode.CLUSTER_ALIAS).toString())) continue;
            clusterId = (Integer)((SrInteger)curCED.getValue(ParameterCode.VSWITCH_GROUP_ID)).value();
            break;
        }
        if (clusterId == -1) {
            theLogger.info(SrLogCategories.INFORMATIVE, "The requested cluster ", aCluster, " does not exist in the DB.");
            return new ConfigElementDataList();
        }
        VSwitchConfigurator vsConfigurator = new VSwitchConfigurator();
        ConfigElementDataList allvSwitches = vsConfigurator.getAll(clusterId, null, null);
        return allvSwitches;
    }

    @Override
    protected List<String> __getAllVSs(String aCluster, String aSite) throws Exception {
        return CommMgr.getVsIPsFromDB(aCluster, aSite);
    }
}

