/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.config;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import java.util.List;

public class MultiOperations {
    private ElementOperationList myOperationList;

    public MultiOperations(ElementOperationList anOperationList) {
        this.myOperationList = anOperationList;
    }

    public void execute() throws SrCommException {
        this.executeOperations();
    }

    private void executeOperations() throws SrCommException {
        List<ElementConfigurator> configurators = this.myOperationList.getAllConfigurators();
        CommVarBindList varBinds = this.getCommVarBindsList(configurators);
        CommMgr.getInstance(this.myOperationList.getVswitchIndex()).setList(varBinds, this.myOperationList.getVswitchIndex());
        for (int i = 0; i < configurators.size(); ++i) {
            ElementConfigurator config = configurators.get(i);
            ElementOperation operation = (ElementOperation)this.myOperationList.get(i);
            operation.postMultiOperationsExecution(config);
        }
    }

    private CommVarBindList getCommVarBindsList(List<ElementConfigurator> configurators) throws SrCommException {
        CommVarBindList varBinds = new CommVarBindList();
        for (int i = 0; i < configurators.size(); ++i) {
            ElementConfigurator config = configurators.get(i);
            ElementOperation operation = (ElementOperation)this.myOperationList.get(i);
            varBinds.add(operation.getVarBindsForElement(config));
        }
        ElementOperation operation = (ElementOperation)this.myOperationList.get(0);
        char c = operation.getElement().getMyFirstSnmpAgentIndex();
        this.myOperationList.setVswitchIndex(c);
        return varBinds;
    }
}

