/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.config;

import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.event.SrCreateElementFailedEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.config.SrConfigOperation;
import com.sanrad.nms.server.util.types.ConfigElementDataList;

public class CreateElementOperation
extends SrConfigOperation {
    private boolean myIsEventSent = false;
    private boolean myIsElementCreated;

    public CreateElementOperation(ConfigElementDataList aCEDList) {
        super(aCEDList);
    }

    public CreateElementOperation(ConfigElementData aCED) {
        super(aCED);
    }

    @Override
    protected void internalExecute(ConfigElementData aCed, ElementConfigurator aConfigurator) throws SrCommException {
        this.myIsElementCreated = aCed.isCreated();
        if (this.myIsElementCreated) {
            return;
        }
        aConfigurator.create(aCed);
    }

    @Override
    protected void readAfterExecute(ConfigElementData aCed, ElementConfigurator aConfigurator) throws SrCommException {
        if (this.myIsElementCreated) {
            return;
        }
        this.myIsEventSent = aConfigurator.readAfterCreate(aCed);
    }

    @Override
    protected void sendEvent(ConfigElementData aCed, ElementConfigurator aConfigurator) throws SrCommException {
        if (this.myIsElementCreated) {
            return;
        }
        if (!this.myIsEventSent) {
            SrEventHandler.getEventMgr().sendAddElementEvent(aCed, (Object)this);
        }
        aConfigurator.postSendCreateEvent(aCed);
    }

    @Override
    protected void operationFailed(ConfigElementData aCed) {
        SrCreateElementFailedEvent event = new SrCreateElementFailedEvent((Object)this, aCed);
        SrEventHandler.getEventMgr().sendElementOperationEvent(event);
    }
}

