/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.config;

import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.event.SrChangeElementFailedEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.config.SrConfigOperation;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.ResetConstant;

public class ChangeElementOperation
extends SrConfigOperation {
    private boolean myIsEventSent = false;

    public ChangeElementOperation(ConfigElementData aCed) {
        super(aCed);
    }

    @Override
    protected void internalExecute(ConfigElementData aCed, ElementConfigurator aConfigurator) throws SrCommException {
        aConfigurator.internalChange(aCed);
    }

    @Override
    protected void readAfterExecute(ConfigElementData aCed, ElementConfigurator aConfigurator) throws SrCommException {
        if (!this.isVSwitchShutdown(aCed)) {
            this.myIsEventSent = aConfigurator.readAfterChange(aCed);
        }
    }

    @Override
    protected void sendEvent(ConfigElementData aCed, ElementConfigurator aConfigurator) throws SrCommException {
        if (!this.myIsEventSent) {
            SrEventHandler.getEventMgr().sendChangeElementEvent(aCed, (Object)this);
        }
        aConfigurator.postChangeOperation(aCed);
    }

    @Override
    protected void operationFailed(ConfigElementData aCed) {
        SrChangeElementFailedEvent event = new SrChangeElementFailedEvent((Object)this, aCed);
        SrEventHandler.getEventMgr().sendElementOperationEvent(event);
    }

    private boolean isVSwitchShutdown(ConfigElementData aCed) {
        ResetConstant val;
        if (ClassID.VSWITCH.equals(aCed.getClassId()) && (val = (ResetConstant)aCed.getValue(ParameterCode.VSWITCH_RESET)) != null) {
            return val.equals(ResetConstant.SHUTDOWN) || val.equals(ResetConstant.RESET_HW);
        }
        return false;
    }
}

