/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.acl;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthExtensionConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import java.util.HashMap;
import java.util.Vector;

public class TargetAuthorizationConfigurator
extends ElementConfigurator {
    static Vector lastIndex = new Vector();
    private final String IDENTITY_OID = "1.3.6.1.4.1.10059.1.11.4.1.3.1.1.1";
    private static SrLogger theLogger = SrLogger.getLogger();

    public TargetAuthorizationConfigurator() {
        super(ClassID.ACL_ENTRY, "iscsiTgtAuthAttributesTable", MibItem.TARGET_AUTH_RS, MibItem.ISCSI_TARGET_ACL_TBL_LAST_UPDATE);
        lastIndex.addElement(this.initializeArray());
    }

    @Override
    public CommVarBindList getVarBindsForCreateOperation(ConfigElementData element) throws SrCommException {
        theLogger.trace(SrLogCategories.LEGACY, "TargetAuthorizationConfigurator: getVarBindsForCreateOperation()");
        char agentIndex = element.getSnmpAgentFromParameter();
        this.getAll(agentIndex, null, null);
        HashMap indexMap = (HashMap)lastIndex.get(agentIndex);
        Object commKeyClassId = element.removeParameter(ParameterCode.ACL_ENTRY_IDENTITY);
        CommKey commKey = CommKeyUtil.getSpecificCommKey((CommKeyClassId)commKeyClassId, agentIndex);
        String identIndex = commKey.getKey();
        SrOidType identOid = new SrOidType("1.3.6.1.4.1.10059.1.11.4.1.3.1.1.1." + identIndex);
        element.addParameter(new Parameter(ParameterCode.ACL_ENTRY_IDENTITY, identOid));
        Object targetParent = element.removeParameter(ParameterCode.ACL_ENTRY_TARGET_PARENT);
        String targetIndex = this.getTargetIndex((CommKeyClassId)targetParent, agentIndex);
        Integer targetKey = new Integer(targetIndex);
        Integer lastEntry = (Integer)indexMap.get(targetKey);
        int index = lastEntry == null ? 0 : lastEntry;
        Integer newIndex = new Integer(index + 1);
        StringBuffer key = new StringBuffer("1.");
        indexMap.put(targetKey, new Integer(index + 1));
        key.append(targetIndex);
        key.append(".");
        key.append(newIndex.toString());
        element.setCommKey(new SnmpCommKey(key.toString(), agentIndex));
        CommVarBindList vbList = super.getVarBindsForCreateOperation(element);
        element.removeParameter(ParameterCode.ACL_ENTRY_IDENTITY);
        element.addParameter(new Parameter(ParameterCode.ACL_ENTRY_IDENTITY, commKeyClassId));
        element.addParameter(new Parameter(ParameterCode.ACL_ENTRY_TARGET_PARENT, targetParent));
        return vbList;
    }

    @Override
    public void postCreateOperation(ConfigElementData element) throws SrCommException {
        this.readAfterCreate(element);
        SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)this);
    }

    @Override
    public void postRemoveOperation(ConfigElementData element) throws SrCommException {
        SrEventHandler.getEventMgr().sendRemoveElementEvent(element, this);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getSnmpAgentFromParameter();
        this.getAll(agentIndex, null, null);
        HashMap indexMap = (HashMap)lastIndex.get(agentIndex);
        CommKeyClassId identityCommKeyClassId = (CommKeyClassId)element.removeParameter(ParameterCode.ACL_ENTRY_IDENTITY);
        String identIndex = CommKeyUtil.getSpecificCommKey(identityCommKeyClassId, agentIndex).getKey();
        SrOidType identOid = new SrOidType("1.3.6.1.4.1.10059.1.11.4.1.3.1.1.1." + identIndex);
        element.addParameter(new Parameter(ParameterCode.ACL_ENTRY_IDENTITY, identOid));
        Object targetParent = element.removeParameter(ParameterCode.ACL_ENTRY_TARGET_PARENT);
        String targetIndex = this.getTargetIndex((CommKeyClassId)targetParent, agentIndex);
        Integer lastEntry = (Integer)indexMap.get(new Integer(targetIndex));
        Integer targetKey = new Integer(targetIndex);
        int index = lastEntry == null ? 0 : lastEntry;
        Integer newIndex = new Integer(index + 1);
        StringBuffer key = new StringBuffer("1.");
        indexMap.put(targetKey, new Integer(index + 1));
        key.append(targetIndex);
        key.append(".");
        key.append(newIndex.toString());
        theLogger.trace(SrLogCategories.LEGACY, "new acl entry- index is: ", key);
        element.setCommKey(new SnmpCommKey(key.toString(), agentIndex));
        super.internalCreate(element);
        element.removeParameter(ParameterCode.ACL_ENTRY_IDENTITY);
        element.addParameter(new Parameter(ParameterCode.ACL_ENTRY_IDENTITY, identityCommKeyClassId));
    }

    public boolean createDefaultAccessForTarget(ConfigElementData targetElement, ConfigElementData aclElement) throws SrCommException {
        try {
            Object defaultAccess = targetElement.getValue(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS);
            Object vswitchId = targetElement.getValue(ParameterCode.VSWITCH_ID);
            aclElement.setValue(ParameterCode.ACL_ENTRY_ACCESS, (SrInteger)defaultAccess);
            aclElement.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitchId));
            SnmpCommKey commKey = new SnmpCommKey("1.1", aclElement.getMyFirstSnmpAgentIndex());
            CommKeyClassId identCommkeyClassId = new CommKeyClassId(commKey, ClassID.IDENTITY);
            theLogger.trace(SrLogCategories.LEGACY, "IscsiTargetConfigurator - Trying to change default access of the target to ", defaultAccess);
            aclElement.removeParameter(ParameterCode.ACL_ENTRY_IDENTITY);
            Object position = aclElement.removeParameter(ParameterCode.ACL_ENTRY_POSITION);
            Object target = aclElement.removeParameter(ParameterCode.ACL_ENTRY_TARGET_PARENT);
            this.internalChange(aclElement);
            aclElement.addParameter(new Parameter(ParameterCode.ACL_ENTRY_IDENTITY, identCommkeyClassId));
            aclElement.addParameter(new Parameter(ParameterCode.ACL_ENTRY_POSITION, position));
            aclElement.addParameter(new Parameter(ParameterCode.ACL_ENTRY_TARGET_PARENT, target));
        }
        catch (SrCommException commEx) {
            theLogger.trace(SrLogCategories.LEGACY, "IscsiTargetConfigurator - Failed to change default access of the target ");
            theLogger.trace(SrLogCategories.LEGACY, commEx);
            return false;
        }
        return true;
    }

    private String getTargetIndex(CommKeyClassId commKeyClassId, char agentIndex) {
        SnmpCommKey key = CommKeyUtil.getSpecificSnmpKey(commKeyClassId, agentIndex);
        String targetIndex = key.getKey();
        int pos = targetIndex.lastIndexOf(".");
        targetIndex = targetIndex.substring(pos + 1);
        return targetIndex;
    }

    private void keepTrackOfLastIndex(ConfigElementData element, CommVarBindList list) {
        String index = element.getSnmpKey().toString();
        int pos = index.lastIndexOf(".") + 1;
        String ind = index.substring(pos);
        Integer lastInd = new Integer(ind);
        String strTargetIndex = index.substring(0, pos - 1);
        pos = strTargetIndex.lastIndexOf(".") + 1;
        strTargetIndex = strTargetIndex.substring(pos);
        Integer targetIndex = new Integer(strTargetIndex);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastIndex.size() <= agentIndex) {
            lastIndex.addElement(this.initializeArray());
        } else {
            HashMap map = (HashMap)lastIndex.get(agentIndex);
            Object recentLastInd = map.get(targetIndex);
            if (recentLastInd == null || (Integer)recentLastInd < lastInd) {
                map.put(targetIndex, lastInd);
            }
        }
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = super.getListOfParams();
        paramList.put(ParameterCode.ACL_ENTRY_ACCESS, null);
        paramList.put(ParameterCode.ACL_ENTRY_IDENTITY, null);
        paramList.put(ParameterCode.ACL_ENTRY_POSITION, null);
        paramList.put(ParameterCode.ACL_ENTRY_TARGET_PARENT, null);
        return paramList;
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        Object commKeyClassId = element.removeParameter(ParameterCode.ACL_ENTRY_IDENTITY);
        Object vswitchId = element.removeParameter(ParameterCode.VSWITCH_ID);
        super.readAfterCreate(element);
        if (commKeyClassId == null) {
            SnmpCommKey commKey = new SnmpCommKey("1.1", element.getMyFirstSnmpAgentIndex());
            commKeyClassId = new CommKeyClassId(commKey, ClassID.IDENTITY);
        }
        element.addParameter(new Parameter(ParameterCode.ACL_ENTRY_IDENTITY, commKeyClassId));
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitchId));
        return false;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        this.keepTrackOfLastIndex(element, list);
        String key = element.getSnmpKey().getKey();
        int pos = key.lastIndexOf(".");
        key = "1." + key.substring(0, pos);
        ClassID classId = ClassID.ISCSI_TARGET;
        char snmpAgent = element.getMyFirstSnmpAgentIndex();
        SnmpCommKey aclCommKey = new SnmpCommKey(key, snmpAgent);
        CommKeyClassId commKeyClassId = new CommKeyClassId(aclCommKey, classId);
        element.addParameter(new Parameter(ParameterCode.ACL_ENTRY_TARGET_PARENT, commKeyClassId));
        SrOidType identOid = (SrOidType)element.getValue(ParameterCode.ACL_ENTRY_IDENTITY);
        String oid = identOid.toDisplayString();
        pos = oid.lastIndexOf(".");
        key = "1." + oid.substring(pos + 1);
        SnmpCommKey commKey = new SnmpCommKey(key, snmpAgent);
        classId = ClassID.IDENTITY;
        commKeyClassId = new CommKeyClassId(commKey, classId);
        element.setValue(ParameterCode.ACL_ENTRY_IDENTITY, commKeyClassId);
    }

    protected HashMap initializeArray() {
        HashMap<Integer[], Integer[]> map = new HashMap<Integer[], Integer[]>();
        Integer[] initial = new Integer[]{new Integer(0), new Integer(0)};
        map.put(initial, initial);
        return map;
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList aclList = this.getAllExtended(snmpAgentIndex, null, null);
        if (aclList.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(aclList, vSwitchData);
        }
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList aclList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (aclList != null && aclList.size() > 0) {
            TargetAuthExtensionConfigurator aclXConfig = new TargetAuthExtensionConfigurator();
            ConfigElementDataList aclXList = aclXConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            this.mergeElementLists(aclList, aclXList, true);
        }
        return aclList;
    }

    public void attachIdentityToTargetACL(ConfigElementData identityElement, CommKeyClassId targetId) throws SrCommException {
        IdentityConfigurator identityConfigurator = new IdentityConfigurator();
        identityConfigurator.changeIdentityPurpose(identityElement.getCommKeyClassId(), IdentityPurposeConstant.REMOTE_INITIATOR_DR);
        ConfigElementData aclEntryElement = new ConfigElementData(ClassID.ACL_ENTRY);
        CommKeyClassId vswitchId = (CommKeyClassId)identityElement.getValue(ParameterCode.VSWITCH_ID);
        aclEntryElement.setValue(ParameterCode.VSWITCH_ID, vswitchId);
        aclEntryElement.setValue(ParameterCode.ACL_ENTRY_IDENTITY, CommKeyUtil.getSpecificCommKeyClassId(identityElement.getCommKeyClassId(), vswitchId));
        aclEntryElement.setValue(ParameterCode.ACL_ENTRY_TARGET_PARENT, targetId);
        this.internalCreate(aclEntryElement);
        this.readAfterCreate(aclEntryElement);
        SrEventHandler.getEventMgr().sendAddElementEvent(aclEntryElement, (Object)this);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return TargetAuthorizationConfigurator.getNextIncrementalIndex(aElement.getCommKeyClassId());
    }
}

