/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.exception.SrConnectionException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.StorageDomainConfigurator;
import com.sanrad.nms.server.mgr.storage.LUIdentifierMgr;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrTAddress;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchSysOID;
import com.sanrad.util.BooleanLock;
import java.util.HashMap;

public class VSwitchConfigurator
extends ElementConfigurator {
    private static String storDomainKey = "1";
    private static SrLogger theLogger = SrLogger.getLogger();
    private BooleanLock locker = new BooleanLock();

    public VSwitchConfigurator() {
        super(ClassID.VSWITCH, "", null, null);
        this.locker.setLock(true);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        if (element.getParametersList().containsKey(ParameterCode.FORCE_STATE_SYNC)) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Currently FORCE STATE SYNC is not supported by the FW");
            return;
        }
        SrIpAddress ip = (SrIpAddress)element.getValue(ParameterCode.VSWITCH_IP_ADDRESS);
        DataBaseCommKey dbKey = new DataBaseCommKey(ip.toString());
        element.setCommKey(dbKey);
        theLogger.info(SrLogCategories.INFORMATIVE, "Comm Key calculated");
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        theLogger.info(SrLogCategories.INFORMATIVE, "varBindList is created");
        char newVSwitchSnmpAgentIndex = 'd';
        this.commAddSnmpAgent(varBindList);
        theLogger.info(SrLogCategories.INFORMATIVE, "SNMP agent is added");
        newVSwitchSnmpAgentIndex = varBindList.getSnmpAgentIndex();
        SnmpCommKey snmpKey = new SnmpCommKey("0", newVSwitchSnmpAgentIndex);
        CommKey[] newKeys = new CommKey[]{dbKey, snmpKey};
        element.setCommKeys(newKeys);
        CommKeyClassId vSwitchId = new CommKeyClassId(newKeys, ClassID.VSWITCH);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchId));
        LUIdentifierMgr.getInstance().addVswitch(vSwitchId);
        SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(vSwitchId);
        theLogger.info(SrLogCategories.INFORMATIVE, "LU identifier manager added switch");
        CommKeyUtil.addVSwitch(vSwitchId);
        theLogger.info(SrLogCategories.INFORMATIVE, "CommKey Util added switch");
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        this.commRemoveSnmpAgent(snmpAgentIndex);
        SimpleVolumeMgr.getInstance().removeAgentFromSimpleMgrMapping(snmpAgentIndex);
        LUIdentifierMgr.getInstance().removeVswitch(snmpAgentIndex);
        CommKeyUtil.removeVSwitch(snmpAgentIndex);
    }

    public ConfigElementDataList getAll() throws SrCommException {
        return this.getAll(null, null, null);
    }

    public ConfigElementDataList getAll(Integer clusterId, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList allvSwitches = new ConfigElementDataList();
        VSwitchDataContainer dataContainer = new VSwitchDataContainer();
        try {
            this.commGetAndInitAllVSwitches(clusterId, dataContainer);
        }
        catch (SrDatabaseException e) {
            theLogger.trace(SrLogCategories.LEGACY, e);
            return allvSwitches;
        }
        CommVarBindList[] vSwitchesTable = dataContainer.getVSwitchesData();
        if (vSwitchesTable == null || vSwitchesTable.length == 0) {
            return allvSwitches;
        }
        int numOfRows = vSwitchesTable.length;
        for (int i = 0; i < numOfRows; ++i) {
            if (vSwitchesTable[i] == null) continue;
            ConfigElementData element = this.createDbCedFromVarbindList(vSwitchesTable[i]);
            SrIpAddress ip = (SrIpAddress)element.getValue(ParameterCode.VSWITCH_IP_ADDRESS);
            if (ip == null) {
                throw new MissingValueException("Missing IP for the new vSwitch");
            }
            DataBaseCommKey dbKey = new DataBaseCommKey(ip.toString());
            SnmpCommKey snmpKey = new SnmpCommKey("0", vSwitchesTable[i].getSnmpAgentIndex());
            CommKey[] allKeys = new CommKey[]{dbKey, snmpKey};
            element.setCommKeys(allKeys);
            CommKeyClassId vSwitchId = new CommKeyClassId(allKeys, ClassID.VSWITCH);
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchId));
            SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)this);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, e);
            }
            this.changeElementUDPTrapPort(element);
            allvSwitches.add(element);
        }
        return allvSwitches;
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.VSWITCH_IP_MASK, null);
        paramList.put(ParameterCode.VSWITCH_MAX_RETRIES, null);
        paramList.put(ParameterCode.VSWITCH_READ_COMMUNITY, null);
        paramList.put(ParameterCode.VSWITCH_SNMP_UDP_PORT, null);
        paramList.put(ParameterCode.VSWITCH_SNMP_VERSION, null);
        paramList.put(ParameterCode.VSWITCH_TIMEOUT, null);
        paramList.put(ParameterCode.VSWITCH_TRAP_UDP_PORT, null);
        paramList.put(ParameterCode.VSWITCH_CONTACT, null);
        paramList.put(ParameterCode.VSWITCH_DATE_AND_TIME, null);
        paramList.put(ParameterCode.VSWITCH_DESCRIPTION, null);
        paramList.put(ParameterCode.VSWITCH_LAST_RESET, null);
        paramList.put(ParameterCode.VSWITCH_LOCATION, null);
        paramList.put(ParameterCode.VSWITCH_NAME, null);
        paramList.put(ParameterCode.VSWITCH_TELNET_PORT, null);
        paramList.put(ParameterCode.VSWITCH_TADDRESS, null);
        paramList.put(ParameterCode.VSWITCH_SWITCH_ID, null);
        paramList.put(ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, null);
        paramList.put(ParameterCode.VSWITCH_SYS_OID, null);
        paramList.put(ParameterCode.TEMPERATURE_UNITS, null);
        paramList.put(ParameterCode.VSWITCH_CAPABILITY, null);
        paramList.put(ParameterCode.VSWITCH_LICENSE_PACK, null);
        paramList.put(ParameterCode.VSWITCH_STATUS, null);
        paramList.put(ParameterCode.VSWITCH_TGT_QOS_ACTIVITY, null);
        paramList.put(ParameterCode.VSWITCH_TGT_QOS_MAX_RATE_LIMIT, null);
        paramList.put(ParameterCode.VSWITCH_TGT_QOS_RATE_TYPE, null);
        return paramList;
    }

    @Override
    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        if (element.containsParameter(ParameterCode.VSWITCH_LAST_RESET) || element.containsParameter(ParameterCode.VSWITCH_LAST_KEEPALIVE) || element.containsParameter(ParameterCode.VSWITCH_DATE_AND_TIME)) {
            SnmpCommKey snmpKey = element.getSnmpKey();
            SrOid sysUpTime = new SrOid(MibItem.VSWITCH_SYS_UP_TIME.toString(), snmpKey.toString());
            list.add(new SrSnmpVarBind(sysUpTime, null));
            SrOid datAndTime = new SrOid(MibItem.VSWITCH_DATE_AND_TIME.toString(), snmpKey.toString());
            list.add(new SrSnmpVarBind(datAndTime, null));
        }
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        SrOidType vSwitchSysOID;
        SrTAddress tAddress = (SrTAddress)element.getValue(ParameterCode.VSWITCH_TADDRESS);
        if (tAddress != null) {
            SrIpAddress ip = tAddress.getIp();
            element.setValue(ParameterCode.VSWITCH_MGM_IP_ADDRESS, ip);
            element.removeParameter(ParameterCode.VSWITCH_TADDRESS);
        }
        if ((vSwitchSysOID = (SrOidType)element.getValue(ParameterCode.VSWITCH_SYS_OID)) != null) {
            VSwitchSysOID vSwitchType = VSwitchSysOID.valueOf(vSwitchSysOID);
            element.setValue(ParameterCode.VSWITCH_SYS_OID, vSwitchType);
        }
        SrDateAndTime currentTime = (SrDateAndTime)element.getValue(ParameterCode.VSWITCH_DATE_AND_TIME);
        SrTimeTicks sysUpTime = (SrTimeTicks)VSwitchConfigurator.getVarBindValueFromList(list, MibItem.VSWITCH_SYS_UP_TIME);
        SrDateAndTime time = this.getLastReset(currentTime, sysUpTime);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_LAST_RESET, time));
        SrInteger tempUnitInteger = (SrInteger)element.getValue(ParameterCode.TEMPERATURE_UNITS);
        if (tempUnitInteger != null) {
            TempetureUnitConstant tempUnit = TempetureUnitConstant.getTempUnitStat(tempUnitInteger.intValue());
            element.setValue(ParameterCode.TEMPERATURE_UNITS, tempUnit);
        }
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        ConfigElementData vSwitch = new ConfigElementData(vSwitchData.getCommKeys(), vSwitchData.getClassID());
        vSwitch.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        this.internalRead(vSwitch);
        SrEventHandler.getEventMgr().sendChangeElementEvent(vSwitch, (Object)this);
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        block4: {
            StorageDomainConfigurator storDomainConfig = new StorageDomainConfigurator();
            HashMap<ParameterCodes, Object> storDoaminParams = storDomainConfig.getListOfParams();
            this.splitParameterListOfDifferentElement(element, storDoaminParams);
            if (storDoaminParams.size() > 0) {
                SnmpCommKey storDomainCommKey = new SnmpCommKey(storDomainKey, element.getMyFirstSnmpAgentIndex());
                ConfigElementData storDomainElement = new ConfigElementData((CommKey)storDomainCommKey, ClassID.STORAGE_DOMAIN, storDoaminParams);
                ElementConfigurator configurator = DataMgrAOImpl.getElementConfigFromElementData(storDomainElement);
                configurator.internalChange(storDomainElement);
            }
            CommVarBindList varBindList = new CommVarBindList();
            this.convertParamsToVarBinds(element, varBindList);
            this.addCommVarBindsToChangeList(varBindList, element);
            try {
                this.commSetListSnmpOnly(varBindList, element.getMyFirstSnmpAgentIndex());
                this.commChangeSnmpAgentParams(varBindList, element.getMyFirstSnmpAgentIndex());
            }
            catch (SrConnectionException e) {
                if (element.containsParameter(ParameterCode.VSWITCH_SNMP_UDP_PORT)) {
                    theLogger.info(SrLogCategories.INFORMATIVE, "SrConnectionException \"", e.getMessage(), "\" was caught in order to change UDP port to ", element.getValue(ParameterCode.VSWITCH_SNMP_UDP_PORT));
                    this.commChangeSnmpAgentParams(varBindList, element.getMyFirstSnmpAgentIndex());
                    return;
                }
                if (element.containsParameter(ParameterCode.VSWITCH_RESET)) break block4;
                throw e;
            }
        }
    }

    private void changeElementUDPTrapPort(ConfigElementData element) throws SrCommException {
        ConfigElementData newElement = new ConfigElementData(element.getCommKeyClassId());
        SrInteger currentTrapPort = (SrInteger)element.getValue(ParameterCode.VSWITCH_TRAP_UDP_PORT);
        newElement.setValue(ParameterCode.VSWITCH_TRAP_UDP_PORT, currentTrapPort);
        this.internalChange(newElement);
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        return false;
    }

    @Override
    public boolean readAfterChange(ConfigElementData element) throws SrCommException {
        this.read(element);
        return false;
    }

    @Override
    public void internalRead(ConfigElementData element) throws SrCommException {
        super.internalRead(element);
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        SnmpCommKey storDomainKey = new SnmpCommKey("1", snmpAgentIndex);
        StorageDomainConfigurator storDomainConfig = new StorageDomainConfigurator();
        ConfigElementData storDomainElem = new ConfigElementData(storDomainKey, ClassID.STORAGE_DOMAIN);
        storDomainElem.addParameter(storDomainConfig.getListOfParams());
        storDomainConfig.internalRead(storDomainElem);
        SrDateAndTime lastReset = (SrDateAndTime)element.getValue(ParameterCode.VSWITCH_LAST_RESET);
        if (lastReset != null) {
            SrTimeTicks lastKeepAlive = (SrTimeTicks)storDomainElem.getValue(ParameterCode.VSWITCH_LAST_KEEPALIVE);
            storDomainElem.setValue(ParameterCode.VSWITCH_LAST_KEEPALIVE, this.getDate(lastReset, lastKeepAlive));
        } else {
            storDomainElem.removeParameter(ParameterCode.VSWITCH_LAST_KEEPALIVE);
        }
        element.addParameter(storDomainElem.getParametersList());
    }

    @Override
    public void internalReadFields(ConfigElementData element) throws SrCommException {
        StorageDomainConfigurator storDomainConfig = new StorageDomainConfigurator();
        HashMap<ParameterCodes, Object> storDoaminParams = storDomainConfig.getListOfParams();
        this.splitParameterListOfDifferentElement(element, storDoaminParams);
        if (element.containsParameter(ParameterCode.VSWITCH_MGM_IP_ADDRESS)) {
            element.addParameter(new Parameter(ParameterCode.VSWITCH_TADDRESS, null));
        }
        if (storDoaminParams.containsKey(ParameterCode.VSWITCH_LAST_KEEPALIVE)) {
            element.addParameter(new Parameter(ParameterCode.VSWITCH_LAST_RESET, null));
        }
        super.internalReadFields(element);
        if (storDoaminParams.size() > 0) {
            SnmpCommKey storDomainCommKey = new SnmpCommKey(storDomainKey, element.getMyFirstSnmpAgentIndex());
            ConfigElementData storDomainElement = new ConfigElementData((CommKey)storDomainCommKey, ClassID.STORAGE_DOMAIN, storDoaminParams);
            storDomainConfig.internalReadFields(storDomainElement);
            SrDateAndTime lastReset = (SrDateAndTime)element.getValue(ParameterCode.VSWITCH_LAST_RESET);
            SrTimeTicks lastKeepAlive = (SrTimeTicks)storDomainElement.getValue(ParameterCode.VSWITCH_LAST_KEEPALIVE);
            storDomainElement.setValue(ParameterCode.VSWITCH_LAST_KEEPALIVE, this.getDate(lastReset, lastKeepAlive));
            element.addParameter(storDomainElement.getParametersList());
        }
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        element.setCommKeys(vSwitchData.getCommKeys());
        switch (trap.getTrapType().getTrapId()) {
            case 9: {
                element.setValue(ParameterCode.VSWITCH_COLD_START, new SrBoolean(true));
                DataMgrAOImpl.getInstance().handleColdReset(vSwitchData);
                break;
            }
            case 8: {
                break;
            }
            case 14: {
                break;
            }
            default: {
                return;
            }
        }
        theLogger.trace(SrLogCategories.LEGACY, "Changed by Trap for ", element.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendChangeElementEvent(element, (Object)trap);
    }

    public ConfigElementData refreshFields(ConfigElementData element) {
        return null;
    }

    public void notifyVswitchNotBusy() {
        this.locker.releaseLock();
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        return aElement.getCommKeyClassId();
    }

    public static class VSwitchDataContainer {
        CommVarBindList[] vSwitchesList = null;

        VSwitchDataContainer() {
        }

        public void setVSwitchesData(CommVarBindList[] theList) {
            this.vSwitchesList = theList;
        }

        CommVarBindList[] getVSwitchesData() {
            return this.vSwitchesList;
        }

        public void setVSwitchDataNull(int agentIndex) {
            if (this.vSwitchesList.length > agentIndex) {
                this.vSwitchesList[agentIndex] = null;
            }
        }
    }
}

