/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import java.util.HashMap;

public class StatisticConfigurator
extends ElementConfigurator {
    public StatisticConfigurator() {
    }

    public StatisticConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        super(classId, tableName, rowStatusMib, lastUpdateMib);
    }

    @Override
    public void discover(CommKeyClassId vSwitchData, ClassID classId) throws SrCommException {
        CommKeyClassId elementData = new CommKeyClassId(vSwitchData.getCommKeys(), classId);
        ConfigElementData element = new ConfigElementData(elementData.getCommKeys(), elementData.getClassID());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        HashMap params = this.getListOfParams(classId);
        element.addParameter(params);
        ConfigElementDataList list = new ConfigElementDataList();
        list.add(element);
        this.sendDiscoveredElementsToEventMgr(list, vSwitchData);
    }

    private HashMap getListOfParams(ClassID classId) {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(50);
        if (classId.equals(ClassID.STATISTIC_ICMP)) {
            paramList.put(ParameterCode.ICMP_IN_ADDRESS_MASKS, null);
            paramList.put(ParameterCode.ICMP_IN_ADDRESS_REPS, null);
            paramList.put(ParameterCode.ICMP_IN_DEST_UNREACH, null);
            paramList.put(ParameterCode.ICMP_IN_ECHO_REPS, null);
            paramList.put(ParameterCode.ICMP_IN_ECHOES, null);
            paramList.put(ParameterCode.ICMP_IN_ERRORS, null);
            paramList.put(ParameterCode.ICMP_IN_MSGS, null);
            paramList.put(ParameterCode.ICMP_IN_PARAMS_PROBS, null);
            paramList.put(ParameterCode.ICMP_IN_SRC_QUENCHES, null);
            paramList.put(ParameterCode.ICMP_IN_TIME_EXCDS, null);
            paramList.put(ParameterCode.ICMP_IN_TIMESTAMPS, null);
            paramList.put(ParameterCode.ICMP_IN_TIMESTAMP_REPS, null);
            paramList.put(ParameterCode.ICMP_OUT_ADDRESS_MASKS, null);
            paramList.put(ParameterCode.ICMP_OUT_ADDRESS_REPS, null);
            paramList.put(ParameterCode.ICMP_OUT_ECHO_REPS, null);
            paramList.put(ParameterCode.ICMP_OUT_ECHOES, null);
            paramList.put(ParameterCode.ICMP_OUT_ERRORS, null);
            paramList.put(ParameterCode.ICMP_OUT_MSGS, null);
            paramList.put(ParameterCode.ICMP_OUT_PARAMS_PROBS, null);
            paramList.put(ParameterCode.ICMP_OUT_SRC_QUENCHES, null);
            paramList.put(ParameterCode.ICMP_OUT_TIME_EXCDS, null);
            paramList.put(ParameterCode.ICMP_OUT_TIMESTAMPS, null);
            paramList.put(ParameterCode.ICMP_OUT_TIMESTAMP_REPS, null);
        } else if (classId.equals(ClassID.STATISTIC_IP)) {
            paramList.put(ParameterCode.IP_FRAG_CREATES, null);
            paramList.put(ParameterCode.IP_FRAG_FAIL, null);
            paramList.put(ParameterCode.IP_FRAG_OK, null);
            paramList.put(ParameterCode.IP_IN_ADDRESS_ERROR, null);
            paramList.put(ParameterCode.IP_IN_DELIVERS, null);
            paramList.put(ParameterCode.IP_IN_DISCARDS, null);
            paramList.put(ParameterCode.IP_IN_HEADER_ERROR, null);
            paramList.put(ParameterCode.IP_IN_RECIVES, null);
            paramList.put(ParameterCode.IP_IN_UNKNOWN_PROTOCOLS, null);
            paramList.put(ParameterCode.IP_OUT_DISCARDS, null);
            paramList.put(ParameterCode.IP_OUT_NO_ROUTES, null);
            paramList.put(ParameterCode.IP_OUT_REQUESTS, null);
            paramList.put(ParameterCode.IP_REASM_FAIL, null);
            paramList.put(ParameterCode.IP_REASM_OK, null);
            paramList.put(ParameterCode.IP_REASM_REQDS, null);
            paramList.put(ParameterCode.IP_ROUTING_DISCARDS, null);
        } else if (classId.equals(ClassID.STATISTIC_TCP)) {
            paramList.put(ParameterCode.TCP_ACTIVE_OPENS, null);
            paramList.put(ParameterCode.TCP_ATTEMPT_FAILS, null);
            paramList.put(ParameterCode.TCP_CURR_ESTAB, null);
            paramList.put(ParameterCode.TCP_ESTAB_RESETS, null);
            paramList.put(ParameterCode.TCP_IN_ERRORS, null);
            paramList.put(ParameterCode.TCP_IN_SEGS, null);
            paramList.put(ParameterCode.TCP_OUT_RSTS, null);
            paramList.put(ParameterCode.TCP_OUT_SEGS, null);
            paramList.put(ParameterCode.TCP_PASSIVE_OPENS, null);
            paramList.put(ParameterCode.TCP_RETRANS_SEGS, null);
        } else {
            paramList.put(ParameterCode.UDP_IN_DATAGRAMS, null);
            paramList.put(ParameterCode.UDP_IN_ERRORS, null);
            paramList.put(ParameterCode.UDP_NO_PORTS, null);
            paramList.put(ParameterCode.UDP_OUT_DATAGRAMS, null);
        }
        return paramList;
    }

    protected ElementConfigurator getElementConfigurator() {
        return this;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

