/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.constants.RemoteTargetFailureTypeConstant;
import java.util.HashMap;

public class SrSCSIRemoteTargetConfigurator
extends ElementConfigurator {
    private static final String IDENTITY_INDEX_OID = "1.3.6.1.4.1.10059.1.11.4.1.3.1.1.1";
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrSCSIRemoteTargetConfigurator() {
        super(ClassID.ISCSI_REMOTE_TARGET, "srRemoteTgtTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_ALIAS, null);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, null);
        paramList.put(ParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, null);
        paramList.put(ParameterCode.IDENTITY_ID, null);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, null);
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String elementKey = element.getSnmpKey().getKey();
        String remoteTargetPortKey = elementKey.substring(0, elementKey.lastIndexOf("."));
        String localInitiatorKey = elementKey.substring(0, remoteTargetPortKey.lastIndexOf("."));
        CommKeyClassId initiatorCommKeyClassId = new CommKeyClassId(new SnmpCommKey(localInitiatorKey, element.getMyFirstSnmpAgentIndex()), ClassID.SCSI_INITIATOR);
        element.setValue(ParameterCode.SCSI_INITIATOR_ID, initiatorCommKeyClassId);
        SrOidType remoteTargetIdentityOid = (SrOidType)element.getValue(ParameterCode.IDENTITY_ID);
        String identityKey = remoteTargetIdentityOid.toDisplayString().substring(IDENTITY_INDEX_OID.length() + 1);
        CommKeyClassId identityCommKeyClassId = new CommKeyClassId(new SnmpCommKey(identityKey, element.getMyFirstSnmpAgentIndex()), ClassID.IDENTITY);
        element.setValue(ParameterCode.IDENTITY_ID, identityCommKeyClassId);
        SrOidType remoteTargetFailureTypeOid = (SrOidType)element.getValue(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE);
        RemoteTargetFailureTypeConstant remoteTargetFailureTypeConst = RemoteTargetFailureTypeConstant.getFailureType(remoteTargetFailureTypeOid);
        element.setValue(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, remoteTargetFailureTypeConst);
    }

    @Override
    protected void mergeElementLists(ConfigElementDataList remoteTargetList, ConfigElementDataList srRemoteTargetList, boolean setClassId) {
        Integer[] indexNotToRemove = new Integer[remoteTargetList.size()];
        try {
            for (ElementData secondElem : srRemoteTargetList) {
                CommKey[] secondElemKey = secondElem.getCommKey();
                ElementData mainElem = null;
                int index2 = 0;
                for (ElementData currentMainElem : remoteTargetList) {
                    CommKey[] mainElemKey = currentMainElem.getCommKey();
                    if (CommKey.compare(secondElemKey, mainElemKey)) {
                        mainElem = (ConfigElementData)currentMainElem;
                        break;
                    }
                    if (index2 == remoteTargetList.size() - 1) break;
                    ++index2;
                }
                ElementData tmp = null;
                if (mainElem == null) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, "Extension entry without a main table entry. Ext: " + secondElem + "; mainList: " + remoteTargetList);
                    tmp = new ConfigElementData((ConfigElementData)secondElem);
                    remoteTargetList.add(tmp);
                    indexNotToRemove[index2] = null;
                } else {
                    mainElem.addParameter(secondElem.getParametersList());
                    tmp = mainElem;
                }
                if (setClassId) {
                    tmp.setClassId(this.myClassId);
                }
                indexNotToRemove[index2] = new Integer(index2);
            }
            ConfigElementDataList leftList = this.removeNonISCSIRemoteTargets(remoteTargetList, indexNotToRemove);
            remoteTargetList.clear();
            remoteTargetList.addAll(leftList);
        }
        catch (RuntimeException e) {
            String msg = "Merge Failed at: " + CommKeyUtil.getKeyForMessage(((ConfigElementData)remoteTargetList.get(0)).getCommKey());
            theLogger.error(SrLogCategories.EXCEPTION, e, msg);
            throw e;
        }
    }

    private ConfigElementDataList removeNonISCSIRemoteTargets(ConfigElementDataList remoteTargetList, Integer[] indexNotToRemove) {
        ConfigElementDataList retList = new ConfigElementDataList();
        for (int index = 0; index < indexNotToRemove.length; ++index) {
            if (indexNotToRemove[index] == null) continue;
            retList.add((ElementData)remoteTargetList.get(index));
        }
        return retList;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

