/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrInteger;

public class SiteConfigurator
extends ElementConfigurator {
    public SiteConfigurator() {
        super(ClassID.SITE, "", null, null);
    }

    public ConfigElementDataList getAll() throws SrCommException {
        CommVarBindList[] siteList = this.commGetAllSitesData('z');
        ConfigElementDataList elementList = new ConfigElementDataList();
        for (int i = 0; i < siteList.length; ++i) {
            ConfigElementData element = this.createDbCedFromVarbindList(siteList[i]);
            SrInteger key = (SrInteger)element.getValue(ParameterCode.VSWITCH_GROUP_ID);
            element.setCommKey(new DataBaseCommKey(key.toString()));
            elementList.add(element);
        }
        this.sendDiscoveredElementsToEventMgr(elementList, null);
        return elementList;
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        SrInteger siteId = (SrInteger)element.getValue(ParameterCode.VSWITCH_GROUP_ID);
        element.setCommKey(new DataBaseCommKey(siteId.toString()));
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        CommMgr.getInstance('z').addSite(varBindList);
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        return false;
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        CommKey[] commKey = element.getCommKey();
        Integer vSwitchGroupId = new Integer(commKey[0].getKey());
        this.commRemoveSite(vSwitchGroupId, 'z');
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        this.addCommVarBindsToChangeList(varBindList, element);
        this.commChangeSiteParams(varBindList, 'z');
    }

    @Override
    public boolean readAfterChange(ConfigElementData element) throws SrCommException {
        return false;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return aElement.getCommKeyClassId();
    }
}

