/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.ScsiInitiatorPortConfigurator;
import com.sanrad.nms.server.mgr.ScsiTransportConfigurator;
import com.sanrad.nms.server.mgr.target.ScsiTargetPortsConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.SCSIPortRoleConstant;
import java.util.ArrayList;
import java.util.HashMap;

public class ScsiPortConfigurator
extends ElementConfigurator {
    public ScsiPortConfigurator() {
        super(ClassID.SCSI_PORT, "scsiPortTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.SCSI_PORT_ROLE, null);
        return paramList;
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList portList = this.getAll(snmpAgentIndex, null, null);
        ScsiInitiatorPortConfigurator initiatorPortConfig = new ScsiInitiatorPortConfigurator();
        ConfigElementDataList scsiInitiatorPortList = initiatorPortConfig.getAll(snmpAgentIndex, null, null);
        ScsiTargetPortsConfigurator targetPortConfig = new ScsiTargetPortsConfigurator();
        ConfigElementDataList scsiTargetPortList = targetPortConfig.getAllExtended(snmpAgentIndex, null, null);
        for (ConfigElementData portElem : portList) {
            SCSIPortRoleConstant role = (SCSIPortRoleConstant)portElem.getValue(ParameterCode.SCSI_PORT_ROLE);
            if (role.equals(SCSIPortRoleConstant.INITIATOR)) {
                portElem.setClassId(ClassID.SCSI_INITIATOR_PORT);
                for (ConfigElementData intrElem : scsiInitiatorPortList) {
                    if (!intrElem.compareCommKey(portElem)) continue;
                    intrElem.addParameter(portElem.getParametersList());
                }
                continue;
            }
            portElem.setClassId(ClassID.SCSI_TARGET_PORT);
            for (ConfigElementData tgtElem : scsiTargetPortList) {
                if (!tgtElem.compareCommKey(portElem)) continue;
                tgtElem.addParameter(portElem.getParametersList());
            }
        }
        portList.clear();
        portList.addAll(scsiInitiatorPortList);
        portList.addAll(scsiTargetPortList);
        return portList;
    }

    @Override
    public ConfigElementDataList refreshTable(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList portList = this.getAllExtended(snmpAgentIndex, null, null);
        ScsiTransportConfigurator trnsportConfig = new ScsiTransportConfigurator();
        ConfigElementDataList transportList = trnsportConfig.getAllExtended(snmpAgentIndex, null, null);
        ScsiTransportConfigurator.mergeDevicePortElementsListsWithTransport(portList, transportList);
        this.coordinateWithCheckList(snmpAgentIndex, portList, checkListElement);
        return portList;
    }

    private void coordinateWithCheckList(char snmpAgentIndex, ConfigElementDataList portList, CheckListConfigElementData checkListElement) {
        ArrayList<CommKeyClassId> commKeysToCheckList = new ArrayList<CommKeyClassId>();
        for (ElementData element : portList) {
            CommKeyClassId commKeyClassIdToCheck = element.getCommKeyClassId();
            commKeysToCheckList.add(commKeyClassIdToCheck);
        }
        checkListElement.setCheckList(commKeysToCheckList);
        checkListElement.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(snmpAgentIndex));
        if (checkListElement.getClassId() == null) {
            checkListElement.setClassId(this.myClassId);
        }
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

