/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.ISCSIInitiatorConfigurator;
import com.sanrad.nms.server.mgr.ScsiInitiatorDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiPortConfigurator;
import com.sanrad.nms.server.mgr.ScsiTargetDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiTransportConfigurator;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.mgr.target.IscsiTargetConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.SCSIDeviceRoleConstant;
import java.util.ArrayList;
import java.util.HashMap;

public class ScsiDeviceConfigurator
extends ElementConfigurator {
    public ScsiDeviceConfigurator() {
        super(ClassID.SCSI_DEVICE, "scsiDeviceTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.SCSI_DEVICE_ID, null);
        paramList.put(ParameterCode.SCSI_DEVICE_NUM_OF_PORTS, null);
        paramList.put(ParameterCode.SCSI_DEVICE_ROLE, null);
        paramList.put(ParameterCode.SCSI_DEVICE_ALIAS, null);
        return paramList;
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ArrayList allElementsByClassId = this.getAllElements(snmpAgentIndex, lastUpdate, checkListElement);
        ConfigElementDataList allElements = new ConfigElementDataList();
        for (int index = 0; index < allElementsByClassId.size(); ++index) {
            allElements.addAll((ConfigElementDataList)allElementsByClassId.get(index));
        }
        return allElements;
    }

    public ConfigElementDataList refreshLocalTargets(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList deviceList = this.getAll(snmpAgentIndex, null, null);
        ScsiTargetDeviceConfigurator targetDeviceConfig = new ScsiTargetDeviceConfigurator();
        ConfigElementDataList scsiTargetList = targetDeviceConfig.getAllExtended(snmpAgentIndex, null, null);
        IscsiTargetConfigurator iscsiTarget = new IscsiTargetConfigurator();
        ConfigElementDataList targetList = iscsiTarget.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
        ScsiTransportConfigurator trnsportConfig = new ScsiTransportConfigurator();
        ConfigElementDataList transportList = trnsportConfig.getAllExtended(snmpAgentIndex, null, null);
        for (ConfigElementData deviceElem : deviceList) {
            SCSIDeviceRoleConstant role = (SCSIDeviceRoleConstant)deviceElem.getValue(ParameterCode.SCSI_DEVICE_ROLE);
            if (!role.equals(SCSIDeviceRoleConstant.TARGET)) continue;
            for (ConfigElementData tgtElem : scsiTargetList) {
                if (!tgtElem.getClassId().equals(ClassID.SCSI_TARGET) || !tgtElem.compareCommKey(deviceElem)) continue;
                tgtElem.addParameter(deviceElem.getParametersList());
            }
        }
        ConfigElementDataList remoteInitiatorsElements = new ConfigElementDataList();
        ScsiTransportConfigurator.mergeTargetElementsListsWithTransport(scsiTargetList, targetList, remoteInitiatorsElements, transportList);
        ConfigElementDataList allElements = new ConfigElementDataList();
        allElements.addAll(targetList);
        checkListElement.setCheckList(targetList.getAllCommkeyClassIDsInList());
        allElements.addAll(remoteInitiatorsElements);
        return allElements;
    }

    private ArrayList getAllElements(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList deviceList = this.getAll(snmpAgentIndex, null, null);
        ScsiInitiatorDeviceConfigurator initiatorDeviceConfig = new ScsiInitiatorDeviceConfigurator();
        ConfigElementDataList scsiInitiatorList = initiatorDeviceConfig.getAllExtended(snmpAgentIndex, null, null);
        ISCSIInitiatorConfigurator iscsiInitiatorConfig = new ISCSIInitiatorConfigurator();
        ConfigElementDataList initiatorList = iscsiInitiatorConfig.getAllExtended(snmpAgentIndex, null, null);
        ScsiTargetDeviceConfigurator targetDeviceConfig = new ScsiTargetDeviceConfigurator();
        ConfigElementDataList scsiTargetList = targetDeviceConfig.getAllExtended(snmpAgentIndex, null, null);
        IscsiTargetConfigurator iscsiTarget = new IscsiTargetConfigurator();
        ConfigElementDataList targetList = iscsiTarget.getAllExtended(snmpAgentIndex, null, null);
        ScsiPortConfigurator portConfig = new ScsiPortConfigurator();
        ConfigElementDataList portList = portConfig.getAllExtended(snmpAgentIndex, null, null);
        ScsiTransportConfigurator trnsportConfig = new ScsiTransportConfigurator();
        ConfigElementDataList transportList = trnsportConfig.getAllExtended(snmpAgentIndex, null, null);
        for (ConfigElementData deviceElem : deviceList) {
            SCSIDeviceRoleConstant role = (SCSIDeviceRoleConstant)deviceElem.getValue(ParameterCode.SCSI_DEVICE_ROLE);
            if (role.equals(SCSIDeviceRoleConstant.INITIATOR)) {
                for (ConfigElementData intrElem : scsiInitiatorList) {
                    if (!intrElem.getClassId().equals(ClassID.SCSI_INITIATOR) || !intrElem.compareCommKey(deviceElem)) continue;
                    intrElem.addParameter(deviceElem.getParametersList());
                }
                continue;
            }
            for (ConfigElementData tgtElem : scsiTargetList) {
                if (!tgtElem.getClassId().equals(ClassID.SCSI_TARGET) || !tgtElem.compareCommKey(deviceElem)) continue;
                tgtElem.addParameter(deviceElem.getParametersList());
            }
        }
        ConfigElementDataList remoteTargetsElements = new ConfigElementDataList();
        ConfigElementDataList remoteDiscoveryPortalsElements = new ConfigElementDataList();
        ConfigElementDataList remoteInitiatorsElements = new ConfigElementDataList();
        ScsiTransportConfigurator.mergeInitiatorElementsListsWithTransport(scsiInitiatorList, initiatorList, remoteTargetsElements, remoteDiscoveryPortalsElements, transportList);
        ScsiTransportConfigurator.mergeTargetElementsListsWithTransport(scsiTargetList, targetList, remoteInitiatorsElements, transportList);
        ScsiTransportConfigurator.mergeDevicePortElementsListsWithTransport(portList, transportList);
        ArrayList<ConfigElementDataList> allElementsByClassId = new ArrayList<ConfigElementDataList>(6);
        allElementsByClassId.add(initiatorList);
        allElementsByClassId.add(remoteTargetsElements);
        allElementsByClassId.add(remoteDiscoveryPortalsElements);
        allElementsByClassId.add(targetList);
        allElementsByClassId.add(remoteInitiatorsElements);
        allElementsByClassId.add(portList);
        return allElementsByClassId;
    }

    public PollingData refreshTableForPolling(char snmpAgentIndex) throws SrCommException {
        PollingData pollData = new PollingData();
        ArrayList elementList = this.getAllElements(snmpAgentIndex, null, null);
        this.addRefreshElements(pollData, snmpAgentIndex, ClassID.ISCSI_INITIATOR, (ConfigElementDataList)elementList.get(0));
        this.addRefreshElements(pollData, snmpAgentIndex, ClassID.ISCSI_REMOTE_TARGET, (ConfigElementDataList)elementList.get(1));
        this.addRefreshElements(pollData, snmpAgentIndex, ClassID.ISCSI_REMOTE_TARGET_PORTAL, (ConfigElementDataList)elementList.get(1));
        this.addRefreshElements(pollData, snmpAgentIndex, ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL, (ConfigElementDataList)elementList.get(2));
        this.addRefreshElements(pollData, snmpAgentIndex, ClassID.ISCSI_TARGET, (ConfigElementDataList)elementList.get(3));
        this.addRefreshElements(pollData, snmpAgentIndex, ClassID.ISCSI_REMOTE_INITIATOR, (ConfigElementDataList)elementList.get(4));
        this.addRefreshElements(pollData, snmpAgentIndex, ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS, (ConfigElementDataList)elementList.get(4));
        this.addRefreshElements(pollData, snmpAgentIndex, ClassID.SCSI_PORT, (ConfigElementDataList)elementList.get(5));
        return pollData;
    }

    private void addRefreshElements(PollingData aPollData, char snmpAgentIndex, ClassID classId, ConfigElementDataList elements) {
        ConfigElementDataList elementsWithSameClassId = new ConfigElementDataList();
        for (int index = 0; index < elements.size(); ++index) {
            if (!((ConfigElementData)elements.get(index)).getClassId().equals(classId)) continue;
            elementsWithSameClassId.add((ConfigElementData)elements.get(index));
        }
        CheckListConfigElementData checkListElement = new CheckListConfigElementData(classId);
        this.buildCheckListElement(elementsWithSameClassId, checkListElement, snmpAgentIndex, null);
        checkListElement.setCheckList(elementsWithSameClassId.getAllCommkeyClassIDsInList());
        aPollData.addConfigElementDataList(elementsWithSameClassId);
        aPollData.addCheckList(checkListElement);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

