/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.util.SrDebugLogObject;
import java.math.BigInteger;
import java.util.HashMap;

public class SCSIRemoteTargetPortalConfigurator
extends ElementConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();
    private BigInteger MAX_GROUP_TAG = new BigInteger("65535", 10);
    static Integer[] s_lastPortalIndex = new Integer[0];

    public SCSIRemoteTargetPortalConfigurator() {
        super(ClassID.ISCSI_REMOTE_TARGET_PORTAL, "srRemoteTgtPortalTable", MibItem.SCSI_REMOTE_TARGET_PORTAL_ROW_STATUS, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, null);
        paramList.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, null);
        return paramList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        CommKeyClassId vswitchData = (CommKeyClassId)element.removeParameter(ParameterCode.VSWITCH_ID);
        SnmpCommKey snmpCommKey = CommKeyUtil.getSnmpCommKey(vswitchData);
        char snmpAgent = snmpCommKey.getSnmpAgentIndex();
        CommKeyClassId remoteTargetCommKeyClassId = (CommKeyClassId)element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_ID);
        CommKeyClassId remotePortalIdToRemoveIfNeeded = (CommKeyClassId)element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_ID);
        if (remotePortalIdToRemoveIfNeeded != null) {
            ConfigElementData elementToRemove = new ConfigElementData(CommKeyUtil.getSpecificCommKeyClassId(remotePortalIdToRemoveIfNeeded, snmpAgent));
            elementToRemove.setValue(ParameterCode.VSWITCH_ID, vswitchData);
            this.internalRemove(elementToRemove);
            SrEventHandler.getEventMgr().sendRemoveElementEvent(elementToRemove, this);
            this.updateParentRemoteTarget(remoteTargetCommKeyClassId);
        }
        String remoteTargetCommKey = CommKeyUtil.getSpecificCommKey(remoteTargetCommKeyClassId, snmpAgent).getKey();
        Integer[] integerArray = s_lastPortalIndex;
        synchronized (s_lastPortalIndex) {
            this.calculatePortalCommKey(snmpAgent, element, remoteTargetCommKey);
            super.internalCreate(element);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            theLogger.debug(SrLogCategories.INFORMATIVE, new SrDebugLogObject("At this point (SCSIRemoteTargetPortalConfigurator::internalCreate) the old code used 'sleep' for 4000ms.", element));
            this.updateParentRemoteTarget(remoteTargetCommKeyClassId);
            return;
        }
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        CommKeyClassId remoteTargetCommKeyClassId = (CommKeyClassId)element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_ID);
        SrBoolean parentRemoteTargetInDeleteProcess = (SrBoolean)element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_IN_DELETE_PROCESS);
        super.internalRemove(element);
        if (parentRemoteTargetInDeleteProcess != null && parentRemoteTargetInDeleteProcess.equals(false)) {
            theLogger.debug(SrLogCategories.INFORMATIVE, new SrDebugLogObject("At this point (SCSIRemoteTargetPortalConfigurator::internalRemove) the old code used 'sleep' for 4000ms", element));
            this.updateParentRemoteTarget(remoteTargetCommKeyClassId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String index = element.getSnmpKey().toString();
        int pos = index.lastIndexOf(".") + 1;
        index = index.substring(pos);
        Integer idIndex = new Integer(index);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        Integer[] integerArray = s_lastPortalIndex;
        synchronized (s_lastPortalIndex) {
            if (s_lastPortalIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(s_lastPortalIndex, 0, newArray, 0, s_lastPortalIndex.length);
                newArray[agentIndex] = idIndex;
                s_lastPortalIndex = newArray;
            } else if (s_lastPortalIndex[agentIndex] == null || idIndex > s_lastPortalIndex[agentIndex]) {
                SCSIRemoteTargetPortalConfigurator.s_lastPortalIndex[agentIndex] = idIndex;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            String portalCommKey = element.getSnmpKey().getKey();
            String tmpCommKey = portalCommKey.substring(0, portalCommKey.lastIndexOf("."));
            String remoteTargetCommKey = tmpCommKey.substring(0, tmpCommKey.lastIndexOf("."));
            CommKeyClassId remoteTargetCommKeyClassId = new CommKeyClassId(new SnmpCommKey(remoteTargetCommKey, element.getMyFirstSnmpAgentIndex()), ClassID.ISCSI_REMOTE_TARGET);
            element.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_ID, remoteTargetCommKeyClassId));
            String portalGroupTag = tmpCommKey.substring(tmpCommKey.lastIndexOf(".") + 1);
            if (portalGroupTag.equals(this.MAX_GROUP_TAG.toString(10))) {
                portalGroupTag = "-1";
            }
            SrInteger portalGroupTagInt = new SrInteger(Integer.parseInt(portalGroupTag));
            element.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, portalGroupTagInt));
            return;
        }
    }

    public void calculatePortalCommKey(char snmpAgent, ConfigElementData element, String remoteTargetKey) throws SrCommException {
        if (s_lastPortalIndex.length <= snmpAgent) {
            Integer[] newArray = new Integer[snmpAgent + '\u0001'];
            System.arraycopy(s_lastPortalIndex, 0, newArray, 0, s_lastPortalIndex.length);
            newArray[snmpAgent] = new Integer(0);
            s_lastPortalIndex = newArray;
        } else if (s_lastPortalIndex[snmpAgent] == null) {
            SCSIRemoteTargetPortalConfigurator.s_lastPortalIndex[snmpAgent] = new Integer(0);
        }
        SrInteger groupTag = (SrInteger)element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG);
        int groupTagVal = groupTag.intValue();
        String groupTagStr = String.valueOf(groupTagVal);
        if (groupTagVal == -1) {
            groupTagStr = this.MAX_GROUP_TAG.toString(10);
        }
        this.getAll(snmpAgent, null, null);
        Integer newIndex = new Integer(s_lastPortalIndex[snmpAgent] + 1);
        String keyToSet = remoteTargetKey + "." + groupTagStr + "." + newIndex.toString();
        element.setCommKey(new SnmpCommKey(keyToSet, snmpAgent));
    }

    private void updateParentRemoteTarget(CommKeyClassId remoteTargetCommKeyClassId) throws SrCommException {
        SCSIRemoteTargetConfigurator remoteTargetCfg = new SCSIRemoteTargetConfigurator();
        ConfigElementData remoteTargetElement = new ConfigElementData(remoteTargetCommKeyClassId);
        remoteTargetCfg.read(remoteTargetElement);
        ConfigElementData readElement = remoteTargetCfg.readAndMergeRemoteTarget(remoteTargetElement);
        SrEventHandler.getEventMgr().sendChangeElementEvent(readElement, (Object)this);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return SCSIRemoteTargetPortalConfigurator.getNextIncrementalIndex(aElement.getCommKeyClassId());
    }
}

