/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetPortalConfigurator;
import com.sanrad.nms.server.mgr.SrSCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.util.SrDebugLogObject;
import java.util.HashMap;

public class SCSIRemoteTargetConfigurator
extends ElementConfigurator {
    static Integer[] lastRemoteTargetIndex = new Integer[0];
    private static SrLogger theLogger = SrLogger.getLogger();

    public SCSIRemoteTargetConfigurator() {
        super(ClassID.SCSI_REMOTE_TARGET, "scsiDscTgtTable", MibItem.SCSI_DISCOVER_TARGET_ROW_STATUS, MibItem.SCSI_REMOTE_TARGET_LAST_CHANGE);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.DISCOVERED_TARGET_NAME, null);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED, null);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED, null);
        paramList.put(ParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, null);
        return paramList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        Integer[] integerArray = lastRemoteTargetIndex;
        synchronized (lastRemoteTargetIndex) {
            Object rTargetAlias = element.removeParameter(ParameterCode.SCSI_REMOTE_TARGET_ALIAS);
            Object rTargetIdentityAlias = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_IDENTITY_ALIAS);
            Object rTargetCHAPUserName = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME);
            Object rTargetCHAPPassword = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD);
            Object arrayOfrTargetPortalIPs = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP);
            Object arrayOfrTargetPortalPorts = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT);
            Object arrayOfrTargetPortalGroupTags = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG);
            this.calculateRemoteTargetCommKey(element);
            super.internalCreate(element);
            SrSCSIRemoteTargetConfigurator srSCSIRemoteTargetCfg = new SrSCSIRemoteTargetConfigurator();
            element = new ConfigElementData(element.getCommKeyClassId());
            this.changeRemoteTargetAliasOnCreate(srSCSIRemoteTargetCfg, element, rTargetAlias);
            element = new ConfigElementData(element.getCommKeyClassId());
            srSCSIRemoteTargetCfg.internalRead(element);
            this.changeRemoteTargetIdentityAndCHAPCredOnCreate(element, rTargetIdentityAlias, rTargetCHAPUserName, rTargetCHAPPassword);
            if (arrayOfrTargetPortalIPs != null) {
                this.createRemoteTargetPortalsOnCreate(element, arrayOfrTargetPortalIPs, arrayOfrTargetPortalPorts, arrayOfrTargetPortalGroupTags);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void calculateRemoteTargetCommKey(ConfigElementData element) throws SrCommException {
        CommKeyClassId vswitchData = (CommKeyClassId)element.removeParameter(ParameterCode.VSWITCH_ID);
        SnmpCommKey snmpCommKey = CommKeyUtil.getSnmpCommKey(vswitchData);
        char agentIndex = snmpCommKey.getSnmpAgentIndex();
        CommKeyClassId[] initiatorsIds = (CommKeyClassId[])element.getValue(ParameterCode.ISCSI_INITIATOR_ID);
        CommKeyClassId initiatorId = CommKeyUtil.getSpecificCommKeyClassId(initiatorsIds, agentIndex);
        String initiatorCommKey = CommKeyUtil.getSpecificSnmpKey(initiatorId, agentIndex).getKey();
        if (lastRemoteTargetIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastRemoteTargetIndex, 0, newArray, 0, lastRemoteTargetIndex.length);
            newArray[agentIndex] = new Integer(0);
            lastRemoteTargetIndex = newArray;
        } else if (lastRemoteTargetIndex[agentIndex] == null) {
            SCSIRemoteTargetConfigurator.lastRemoteTargetIndex[agentIndex] = new Integer(0);
        }
        this.getAll(agentIndex, null, null);
        Integer newIndex = new Integer(lastRemoteTargetIndex[agentIndex] + 1);
        element.setCommKey(new SnmpCommKey(initiatorCommKey + ".0." + newIndex.toString(), agentIndex));
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList remoteTargetList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (remoteTargetList != null && remoteTargetList.size() > 0) {
            this.removeNotSupportedRemoteTargets(remoteTargetList);
            SrSCSIRemoteTargetConfigurator srSCSIRemoteTargetCfg = new SrSCSIRemoteTargetConfigurator();
            ConfigElementDataList srRemoteTargetList = srSCSIRemoteTargetCfg.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            srSCSIRemoteTargetCfg.mergeElementLists(remoteTargetList, srRemoteTargetList, true);
            SCSIRemoteTargetPortalConfigurator remoteTargetPortalConfig = new SCSIRemoteTargetPortalConfigurator();
            ConfigElementDataList remoteTargetPortalList = remoteTargetPortalConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            remoteTargetList.addAll(remoteTargetPortalList);
        }
        if (remoteTargetList == null) {
            remoteTargetList = new ConfigElementDataList();
        }
        return remoteTargetList;
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        ConfigElementData newElement = new ConfigElementData(element.getCommKeyClassId());
        ConfigElementDataList retrievedElements = new ConfigElementDataList();
        this.internalRead(newElement, retrievedElements);
        SrEventHandler.getEventMgr().sendAddElementEvent(retrievedElements, (Object)this);
        return true;
    }

    @Override
    public void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        IdentityConfigurator identityCfg = new IdentityConfigurator();
        CommKeyClassId identityCommKeyClassId = (CommKeyClassId)element.getValue(ParameterCode.IDENTITY_ID);
        if (identityCommKeyClassId != null) {
            ConfigElementData identityElement = new ConfigElementData(identityCommKeyClassId);
            identityCfg.internalRead(identityElement, retrievedElements);
        }
        ConfigElementData mergedElement = this.readAndMergeRemoteTarget(element);
        SCSIRemoteTargetPortalConfigurator remoteTargetPortalConfig = new SCSIRemoteTargetPortalConfigurator();
        ConfigElementDataList portalsByPrefix = remoteTargetPortalConfig.getAllByPrefix(snmpAgentIndex, element.getSnmpKey().toString());
        if (retrievedElements != null) {
            retrievedElements.add(mergedElement);
            retrievedElements.addAll(portalsByPrefix);
        }
    }

    public ConfigElementData readAndMergeRemoteTarget(ConfigElementData element) throws SrCommException {
        ConfigElementData newElement = new ConfigElementData(element.getCommKeyClassId());
        SrSCSIRemoteTargetConfigurator srSCSIRemoteTargetCfg = new SrSCSIRemoteTargetConfigurator();
        srSCSIRemoteTargetCfg.internalRead(newElement);
        ConfigElementDataList srRemoteTargetList = new ConfigElementDataList();
        srRemoteTargetList.add(newElement);
        ConfigElementDataList remoteTargetList = new ConfigElementDataList();
        remoteTargetList.add(element);
        srSCSIRemoteTargetCfg.mergeElementLists(remoteTargetList, srRemoteTargetList, true);
        return (ConfigElementData)remoteTargetList.getElementDataAt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String index = element.getSnmpKey().toString();
        int pos = index.lastIndexOf(".") + 1;
        index = index.substring(pos);
        Integer idIndex = new Integer(index);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        Integer[] integerArray = lastRemoteTargetIndex;
        synchronized (lastRemoteTargetIndex) {
            SrInteger isDiscoveredInt;
            if (lastRemoteTargetIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastRemoteTargetIndex, 0, newArray, 0, lastRemoteTargetIndex.length);
                newArray[agentIndex] = idIndex;
                lastRemoteTargetIndex = newArray;
            } else if (lastRemoteTargetIndex[agentIndex] == null || idIndex > lastRemoteTargetIndex[agentIndex]) {
                SCSIRemoteTargetConfigurator.lastRemoteTargetIndex[agentIndex] = idIndex;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            SrInteger isConfiguredInt = (SrInteger)element.getValue(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED);
            if (isConfiguredInt != null) {
                element.setValue(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED, new SrBoolean(isConfiguredInt.intValue()));
            }
            if ((isDiscoveredInt = (SrInteger)element.getValue(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED)) != null) {
                element.setValue(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED, new SrBoolean(isDiscoveredInt.intValue()));
            }
            return;
        }
    }

    private void changeRemoteTargetAliasOnCreate(SrSCSIRemoteTargetConfigurator srSCSIRemoteTargetCfg, ConfigElementData remoteTargetElement, Object alias) throws SrCommException {
        remoteTargetElement.addParameter(new Parameter(ParameterCode.SCSI_REMOTE_TARGET_ALIAS, alias));
        srSCSIRemoteTargetCfg.internalChange(remoteTargetElement);
    }

    private void changeRemoteTargetIdentityAndCHAPCredOnCreate(ConfigElementData remoteTargetElement, Object identityAlias, Object userName, Object password) throws SrCommException {
        IdentityConfigurator identityConfigurator = new IdentityConfigurator();
        CommKeyClassId identityCommKeyClassId = (CommKeyClassId)remoteTargetElement.getValue(ParameterCode.IDENTITY_ID);
        ConfigElementData identityElement = new ConfigElementData(identityCommKeyClassId);
        ConfigElementDataList retrievedElements = new ConfigElementDataList();
        identityConfigurator.internalRead(identityElement, retrievedElements);
        for (ConfigElementData retreivedElement : retrievedElements) {
            SrEventHandler.getEventMgr().sendAddElementEvent(retreivedElement, (Object)this);
            if (!retreivedElement.getClassId().equals(ClassID.CHAP_CREDENTIALS)) continue;
            if (userName != null || password != null) {
                CommKeyClassId chapCredId = retreivedElement.getCommKeyClassId();
                ConfigElementData newChapCredElement = new ConfigElementData(chapCredId);
                if (userName != null) {
                    newChapCredElement.addParameter(new Parameter(ParameterCode.CHAP_CREDENTIALS_USER_NAME, userName));
                }
                if (password != null) {
                    newChapCredElement.addParameter(new Parameter(ParameterCode.CHAP_CREDENTIALS_PASSWORD, password));
                }
                CHAPCredentialsConfigurator chapCredConfigurator = new CHAPCredentialsConfigurator();
                chapCredConfigurator.internalChange(newChapCredElement);
            }
            return;
        }
    }

    private void createRemoteTargetPortalsOnCreate(ConfigElementData remoteTargetElement, Object arrayOfrTargetPortalIPs, Object arrayOfrTargetPortalPorts, Object arrayOfrTargetPortalGroupTags) throws SrCommException {
        CommKeyClassId vswitchData = CommKeyUtil.getVSwitchData(remoteTargetElement.getMyFirstSnmpAgentIndex());
        SrString[] remoteTargetPortalIPs = (SrString[])arrayOfrTargetPortalIPs;
        SrGauge[] remoteTargetPortalPorts = (SrGauge[])arrayOfrTargetPortalPorts;
        SrInteger[] remoteTargetPortalGroupTags = (SrInteger[])arrayOfrTargetPortalGroupTags;
        SCSIRemoteTargetPortalConfigurator portalConfigurator = new SCSIRemoteTargetPortalConfigurator();
        ConfigElementData remoteTargetPortalElement = new ConfigElementData(ClassID.ISCSI_REMOTE_TARGET_PORTAL);
        for (int index = 0; index < remoteTargetPortalIPs.length; ++index) {
            remoteTargetPortalElement.setValue(ParameterCode.VSWITCH_ID, vswitchData);
            remoteTargetPortalElement.setValue(ParameterCode.ISCSI_REMOTE_TARGET_ID, remoteTargetElement.getCommKeyClassId());
            SrString remoteTargetPortalIP = remoteTargetPortalIPs[index];
            SrGauge remoteTargetPortalPort = remoteTargetPortalPorts[index];
            SrInteger remoteTargetPortalGroupTag = remoteTargetPortalGroupTags[index];
            remoteTargetPortalElement.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, new SrIpAddress(remoteTargetPortalIP.toString())));
            remoteTargetPortalElement.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, remoteTargetPortalPort));
            remoteTargetPortalElement.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, remoteTargetPortalGroupTag));
            portalConfigurator.internalCreate(remoteTargetPortalElement);
        }
    }

    public void refreshRemoteTargetsForDependantOnOperations(char snmpAgent) throws SrCommException {
        ConfigElementDataList elements = this.getAllExtended(snmpAgent, null, null);
        IdentityConfigurator identityCfg = new IdentityConfigurator();
        ConfigElementDataList retrievedElements = new ConfigElementDataList();
        for (int index = 0; index < elements.size(); ++index) {
            retrievedElements.clear();
            ConfigElementData nextElement = (ConfigElementData)elements.get(index);
            if (!nextElement.getClassId().equals(ClassID.ISCSI_REMOTE_TARGET)) continue;
            CommKeyClassId identityCommKeyClassId = (CommKeyClassId)nextElement.getValue(ParameterCode.IDENTITY_ID);
            ConfigElementData identityElement = new ConfigElementData(identityCommKeyClassId);
            identityCfg.internalRead(identityElement, retrievedElements);
            SrEventHandler.getEventMgr().sendRefreshElementEvent(retrievedElements, (Object)this);
        }
        SrEventHandler.getEventMgr().sendRefreshElementEvent(elements, (Object)this);
        theLogger.debug(SrLogCategories.INFORMATIVE, new SrDebugLogObject("At this point (SCSIRemoteTargetConfigurator::refreshRemoteTargetsForDependantOnOperations) the old code used 'sleep' for 4000ms.", elements));
    }

    private void removeNotSupportedRemoteTargets(ConfigElementDataList remoteTargetList) {
        ConfigElementDataList supportedElements = new ConfigElementDataList();
        for (int index0 = 0; index0 < remoteTargetList.size(); ++index0) {
            ConfigElementData element = (ConfigElementData)remoteTargetList.getElementDataAt(index0);
            String elementSnmpKey = element.getSnmpKey().getKey();
            String prefix = elementSnmpKey.substring(0, elementSnmpKey.lastIndexOf("."));
            String thirdNumberInPrefix = prefix.substring(prefix.lastIndexOf(".") + 1);
            String secondNumberInPrefix = prefix.substring(prefix.indexOf(".") + 1, prefix.lastIndexOf("."));
            if (secondNumberInPrefix.equals("2")) {
                if (!thirdNumberInPrefix.equals("0")) continue;
                supportedElements.add(element);
                continue;
            }
            supportedElements.add(element);
        }
        remoteTargetList.clear();
        remoteTargetList.addAll(supportedElements);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return SCSIRemoteTargetConfigurator.getNextIncrementalIndex(aElement.getCommKeyClassId());
    }
}

