/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiPortalConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrIpAddress;
import java.util.HashMap;

public class NetConfigConfigurator
extends ElementConfigurator {
    static Integer[] lastIpIndex = new Integer[0];

    public NetConfigConfigurator() {
        super(ClassID.NETWORK_CONFIGURATION, "srNetworkConfigurationTable", MibItem.IP_TABLE_RS, MibItem.IP_TABLE_LAST_UPDATE);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.NETWORK_CONFIG_ACTIVITY, null);
        paramList.put(ParameterCode.NETWORK_CONFIG_INTERFACE, null);
        paramList.put(ParameterCode.NETWORK_CONFIG_IP_ADDRESS, null);
        paramList.put(ParameterCode.NETWORK_CONFIG_NET_MASK, null);
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        Integer ipIndex = new Integer(element.getSnmpKey().toString());
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastIpIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastIpIndex, 0, newArray, 0, lastIpIndex.length);
            newArray[agentIndex] = ipIndex;
            lastIpIndex = newArray;
        } else if (lastIpIndex[agentIndex] == null || ipIndex > lastIpIndex[agentIndex]) {
            NetConfigConfigurator.lastIpIndex[agentIndex] = ipIndex;
        }
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getSnmpAgentFromParameter();
        if (lastIpIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastIpIndex, 0, newArray, 0, lastIpIndex.length);
            newArray[agentIndex] = new Integer(0);
            lastIpIndex = newArray;
        } else if (lastIpIndex[agentIndex] == null) {
            NetConfigConfigurator.lastIpIndex[agentIndex] = new Integer(0);
        }
        this.getAll(agentIndex, null, null);
        Integer newIndex = new Integer(lastIpIndex[agentIndex] + 1);
        element.setCommKey(new SnmpCommKey(newIndex.toString(), agentIndex));
        super.internalCreate(element);
    }

    @Override
    public void postSendCreateEvent(ConfigElementData myElement) throws SrCommException {
        SrIpAddress ipAddress = (SrIpAddress)myElement.getValue(ParameterCode.NETWORK_CONFIG_IP_ADDRESS);
        char snmpAgent = myElement.getSnmpAgentFromParameter();
        IscsiPortalConfigurator portalCfg = new IscsiPortalConfigurator();
        ConfigElementDataList list = portalCfg.refreshTable(snmpAgent, null, null);
        for (ElementData portalElement : list) {
            SrIpAddress portalIpAddress = (SrIpAddress)portalElement.getValue(ParameterCode.ISCSI_PORTAL_IP_ADDRESS);
            if (!portalIpAddress.toDisplayString().equals(ipAddress.toDisplayString())) continue;
            SrEventHandler.getEventMgr().sendAddElementEvent((ConfigElementData)portalElement, (Object)this);
        }
    }

    @Override
    public void postSendRemoveEvent(ConfigElementData myElement) throws SrCommException {
        char snmpAgent = myElement.getMyFirstSnmpAgentIndex();
        CheckListConfigElementData checkList = new CheckListConfigElementData(ClassID.PORTAL);
        IscsiPortalConfigurator portalCfg = new IscsiPortalConfigurator();
        ConfigElementDataList list = portalCfg.refreshTable(snmpAgent, null, checkList);
        SrEventHandler.getEventMgr().sendCheckListEvent(checkList, this);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(list, (Object)this);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return NetConfigConfigurator.getNextIncrementalIndex(aElement.getCommKeyClassId());
    }
}

