/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.HashMap;

public class NeighborConfigurator
extends ElementConfigurator {
    public NeighborConfigurator() {
        super(ClassID.NEIGHBORE, "srSDNeighboursTable", null, MibItem.STORAGE_DOMAIN_TBL_LAST_UPDATED);
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        SnmpCommKey snmpKey;
        String key;
        SrTimeTicks lastKeepAliveVal = (SrTimeTicks)element.getValue(ParameterCode.NEIGHBOR_LAST_KEEPALIVE);
        if (lastKeepAliveVal != null) {
            SrDateAndTime keepaliveTime = this.getDate(element.getMyFirstSnmpAgentIndex(), lastKeepAliveVal);
            element.setValue(ParameterCode.NEIGHBOR_LAST_KEEPALIVE, keepaliveTime);
        }
        if ((key = (snmpKey = element.getSnmpKey()).getKey()).substring(0, key.indexOf(".")).equals("1")) {
            SnmpCommKey newKey = new SnmpCommKey(key.substring(key.indexOf(".") + 1), snmpKey.getSnmpAgentIndex());
            element.setCommKey(newKey);
        }
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.NEIGHBOR_LAST_KEEPALIVE, null);
        paramList.put(ParameterCode.NEIGHBOR_STATUS, null);
        return paramList;
    }

    @Override
    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        if (element.containsParameter(ParameterCode.NEIGHBOR_LAST_KEEPALIVE)) {
            SrOid dateAndTime = new SrOid(MibItem.VSWITCH_DATE_AND_TIME.toString(), "0");
            list.add(new SrSnmpVarBind(dateAndTime, null));
            SrOid sysUpTime = new SrOid(MibItem.VSWITCH_SYS_UP_TIME.toString(), "0");
            list.add(new SrSnmpVarBind(sysUpTime, null));
        }
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

