/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.TargetTypeConstants;
import java.util.HashMap;

public class LUNConfigurator
extends ElementConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public LUNConfigurator() {
        super(ClassID.LUN, "srVirtLogUnTable", MibItem.LUN_RS, MibItem.LUN_TBL_LAST_UPDATE, false);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId targetId = (CommKeyClassId)element.getValue(ParameterCode.LU_PARENT);
        if (!targetId.getClassID().equals(ClassID.ISCSI_TARGET)) {
            theLogger.info(SrLogCategories.LEGACY, "Failed to create LU: Target of unknown type");
            throw new UnsupportedOperationException("Cannot create LU under target of unknown type");
        }
        SnmpCommKey specificTgtKey = CommKeyUtil.getSpecificSnmpKey(targetId, snmpAgentIndex);
        String targetIndices = specificTgtKey.getKey();
        String targetIdStr = targetIndices.substring(targetIndices.lastIndexOf(".") + 1);
        element.setValue(ParameterCode.LU_PARENT, new SrInteger(targetIdStr));
        CommKeyClassId volumeOrStorage = (CommKeyClassId)element.getValue(ParameterCode.LU_VOLUME_ID);
        boolean simpleVolumeWasCreated = false;
        CommKeyClassId volumeId = null;
        SrInteger indexNext = (SrInteger)this.getScalarFromComm(MibItem.LUN_NEXT_INDEX, snmpAgentIndex);
        SnmpCommKey key = new SnmpCommKey("1." + indexNext.toString(), snmpAgentIndex);
        element.setCommKey(key);
        if (volumeOrStorage.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || volumeOrStorage.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            CommKeyClassId physStorData = volumeOrStorage;
            SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
            SnmpCommKey simpleVolKey = simpleCnf.createSimpleVolume(physStorData, (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID));
            simpleVolumeWasCreated = true;
            volumeId = new CommKeyClassId(simpleVolKey, ClassID.SIMPLE_VOLUME);
        } else {
            volumeId = volumeOrStorage;
        }
        String volIndex = CommKeyUtil.getSpecificCommKey(volumeId, snmpAgentIndex).getKey();
        SrGauge volId = new SrGauge(volIndex.substring(volIndex.indexOf(".") + 1));
        element.setValue(ParameterCode.LU_VOLUME_ID, volId);
        try {
            super.internalCreate(element);
        }
        catch (SrCommException e) {
            if (simpleVolumeWasCreated) {
                theLogger.error(SrLogCategories.ERROR, "rolling back after: ", e.getMessage());
                SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
                simpleCnf.removeSimpleVolume(volumeOrStorage, snmpAgentIndex);
                element.setValue(ParameterCode.LU_VOLUME_ID, volumeOrStorage);
            }
            throw e;
        }
    }

    @Override
    protected void addCommVarBindsToCreateList(CommVarBindList list, ConfigElementData element) {
        SnmpCommKey luSnmpKey = element.getSnmpKey();
        SrOid tgtTypeOid = new SrOid(MibItem.LUN_TARGET_TYPE.toString(), luSnmpKey.toString());
        list.add(new SrSnmpVarBind(tgtTypeOid, (SrType)TargetTypeConstants.TARGET_TYPE_ISCSI));
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.LU_LUN_NUMBER, null);
        paramList.put(ParameterCode.LU_PARENT, null);
        paramList.put(ParameterCode.LU_OPER_STATUS, null);
        paramList.put(ParameterCode.LU_CREATION_DATE, null);
        paramList.put(ParameterCode.LU_LAST_UPDATE, null);
        paramList.put(ParameterCode.LU_SERIAL_NUMBER, null);
        paramList.put(ParameterCode.LU_VOLUME_ID, null);
        paramList.put(ParameterCode.LU_PARENT, null);
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        this.createTargetDataFromTypeAndIndex(element, list);
        SrGauge volId = (SrGauge)element.getValue(ParameterCode.LU_VOLUME_ID);
        if (volId != null) {
            String fullVolId = "1." + volId.toString();
            CommKeyClassId simpleVolId = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(list.getSnmpAgentIndex(), fullVolId);
            if (simpleVolId == null) {
                CommKeyClassId volCKID = new CommKeyClassId(new SnmpCommKey(fullVolId, list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
                ConfigElementData volCED = new ConfigElementData(volCKID);
                volCED.addParameterToElement(element, ParameterCode.VSWITCH_ID);
                VolumeConfigurator configurator = new VolumeConfigurator();
                configurator.internalRead(volCED);
                element.setValue(ParameterCode.LU_VOLUME_ID, volCED.getCommKeyClassId());
            } else {
                element.setValue(ParameterCode.LU_VOLUME_ID, simpleVolId);
            }
        }
    }

    private void createTargetDataFromTypeAndIndex(ConfigElementData element, CommVarBindList list) {
        SrType tgtIndx = (SrType)element.getValue(ParameterCode.LU_PARENT);
        if (tgtIndx != null) {
            SnmpCommKey tgtCommKey = new SnmpCommKey("1.1." + String.valueOf(((SrInteger)tgtIndx).intValue()), element.getMyFirstSnmpAgentIndex());
            CommKeyClassId tgtData = new CommKeyClassId(tgtCommKey, ClassID.ISCSI_TARGET);
            element.setValue(ParameterCode.LU_PARENT, tgtData);
        }
    }

    @Override
    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        SnmpCommKey luSnmpKey = element.getSnmpKey();
        SrOid oid = new SrOid(MibItem.LUN_TARGET_TYPE.toString(), luSnmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 6: {
                return MibItem.LUN_OPER_STATUS;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        theLogger.trace(SrLogCategories.LEGACY, "Changed by Trap for ", element.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendChangeElementEvent(element, (Object)trap);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return this.getNextMIBIndex(aElement.getCommKeyClassId(), MibItem.LUN_NEXT_INDEX);
    }
}

