/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrType;

public class IpRouteConfigurator
extends ElementConfigurator {
    public IpRouteConfigurator() {
        super(ClassID.IP_ROUTE, "ipCidrRouteTable", MibItem.IP_ROUTE_RS, MibItem.IP_TABLE_CIDR_ROUTE_LAST_UPDATE);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        Object ifData = element.getValue(ParameterCode.IP_ROUTE_INTERFACE);
        if (ifData == null) {
            throw new MissingValueException("IP Route Create - Missing Data of Interface for Agent: " + CommKeyUtil.getIpFromIndex(element.getSnmpAgentFromParameter()));
        }
        SrIpAddress destIp = (SrIpAddress)element.getValue(ParameterCode.IP_ROUTE_DESTINATION_IP);
        SrIpAddress destMask = (SrIpAddress)element.getValue(ParameterCode.IP_ROUTE_DESTINATION_IP_MASK);
        SrIpAddress gateway = (SrIpAddress)element.getValue(ParameterCode.IP_ROUTE_GATEWAY);
        SrInteger tos = (SrInteger)element.getValue(ParameterCode.IP_ROUTE_TOS);
        String routeIndex = destIp.toString() + "." + destMask.toString() + "." + tos.toString() + "." + gateway.toString();
        element.setCommKey(new SnmpCommKey(routeIndex, element.getSnmpAgentFromParameter()));
        super.internalCreate(element);
    }

    @Override
    protected void addCommVarBindsToCreateList(CommVarBindList list, ConfigElementData element) {
        SnmpCommKey routeIndex = element.getSnmpKey();
        CommKeyClassId ifData = (CommKeyClassId)element.getValue(ParameterCode.IP_ROUTE_INTERFACE);
        SnmpCommKey ifKey = CommKeyUtil.getSpecificSnmpKey(ifData, element.getSnmpAgentFromParameter());
        SrOid ifIndexOid = new SrOid(MibItem.IP_ROUTE_IF_INDEX.toString(), routeIndex.toString());
        list.add(new SrSnmpVarBind(ifIndexOid, (SrType)new SrInteger(ifKey.toString())));
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        SrType index = IpRouteConfigurator.getVarBindValueFromList(list, MibItem.IP_ROUTE_IF_INDEX);
        if (index != null) {
            SnmpCommKey ifIndex = new SnmpCommKey(index.toString(), element.getMyFirstSnmpAgentIndex());
            CommKeyClassId ifData = new CommKeyClassId(ifIndex, ClassID.INTERFACE);
            element.setValue(ParameterCode.IP_ROUTE_INTERFACE, ifData);
        }
        String routeIndex = element.getSnmpKey().toString();
        SrIpAddress destinationIP = new SrIpAddress(this.getIPFromLongIndex(routeIndex, 0));
        SrIpAddress destinationMask = new SrIpAddress(this.getIPFromLongIndex(routeIndex, 4));
        SrIpAddress gateway = new SrIpAddress(this.getIPFromLongIndex(routeIndex, 9));
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_DESTINATION_IP, destinationIP));
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_DESTINATION_IP_MASK, destinationMask));
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_GATEWAY, gateway));
    }

    private String getIPFromLongIndex(String index, int startDot) {
        int i;
        String tmpIndex = index;
        String ip = "";
        for (i = 0; i < startDot; ++i) {
            tmpIndex = tmpIndex.substring(tmpIndex.indexOf(".") + 1);
        }
        for (i = 0; i < 4; ++i) {
            if (tmpIndex.indexOf(".") <= 0) {
                ip = ip + tmpIndex;
                break;
            }
            ip = ip + tmpIndex.substring(0, tmpIndex.indexOf(".") + 1);
            tmpIndex = tmpIndex.substring(tmpIndex.indexOf(".") + 1);
        }
        if (ip.lastIndexOf(".") == ip.length() - 1) {
            ip = ip.substring(0, ip.lastIndexOf("."));
        }
        return ip;
    }

    @Override
    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        SrOid ifIndexOid = new SrOid(MibItem.IP_ROUTE_IF_INDEX.toString(), element.getSnmpKey().toString());
        list.add(new SrSnmpVarBind(ifIndexOid, null));
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return aElement.getCommKeyClassId();
    }
}

