/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionErrorConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.HashMap;

public class IScsiSessionStatisticConfigurator
extends ElementConfigurator {
    public IScsiSessionStatisticConfigurator() {
        super(ClassID.ISCSI_SESSION_STATISTICS, "iscsiSessionStatsTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.ISCSI_SESSION_CMD_PDUS, null);
        paramList.put(ParameterCode.ISCSI_SESSION_RSP_PDUS, null);
        paramList.put(ParameterCode.ISCSI_SESSION_RX_DATA_OCTETS, null);
        paramList.put(ParameterCode.ISCSI_SESSION_TX_DATA_OCTETS, null);
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String sessionkey = element.getSnmpKey().getKey();
        SnmpCommKey sessionCommKey = new SnmpCommKey(sessionkey, element.getMyFirstSnmpAgentIndex());
        CommKeyClassId sessionCommKeyClassId = new CommKeyClassId(sessionCommKey, ClassID.ISCSI_SESSION);
        element.addParameter(new Parameter(ParameterCode.ISCSI_SESSION_ID, sessionCommKeyClassId));
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList sessionsStatisticsList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (sessionsStatisticsList.size() > 0) {
            IScsiSessionErrorConfigurator sessionsErrorsConfig = new IScsiSessionErrorConfigurator();
            ConfigElementDataList sessionsErrorsList = sessionsErrorsConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            this.mergeElementLists(sessionsStatisticsList, sessionsErrorsList, true);
        }
        return sessionsStatisticsList;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

