/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.IscsiRemoteInitatoresStatisticsConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.HashMap;

public class IScsiRemoteInitatoresConfigurator
extends ElementConfigurator {
    public IScsiRemoteInitatoresConfigurator() {
        super(ClassID.ISCSI_REMOTE_INITIATOR, "scsiAuthorizedIntrTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.ISCSI_REMOTE_INITIATOR_NAME, null);
        return paramList;
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList remoteInitiatorList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (remoteInitiatorList.size() > 0) {
            IscsiRemoteInitatoresStatisticsConfigurator iscsiRInitStatConfig = new IscsiRemoteInitatoresStatisticsConfigurator();
            ConfigElementDataList remoteInitiatorsStatisticsList = iscsiRInitStatConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            remoteInitiatorList.addAll(remoteInitiatorsStatisticsList);
        }
        return remoteInitiatorList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        super.readDiscoverPostOperation(element, list);
        String elementKey = element.getSnmpKey().getKey();
        String remoteInitiatorPortKey = elementKey.substring(0, elementKey.lastIndexOf("."));
        String localTargetKey = elementKey.substring(0, remoteInitiatorPortKey.lastIndexOf("."));
        CommKeyClassId targetCommKeyClassId = new CommKeyClassId(new SnmpCommKey(localTargetKey, element.getMyFirstSnmpAgentIndex()), ClassID.SCSI_TARGET);
        element.setValue(ParameterCode.SCSI_TARGET_ID, targetCommKeyClassId);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

