/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.ConnectionStateConstant;
import java.util.HashMap;
import java.util.Iterator;

public class IScsiConnectionConfigurator
extends ElementConfigurator {
    private String NULL_CONNECTION_KEY = "0.0.0.0";
    private static SrLogger theLogger = SrLogger.getLogger();

    public IScsiConnectionConfigurator() {
        super(ClassID.ISCSI_CONNECTION, "iscsiConnectionAttributesTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.ISCSI_CONNECTION_CID, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS_TYPE, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_LOCAL_PORT, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS_TYPE, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_REMOTE_PORT, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_STATE, null);
        paramList.put(ParameterCode.ISCSI_CONNECTION_LAST_CHANGE, null);
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String elementkey = element.getSnmpKey().getKey();
        String sessionKey = elementkey.substring(0, elementkey.lastIndexOf("."));
        SnmpCommKey sessionCommKey = new SnmpCommKey(sessionKey, element.getMyFirstSnmpAgentIndex());
        CommKeyClassId sessionCommKeyClassId = new CommKeyClassId(sessionCommKey, ClassID.ISCSI_SESSION);
        element.addParameter(new Parameter(ParameterCode.ISCSI_SESSION_ID, sessionCommKeyClassId));
        SrInteger ConnectionTypeInteger = (SrInteger)element.getValue(ParameterCode.ISCSI_CONNECTION_STATE);
        if (ConnectionTypeInteger != null) {
            ConnectionStateConstant ConnectionType = ConnectionStateConstant.getConnectionTypeStat(ConnectionTypeInteger.intValue());
            element.setValue(ParameterCode.ISCSI_CONNECTION_STATE, ConnectionType);
        }
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList connectionsList = this.getAllExtended(snmpAgentIndex, null, null);
        Iterator i = connectionsList.iterator();
        while (i.hasNext()) {
            ((ConfigElementData)i.next()).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        }
        if (connectionsList.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(connectionsList, vSwitchData);
        }
    }

    private void removeInvalidConnections(ConfigElementDataList connectionsList) {
        ConfigElementDataList tmpList = new ConfigElementDataList();
        for (ElementData connectionElement : connectionsList) {
            String connectionKey = connectionElement.getSnmpKey().getKey();
            if (!connectionKey.equals(this.NULL_CONNECTION_KEY)) {
                tmpList.add(connectionElement);
                continue;
            }
            theLogger.warn(SrLogCategories.LEGACY, "NULL_CONNECTION_KEY");
        }
        connectionsList.clear();
        connectionsList.addAll(tmpList);
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList connectionsList = super.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
        this.removeInvalidConnections(connectionsList);
        return connectionsList;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

