/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrString;
import java.util.HashMap;

public class ISCSIInitiatorConfigurator
extends ElementConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public ISCSIInitiatorConfigurator() {
        super(ClassID.ISCSI_INITIATOR, "iscsiInitiatorAttributesTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.ISCSI_INITAITOR_NUM_OF_LOGIN_FAILURES, null);
        return paramList;
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 23: {
                return MibItem.ISCSI_INITIATOR_LAST_TARGET_FAILURE_NAME;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        if (trap.getTrapType().getTrapId() != 23) {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIInitiatorConfigurator: Local initiator failed to login to a remote target!");
        SrString remoteTargetName = (SrString)element.getValue(ParameterCode.ISCSI_INITAITOR_LAST_TARGET_FAILURE_NAME);
        SCSIRemoteTargetConfigurator remoteTargetConfigurator = new SCSIRemoteTargetConfigurator();
        ConfigElementDataList allRemoteTargetElements = remoteTargetConfigurator.getAllExtended(element.getSnmpAgentFromParameter(), null, null);
        ConfigElementData remoteTargetElement = this.getRemoteTargetElementByName(allRemoteTargetElements, remoteTargetName.toString());
        SrEventHandler.getEventMgr().sendChangeElementEvent(remoteTargetElement, (Object)trap);
    }

    private ConfigElementData getRemoteTargetElementByName(ConfigElementDataList remoteTargetElements, String remoteTargetName) {
        for (ElementData remoteTargetElement : remoteTargetElements) {
            SrString currentRemoteTargetName = (SrString)remoteTargetElement.getValue(ParameterCode.DISCOVERED_TARGET_NAME);
            if (!currentRemoteTargetName.toString().equals(remoteTargetName)) continue;
            return (ConfigElementData)remoteTargetElement;
        }
        return null;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

