/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import java.util.HashMap;

public class HardwareConfigurator
extends ElementConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public HardwareConfigurator() {
        super(ClassID.HARDWARE, "", null, null);
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        CommKeyClassId hardwareData = new CommKeyClassId(vSwitchData.getCommKeys(), ClassID.HARDWARE);
        ConfigElementData hardware = new ConfigElementData(hardwareData.getCommKeys(), hardwareData.getClassID());
        hardware.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        this.internalRead(hardware);
        ConfigElementDataList list = new ConfigElementDataList();
        list.add(hardware);
        this.sendDiscoveredElementsToEventMgr(list, vSwitchData);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.CPU_FACTORY_TEMP_TRESH, null);
        paramList.put(ParameterCode.CPU_TEMP, null);
        paramList.put(ParameterCode.CPU_WARNING_TEMP_TRESH, null);
        paramList.put(ParameterCode.CURR_NUM_OF_WORKING_FANS, null);
        paramList.put(ParameterCode.CURR_NUM_OF_WORKING_POWER_SUPPLIERS, null);
        paramList.put(ParameterCode.MAX_NUM_OF_FANS, null);
        paramList.put(ParameterCode.MAX_NUM_OF_POWER_SUPPLIERS, null);
        paramList.put(ParameterCode.ON_BOARD_FACTORY_TEMP_TRESH, null);
        paramList.put(ParameterCode.ON_BOARD_TEMP, null);
        paramList.put(ParameterCode.ON_BOARD_WARNING_TEMP_TRESH, null);
        return paramList;
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        theLogger.trace(SrLogCategories.LEGACY, "Changed by Trap for ", element.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendChangeElementEvent(element, (Object)trap);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

