/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.FCIfExtensionConfigurator;
import com.sanrad.nms.server.mgr.IfConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.FcPortTypeConstant;
import java.math.BigInteger;
import java.util.HashMap;

public class FCIfConfigurator
extends IfConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public FCIfConfigurator() {
        super(ClassID.FC_INTERFACE, "fcmPortTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.FC_IF_PORT_WWN, null);
        paramList.put(ParameterCode.FC_IF_PORT_ADMIN_TYPE, null);
        paramList.put(ParameterCode.FC_IF_PORT_OPER_TYPE, null);
        paramList.put(ParameterCode.FC_IF_PORT_ADMIN_SPEED, null);
        return paramList;
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList fcList = this.getAll(snmpAgentIndex, null, null);
        if (fcList.size() > 0) {
            FCIfExtensionConfigurator fcXConfig = new FCIfExtensionConfigurator();
            ConfigElementDataList fcXList = fcXConfig.getAll(snmpAgentIndex, null, null);
            fcXConfig.mergeElementLists(fcList, fcXList, true);
        }
        return fcList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        FcPortTypeConstant constType;
        SrGauge type = (SrGauge)element.getValue(ParameterCode.FC_IF_PORT_OPER_TYPE);
        if (type != null) {
            constType = FcPortTypeConstant.getType(((BigInteger)type.value()).intValue());
            element.setValue(ParameterCode.FC_IF_PORT_OPER_TYPE, constType);
        }
        if ((type = (SrGauge)element.getValue(ParameterCode.FC_IF_PORT_ADMIN_TYPE)) != null) {
            constType = FcPortTypeConstant.getType(((BigInteger)type.value()).intValue());
            element.setValue(ParameterCode.FC_IF_PORT_ADMIN_TYPE, constType);
        }
    }

    @Override
    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
        ClassID elementClassId = element.getClassId();
        SnmpCommKey elementCommKey = element.getSnmpKey();
        ConfigElementData newElement = new ConfigElementData(elementCommKey, elementClassId);
        FCIfExtensionConfigurator fcXConfig = new FCIfExtensionConfigurator();
        fcXConfig.internalRead(newElement);
        element.addParameter(newElement.getParametersList());
        if (retrievedElements != null && !retrievedElements.contains(element)) {
            retrievedElements.add(element);
        }
    }

    @Override
    public boolean readAfterChange(ConfigElementData element) throws SrCommException {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, ie);
        }
        return super.readAfterChange(element);
    }

    @Override
    public void postChangeOperation(ConfigElementData element) throws SrCommException {
        SnmpCommKey elementCommKey = element.getSnmpKey();
        ConfigElementData refreshElement = new ConfigElementData(elementCommKey, ClassID.INTERFACE);
        IfConfigurator ifConfigurator = new IfConfigurator();
        ifConfigurator.internalRead(refreshElement);
        SrEventHandler.getEventMgr().sendChangeElementEvent(refreshElement, (Object)this);
    }
}

