/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindKey;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.DBKey;
import com.sanrad.nms.server.comm.database.DBVarBind;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.exception.SrOperationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpTable;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.CodeToKeyMap;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.mgr.volume.VolumeChildrenConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.util.SrDebugLogObject;
import com.sanrad.util.Util;
import com.sanrad.util.alarm.HistoryAlarmData;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ElementConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();
    public static final String CREATE_OPERATION = "creating";
    public static final String READ_OPERATION = "refreshing";
    public static final String CHANGE_OPERATION = "changing";
    public static final String REMOVE_OPERATION = "removing";
    public static final String UNKNOWN_TABLE = "";
    public static final String SNMP_MANAGER_TABLE = "srManagersTable";
    public static final String IP_ROUTE_TABLE = "ipCidrRouteTable";
    public static final String NET_CONFIG_TABLE = "srNetworkConfigurationTable";
    public static final String ISCSI_PORTAL_ATTRIBUTES_TABLE = "iscsiPortalAttributesTable";
    public static final String ISCSI_TARGET_TABLE = "iscsiTargetAttributesTable";
    public static final String ISCSI_TARGET_TABLE_EX = "srIscsiTgtTable";
    public static final String ISCSI_TARGET_QOS_GROUP_TABLE = "srIscsiTgtQosGroupTable";
    public static final String ISCSI_TARGET_PORTAL_ATTRIBUTES_TABLE = "iscsiTgtPortalAttributesTable";
    public static final String ISCSI_INTR_PORTAL_ATTRIBUTES_TABLE = "iscsiIntrPortalAttributesTable";
    public static final String NEIGHBOURS_TABLE = "srSDNeighboursTable";
    public static final String SNMP_TARGET_ADDRESS_TABLE = "snmpTargetAddrTable";
    public static final String STORAGE_DOMAIN_TABLE = "srStorageDomainsTable";
    public static final String PHYSICAL_STORAGE_TABLE = "srPhysStorTable";
    public static final String PHYSICAL_STORAGE_COMMAND_TABLE = "srPhysStorComTable";
    public static final String PHYSICAL_DISK_TABLE = "srPhysDiskTable";
    public static final String SUB_DISK_TABLE = "srPhysDiskSplitTable";
    public static final String LU_TABLE = "srVirtLogUnTable";
    public static final String VOLUME_CHILDREN_TABLE = "srVirtVolChildrenTable";
    public static final String STRIP_VOLUME_TABLE = "srVirtVolSpecStrippedTable";
    public static final String SNAPSHOT_VOLUME_TABLE = "srVirtVolSpecSnapshotTable";
    public static final String SNAPSHOT_VOLUME_RELATION_TABLE = "srVirtVolSpecSnapRelationTable";
    public static final String VOLUMES_TABLE = "srVirtVolTable";
    public static final String MIRROR_VOLUME_TABLE = "srVirtVolSpecMirrorTable";
    public static final String VOLUME_OPERATION_TABLE = "srVirtVolOperTable";
    public static final String JOURNAL_VOLUME_TABLE = "srVirtVolSpecJournalTable";
    public static final String IDENTITY_TABLE = "ipsAuthIdentAttributesTable";
    public static final String IDENTITY_X_TABLE = "srAuthIdentExtensionTable";
    public static final String IDENTITY_NAME_TABLE = "ipsAuthIdentNameAttributesTable";
    public static final String CREDENTIALS_TABLE = "ipsAuthCredentialAttributesTable";
    public static final String IDENTITY_ADDRESS_TABLE = "ipsAuthIdentAddrAttributesTable";
    public static final String CREDENTIALS_CHAP_TABLE = "ipsAuthCredChapAttributesTable";
    public static final String CREDENTIALS_SRP_TABLE = "ipsAuthCredSrpAttributesTable";
    public static final String CREDENTIALS_CHAP_EXTENTION_TABLE = "srAuthCredChapAttributesTable";
    public static final String TARGET_AUTH_TABLE = "iscsiTgtAuthAttributesTable";
    public static final String LU_IDENTIFIER_TABLE = "srPhysStorLunIdTable";
    public static final String DISCOVERED_TARGET_TABLE = "scsiDscTgtTable";
    public static final String DISCOVERED_LU_TABLE = "scsiLuTable";
    public static final String PHYS_STOR_DISC_TARGET_LU_MAP_TABLE = "srPhysStorMapDscLunTable";
    public static final String RADIUS_SERVER_TABLE = "srRadiusAuthServerTable";
    public static final String ISNS_SERVER_TABLE = "srIsnsLocalAddrCfgTable";
    public static final String FC_NODE_TABLE = "fcmInstanceTable";
    public static final String IFX_FC_PORT_TABLE = "fcmPortTable";
    public static final String FC_EXTENTION_TABLE = "srFCTable";
    public static final String ISCSI_INSTANCES_TABLE = "iscsiInstanceAttributesTable";
    public static final String ISCSI_SESSIONS_TABLE = "iscsiSessionAttributesTable";
    public static final String ISCSI_SESSIONS_STATISTICS_TABLE = "iscsiSessionStatsTable";
    public static final String ISCSI_SESSIONS_ERROR_COUNTERS_TABLE = "iscsiSessionCxnErrorStatsTable";
    public static final String ISCSI_CONNECTION_TABLE = "iscsiConnectionAttributesTable";
    public static final String ISCSI_REMOTE_INITIATORS_TABLE = "scsiAuthorizedIntrTable";
    public static final String SCSI_TRANSPORT_TABLE = "scsiTrnsptTable";
    public static final String ASYNC_PAIR_PIT_TABLE = "srAsyncPairPiTTable";
    public static final String CONSISTENCY_GROUP_PIT_TABLE = "srDRGroupPiTTable";
    public static final String VIRT_GROUP_TABLE = "srVirtGroupTable";
    public static final String CF_ASYNC_PAIR_TABLE = "srAsyncPairSendCFTable";
    public static final String CF_SYNC_PAIR_TABLE = "srSyncPairSendCFTable";
    public static final String CF_CONSISTENCY_GROUP_TABLE = "srDRGroupSendCFTable";
    public static final String DR_PAIR_TABLE = "srPairTable";
    public static final String ASYNC_PAIR_TABLE = "srAsyncPairTable";
    public static final String SYNC_PAIR_TABLE = "srSynchPairTable";
    public static final String CONSISTENCY_GROUP_TABLE = "srDRGroupTable";
    public static final String POLICY_TABLE = "srPolicyTable";
    public static final String POLICY_PARAM_TABLE = "srPolicyParamTable";
    public static final String SCSI_TARGETS_PORTS_TABLE = "scsiTgtPortTable";
    public static final String TCP_CONN_TABLE = "tcpConnTable";
    public static final String UDP_TABLE = "udpTable";
    public static final String IF_STATISTIC_TABLE = "ifTable";
    public static final String IF_X_STATISTIC_TABLE = "ifXTable";
    public static final String TARGET_AUTH_EXTENTION_TABLE = "srIscsiTgtAccessListTable";
    public static final String ATTACHED_RAID_TABLE = "srAttachedRaidTable";
    public static final String SNAPSHOT_SCHEDULER_TABLE = "srSnapshotSchedulerTable";
    public static final String IF_TABLE = "ifTable";
    public static final String IF_EXTENTION_TABLE = "ifXTable";
    public static final String IF_SR_EXTENTION_TABLE = "srIfTable";
    public static final String IF_CONNECTED_SFP_TABLE = "srIfConnectedSFPTable";
    public static final String IFX_PSCSI_TABLE = "srPSCSITable";
    public static final String SCSI_DEVICE_TABLE = "scsiDeviceTable";
    public static final String SCSI_PORT_TABLE = "scsiPortTable";
    public static final String SCSI_INITIATOR_DEVICE_TABLE = "scsiIntrDevTable";
    public static final String SCSI_DISCOVERY_REMOTE_TARGET_TABLE = "scsiDscTgtTable";
    public static final String ISCSI_REMOTE_TARGET_PORTAL = "srRemoteTgtPortalTable";
    public static final String SCSI_DISCOVERY_LUN_TABLE = "scsiDscLunTable";
    public static final String SCSI_DISCOVERY_LUN_ID_TABLE = "scsiDscLunIdTable";
    public static final String SCSI_TARGET_DEVICE_TABLE = "scsiTgtDevTable";
    public static final String SCSI_AUTHRIZED_INITIATOR_TABLE = "scsiAuthrizedIntrTable";
    public static final String SCSI_AUTHRIZED_INITIATOR_PORT_TABLE = "scsiAttIntrPortTable";
    public static final String SCSI_INITIATOR_PORT_TABLE = "scsiIntrPortTable";
    public static final String SCSI_REMOTE_TARGET_TABLE = "srRemoteTgtTable";
    public static final String ISCSI_INITIATOR_TABLE = "iscsiInitiatorAttributesTable";
    public static final String ISCSI_REMOTE_PORTAL_DISCOVERY_TABLE = "srRemotePortalDiscoveryTable";
    protected static final int theCreationIndexErrorRetriesCount = 3;
    protected ClassID myClassId = null;
    protected String myTableName = null;
    protected MibItem myRowStatusMib = null;
    protected MibItem myLastUpdateMib = null;
    protected boolean hasLastUpdatePerEntry = false;
    private static final int MAX_RETRIES_FOR_GET_ALL = 5;

    public ElementConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        this.myClassId = classId;
        this.myTableName = tableName;
        this.myRowStatusMib = rowStatusMib;
        this.myLastUpdateMib = lastUpdateMib;
    }

    public ElementConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib, boolean hasLastUpdateForEntry) {
        this.myClassId = classId;
        this.myTableName = tableName;
        this.myRowStatusMib = rowStatusMib;
        this.myLastUpdateMib = lastUpdateMib;
        this.hasLastUpdatePerEntry = hasLastUpdateForEntry;
    }

    public ElementConfigurator() {
    }

    protected void setClassId(ClassID classId) {
        this.myClassId = classId;
    }

    protected String getMyTableName() {
        return this.myTableName;
    }

    public void internalCreate(ConfigElementData aElement) throws SrCommException {
        CommVarBindList varBindList = new CommVarBindList();
        CommKey[] commKeys = aElement.getCommKey();
        if (CommKeyUtil.isNullKeys(commKeys)) {
            throw new IllegalArgumentException("Try to create element " + aElement.getClassId() + " with no CommKey, element: " + aElement);
        }
        if (this.myRowStatusMib != null) {
            for (int i = 0; i < commKeys.length; ++i) {
                if (((CommKeyFetcher)((Object)commKeys[i])).getSnmpCommKey() == null) continue;
                varBindList = this.addRowStatusVarBind(varBindList, commKeys[i]);
                break;
            }
        }
        this.convertParamsToVarBinds(aElement, varBindList);
        this.addCommVarBindsToCreateList(varBindList, aElement);
        this.retryInternalCreate(aElement, varBindList, 3, null);
    }

    private void retryInternalCreate(ConfigElementData aElement, CommVarBindList aVarBindList, int aRetryIndex, SrCommException aOriginException) throws SrCommException {
        try {
            this.commSetList(aVarBindList, aElement.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommException primException) {
            try {
                SrCommException originException = aOriginException != null ? aOriginException : primException;
                CommKeyClassId createdId = this.checkCreateSuccess(aElement);
                if (createdId != null) {
                    aElement.setCommKeyClassId(createdId);
                    theLogger.error(SrLogCategories.INFORMATIVE, primException, new SrDebugLogObject("ERROR HANDLING, silently dropping failure, bottom line success.", aElement));
                    return;
                }
                if (aRetryIndex <= 0) {
                    theLogger.error(SrLogCategories.INFORMATIVE, primException, "ERROR HANDLING, out of retries, rethrowing original exception.", originException.getMessage());
                    throw originException;
                }
                --aRetryIndex;
                CommKeyClassId indexNext = this.recalculateNextIndex(aElement);
                CommKeyClassId indexPrev = aElement.getCommKeyClassId();
                if (indexPrev.equals(indexNext)) {
                    theLogger.error(SrLogCategories.INFORMATIVE, primException, "ERROR HANDLING, can't generate a different creation index, rethrowing original exception.", originException.getMessage());
                    throw originException;
                }
                aElement.setCommKeyClassId(indexNext);
                CommVarBindList nextIndexVarList = this.replaceRowIndex(indexNext, aElement, aVarBindList);
                this.retryInternalCreate(aElement, nextIndexVarList, aRetryIndex, aOriginException);
                theLogger.error(SrLogCategories.INFORMATIVE, primException, new SrDebugLogObject("ERROR HANDLING, silently dropping failure, success after re-generating the creation index.", aElement));
                return;
            }
            catch (SrCommException secondException) {
                theLogger.error(SrLogCategories.EXCEPTION, secondException, "ERROR HANDLING, Exception during rolback, element: " + aElement);
                throw aOriginException != null ? aOriginException : primException;
            }
        }
    }

    private CommVarBindList replaceRowIndex(CommKeyClassId aIndexNext, ConfigElementData aElement, CommVarBindList aVarBindList) {
        CommVarBindList nextVarBindList = new CommVarBindList();
        CommKey[] commKey = aIndexNext.getCommKeys();
        for (CommVarBind prevCommVarBind : aVarBindList) {
            for (int i = 0; i < commKey.length; ++i) {
                CommVarBindKey newKey;
                CommVarBindKey key = prevCommVarBind.getVarBindKey();
                SrType value = prevCommVarBind.getValue();
                CommVarBind newVarBind = null;
                if (key instanceof SrOid) {
                    newKey = new SrOid(key.getVarBindName(), commKey[i].getKey());
                    newVarBind = new SrSnmpVarBind((SrOid)newKey, value);
                } else if (key instanceof DBKey) {
                    newKey = new DBKey(key.getVarBindName(), commKey[i].getKey());
                    newVarBind = new DBVarBind((DBKey)newKey, value);
                } else {
                    if (key == null) {
                        throw new IllegalArgumentException("Null key in a CommVarBind");
                    }
                    throw new IllegalArgumentException("Unsupported type of CommVarBindKey: " + key);
                }
                nextVarBindList.add(newVarBind);
            }
        }
        return nextVarBindList;
    }

    protected CommKeyClassId checkCreateSuccess(ConfigElementData aElement) throws SrCommException {
        char agentIndex = aElement.getMyFirstSnmpAgentIndex();
        ConfigElementData fieldsToRead = new ConfigElementData(aElement.getCommKeyClassId());
        fieldsToRead.addParameter(this.getListOfParams());
        fieldsToRead.addParameter(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(agentIndex));
        ConfigElementDataList table = this.readAllRawDataFromColumns(fieldsToRead);
        for (ElementData cedObject : table) {
            ConfigElementData existsElement = (ConfigElementData)cedObject;
            if (!this.isSameElementParams(aElement, existsElement)) continue;
            return existsElement.getCommKeyClassId();
        }
        return null;
    }

    private ConfigElementDataList readRawColumnsValues(ConfigElementData fieldsData) throws SrCommException {
        char agentIndex = fieldsData.getSnmpAgentFromParameter();
        CommVarBindList varBindsToGet = new CommVarBindList();
        this.convertParamsToVarBinds(fieldsData, varBindsToGet);
        this.addCommVarBindsToReadList(varBindsToGet, fieldsData);
        CommVarBindList[] getBulkData = this.commSnmpGetBulk(varBindsToGet, agentIndex);
        ConfigElementDataList listOfElements = new ConfigElementDataList();
        for (CommVarBindList rowList : getBulkData) {
            if (rowList == null) {
                throw new IllegalArgumentException("Requested a null aRowList from agent num " + agentIndex);
            }
            ConfigElementData element = this.createInitialCED(rowList, agentIndex);
            for (CommVarBind varBind : rowList) {
                Parameter param = ElementConfigurator.convertVarBindToParam(varBind);
                if (param == null) continue;
                element.addParameter(param);
            }
            CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(agentIndex);
            element.setValue(ParameterCode.VSWITCH_ID, vSwitch);
            listOfElements.add(element);
        }
        return listOfElements;
    }

    protected final boolean isSameElementParams(ConfigElementData aNewElement, ConfigElementData aExistElement) {
        HashMap<ParameterCodes, Object> aNewElementParams = aNewElement.getParametersList();
        HashMap<ParameterCodes, Object> aExistElementParams = aExistElement.getParametersList();
        for (ParameterCodes pCode : aNewElementParams.keySet()) {
            HashSet<Object> existElementSet;
            HashSet<Object> newElementSet;
            Object newElementValue = aNewElementParams.get(pCode);
            Object existElementValue = aExistElementParams.get(pCode);
            if (!(newElementValue instanceof Object[] && existElementValue instanceof Object[] ? !(newElementSet = new HashSet<Object>(Arrays.asList((Object[])newElementValue))).equals(existElementSet = new HashSet<Object>(Arrays.asList((Object[])existElementValue))) : !Util.equalsWithNull(newElementValue, existElementValue))) continue;
            return false;
        }
        return true;
    }

    protected CommVarBindList addRowStatusVarBind(CommVarBindList varBindList, CommKey commKey) {
        SrSnmpVarBind srVarBind = this.createRowStatusVarBind(commKey);
        varBindList.add(srVarBind);
        return varBindList;
    }

    protected SrSnmpVarBind createRowStatusVarBind(CommKey commKey) {
        SrOid oid = new SrOid(this.myRowStatusMib.toString(), commKey.getKey());
        SrSnmpVarBind srVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_CREATE_AND_GO);
        return srVarBind;
    }

    public void internalChange(ConfigElementData aElement) throws SrCommException {
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(aElement, varBindList);
        this.addCommVarBindsToChangeList(varBindList, aElement);
        try {
            this.commSetList(varBindList, aElement.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommException e) {
            if (this.checkChangeSuccess(aElement)) {
                theLogger.error(SrLogCategories.INFORMATIVE, e, new SrDebugLogObject("ERROR HANDLING, silently dropping failure, bottom line success.", aElement));
            }
            throw e;
        }
    }

    protected boolean checkChangeSuccess(ConfigElementData aElement) throws SrCommException {
        ConfigElementData cloned = (ConfigElementData)aElement.clone();
        this.read(cloned, true);
        return this.isSameElementParams(aElement, cloned);
    }

    public CommVarBindList getVarBindsForChangeOperation(ConfigElementData element) {
        return null;
    }

    public CommVarBindList getVarBindsForRemoveOperation(ConfigElementData element) {
        CommVarBindList varBindList = new CommVarBindList();
        if (this.myRowStatusMib != null) {
            SnmpCommKey mySnmpKey = element.getSnmpKey();
            SrOid oid = new SrOid(this.myRowStatusMib.toString(), mySnmpKey.getKey());
            SrSnmpVarBind rsVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_DESTROY);
            varBindList.add(rsVarBind);
        }
        this.addCommVarBindsToRemoveList(varBindList, element);
        return varBindList;
    }

    public CommVarBindList getVarBindsForCreateOperation(ConfigElementData element) throws SrCommException {
        CommVarBindList vbList = new CommVarBindList();
        CommKey[] commKeys = element.getCommKey();
        if (this.myRowStatusMib != null) {
            for (int i = 0; i < commKeys.length; ++i) {
                if (((CommKeyFetcher)((Object)commKeys[i])).getSnmpCommKey() == null) continue;
                vbList.add(this.createRowStatusVarBind(commKeys[i]));
                break;
            }
        }
        this.convertParamsToVarBinds(element, vbList);
        this.addCommVarBindsToCreateList(vbList, element);
        return vbList;
    }

    public void postRemoveOperation(ConfigElementData element) throws SrCommException {
    }

    public void postCreateOperation(ConfigElementData element) throws SrCommException {
    }

    public void postChangeOperation(ConfigElementData element) throws SrCommException {
    }

    public void internalReadFields(ConfigElementData element) throws SrCommException {
        this.read(element);
    }

    protected boolean isFilteredElementForCheckList(CommKeyClassId elementData) {
        return false;
    }

    public void internalRead(ConfigElementData element) throws SrCommException {
        this.internalRead(element, null);
    }

    public void internalRead(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
        element.addParameter(this.getListOfParams());
        this.read(element);
        this.internalReadExtentionTable(element, retrievedElements);
    }

    private void read(ConfigElementData element, boolean aIsRawMibValues) throws SrCommException {
        CommVarBindList list = new CommVarBindList();
        this.convertParamsToVarBinds(element, list);
        this.addCommVarBindsToReadList(list, element);
        char agentIndex = element.containsParameter(ParameterCode.VSWITCH_ID) ? element.getSnmpAgentFromParameter() : element.getMyFirstSnmpAgentIndex();
        this.commGetList(list, agentIndex);
        for (int i = list.size() - 1; i >= 0; --i) {
            Parameter param = ElementConfigurator.convertVarBindToParam((CommVarBind)list.get(i));
            if (param == null) continue;
            element.addParameter(param);
            list.remove(i);
        }
        CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(agentIndex);
        element.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        if (!aIsRawMibValues) {
            this.readDiscoverPostOperation(element, list);
        }
    }

    public void read(ConfigElementData element) throws SrCommException {
        this.read(element, false);
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
    }

    protected SrType[] readTableCells(String index, char agentIndex, MibItem ... columns) throws SrCommException {
        CommVarBindList vbList = new CommVarBindList();
        for (int i = 0; i < columns.length; ++i) {
            SrOid oid = new SrOid(columns[i].toString(), index);
            vbList.add(new SrSnmpVarBind(oid, null));
        }
        this.commGetList(vbList, agentIndex);
        SrType[] values = new SrType[columns.length];
        int i = values.length;
        while (i-- > 0) {
            values[i] = ((SrSnmpVarBind)vbList.elementAt(i)).getValue();
        }
        return values;
    }

    public ConfigElementDataList internalReadForSuperPrefix(char snmpAgentIndex, ConfigElementData sourcePrefixElement, ConfigElementData internalReadElement) throws SrCommException {
        return this.getAllByPrefix(snmpAgentIndex, sourcePrefixElement.getSnmpKey().toString());
    }

    public ConfigElementDataList getAllByPrefix(char snmpAgentIndex, String keyPrefix) throws SrCommException {
        ConfigElementData tableColumnsToRead = new ConfigElementData(this.myClassId);
        tableColumnsToRead.addParameter(this.getListOfParams());
        return this.getAllByPrefix(tableColumnsToRead, snmpAgentIndex, keyPrefix);
    }

    public ConfigElementDataList getAllByPrefix(ConfigElementData tableColumns, char snmpAgentIndex, String keyPrefix) throws SrCommException {
        CommVarBindList list = new CommVarBindList();
        this.convertParamsToVarBinds(tableColumns, list);
        CommVarBindList[] varBindLists = this.commGetListsByKeyPrefix(list, keyPrefix, snmpAgentIndex);
        ConfigElementDataList elementDataList = null;
        if (varBindLists != null) {
            elementDataList = this.convertDataToElements(varBindLists, snmpAgentIndex);
            for (ElementData data : elementDataList) {
                this.readDiscoverPostOperation((ConfigElementData)data, list);
            }
        } else {
            elementDataList = new ConfigElementDataList();
        }
        return elementDataList;
    }

    public ConfigElementDataList internalReadExtendedForSuperPrefix(char snmpAgentIndex, ConfigElementData sourcePrefixElement, ConfigElementData internalReadElement) throws SrCommException {
        ConfigElementDataList elementDataList = this.internalReadForSuperPrefix(snmpAgentIndex, sourcePrefixElement, internalReadElement);
        ConfigElementDataList retrievedElements = new ConfigElementDataList();
        for (ElementData currElement : elementDataList) {
            ElementConfigurator elementConfig = DataMgrAOImpl.getElementConfigFromClassID(currElement.getClassId());
            elementConfig.internalReadExtentionTable((ConfigElementData)currElement, retrievedElements);
        }
        elementDataList.addAll(retrievedElements);
        return elementDataList;
    }

    public void internalRemove(ConfigElementData aElement) throws SrCommException {
        CommVarBindList varBindList = new CommVarBindList();
        if (this.myRowStatusMib != null) {
            SnmpCommKey mySnmpKey = aElement.getSnmpKey();
            SrOid oid = new SrOid(this.myRowStatusMib.toString(), mySnmpKey.getKey());
            SrSnmpVarBind rsVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_DESTROY);
            varBindList.add(rsVarBind);
        }
        this.addCommVarBindsToRemoveList(varBindList, aElement);
        try {
            this.commSetList(varBindList, aElement.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommException e) {
            if (this.checkRemoveSuccess(aElement)) {
                theLogger.error(SrLogCategories.INFORMATIVE, e, new SrDebugLogObject("ERROR HANDLING, silently dropping failure, bottom line success.", aElement));
            }
            throw e;
        }
    }

    protected boolean checkRemoveSuccess(ConfigElementData aElement) throws SrCommException {
        char agentIndex = aElement.getMyFirstSnmpAgentIndex();
        ConfigElementDataList table = this.getAll(agentIndex, null, null);
        for (ElementData existsElement : table) {
            if (!existsElement.getCommKeyClassId().equals(aElement.getCommKeyClassId())) continue;
            return false;
        }
        return true;
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        this.internalRead(element);
        return false;
    }

    public boolean readAfterChange(ConfigElementData element) throws SrCommException {
        this.internalRead(element);
        return false;
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList elementsList = this.getAllExtended(snmpAgentIndex, null, null);
        this.sendDiscoveredElementsToEventMgr(elementsList, vSwitchData);
    }

    public void discover(CommKeyClassId vSwitchData, ClassID classId) throws SrCommException {
        CommKeyClassId elementData = new CommKeyClassId(vSwitchData.getCommKeys(), classId);
        ConfigElementData element = new ConfigElementData(elementData.getCommKeys(), elementData.getClassID());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        this.internalRead(element);
        ConfigElementDataList list = new ConfigElementDataList();
        list.add(element);
        this.sendDiscoveredElementsToEventMgr(list, vSwitchData);
    }

    public void refreshElement(ConfigElementData element, ConfigElementDataList retrievedElementsList) throws SrCommException {
        this.internalRead(element, retrievedElementsList);
    }

    public ConfigElementDataList readTableColumns(char agentIndex, ConfigElementData fieldsData, MibItem rowStatusMibItem, MibItem lastUpdateMibItem, SrTimeTicks lastUpdateValue, CheckListConfigElementData checkListElement) throws SrCommException {
        SrTimeTicks prevLastUpdate = lastUpdateValue;
        if (prevLastUpdate == null && lastUpdateMibItem != null) {
            prevLastUpdate = (SrTimeTicks)this.getScalarFromComm(lastUpdateMibItem, agentIndex);
        }
        CommVarBindList varBindsColumns = new CommVarBindList();
        this.convertParamsToVarBinds(fieldsData, varBindsColumns);
        if (rowStatusMibItem != null) {
            varBindsColumns.add(new SrSnmpVarBind(rowStatusMibItem.toString()));
        }
        CommVarBindList[] allData = this.commSnmpGetBulk(varBindsColumns, agentIndex);
        if (lastUpdateMibItem != null) {
            SrTimeTicks currLastUpdate = (SrTimeTicks)this.getScalarFromComm(lastUpdateMibItem, agentIndex);
            int retryCount = 0;
            while (retryCount < 5 && prevLastUpdate != null && currLastUpdate != null && !prevLastUpdate.equals(currLastUpdate)) {
                ++retryCount;
                prevLastUpdate = currLastUpdate;
                varBindsColumns = new CommVarBindList();
                this.convertParamsToVarBinds(fieldsData, varBindsColumns);
                if (rowStatusMibItem != null) {
                    varBindsColumns.add(new SrSnmpVarBind(rowStatusMibItem.toString()));
                }
                allData = this.commSnmpGetBulk(varBindsColumns, agentIndex);
                currLastUpdate = (SrTimeTicks)this.getScalarFromComm(lastUpdateMibItem, agentIndex);
            }
        }
        if (rowStatusMibItem != null) {
            allData = this.ignoreRowsWithRowStatus(agentIndex, allData, rowStatusMibItem, RowStatusConstants.ROW_STATUS_DESTROY);
            allData = this.ignoreRowsWithRowStatus(agentIndex, allData, rowStatusMibItem, RowStatusConstants.ROW_STATUS_NOT_READY);
        }
        ConfigElementDataList tableOfElements = new ConfigElementDataList();
        for (int i = 0; i < allData.length; ++i) {
            ConfigElementData elementData = this.createConfigElementFromTableRow(allData[i], agentIndex);
            tableOfElements.add(elementData);
        }
        if (checkListElement != null) {
            this.buildCheckListElement(tableOfElements, checkListElement, agentIndex, prevLastUpdate);
        }
        return tableOfElements;
    }

    public ConfigElementDataList getAll(char agentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        return this.getAll(this.myTableName, agentIndex, lastUpdate, checkListElement);
    }

    public ConfigElementDataList getAll(String tableName, char agentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        SrTimeTicks lastUpdateVal = lastUpdate;
        if (lastUpdateVal == null && this.myLastUpdateMib != null) {
            lastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
        }
        CommVarBindList[] table = this.commGetAll(tableName, agentIndex);
        int maxRetries = 0;
        if (this.myLastUpdateMib != null) {
            SrTimeTicks newLastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
            while (lastUpdateVal != null && newLastUpdateVal != null && !lastUpdateVal.equals(newLastUpdateVal) && maxRetries++ < 5) {
                lastUpdateVal = newLastUpdateVal;
                table = this.commGetAll(tableName, agentIndex);
                newLastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
            }
        }
        table = this.ignoreDestroyedRows(agentIndex, table);
        table = this.ignoreNotReadyRows(agentIndex, table);
        ConfigElementDataList tableOfElements = new ConfigElementDataList();
        if (table != null) {
            int numOfRows = table.length;
            for (int i = 0; i < numOfRows; ++i) {
                ConfigElementData element = this.createConfigElementFromTableRow(table[i], agentIndex);
                if (!this.hasLastUpdatePerEntry && lastUpdateVal != null) {
                    element.setValue(ParameterCode.LAST_UPDATE, lastUpdateVal);
                }
                tableOfElements.add(element);
            }
            if (checkListElement != null) {
                this.buildCheckListElement(tableOfElements, checkListElement, agentIndex, lastUpdateVal);
            }
        }
        return tableOfElements;
    }

    protected final void buildCheckListElement(ConfigElementDataList listOfElements, CheckListConfigElementData checkListElement, char agentIndex, SrTimeTicks lastUpdateVal) {
        ArrayList<CommKeyClassId> commKeysToCheckList = new ArrayList<CommKeyClassId>();
        for (ConfigElementData element : listOfElements) {
            CommKeyClassId commKeyClassIdToCheck = element.getCommKeyClassId();
            if (this.isFilteredElementForCheckList(commKeyClassIdToCheck)) continue;
            commKeysToCheckList.add(commKeyClassIdToCheck);
        }
        checkListElement.setCheckList(commKeysToCheckList);
        checkListElement.setValue(ParameterCode.LAST_UPDATE, lastUpdateVal);
        checkListElement.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(agentIndex));
        if (checkListElement.getClassId() == null) {
            checkListElement.setClassId(this.myClassId);
        }
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        return this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
    }

    public ConfigElementDataList refreshTable(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        return this.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
    }

    public ConfigElementData getTableRow(SrSnmpTable table, CommKey rowIndex, CommKeyClassId vSwitchData) throws SrCommException {
        CommVarBindList row = this.commGetTableRow(table, rowIndex);
        ConfigElementData element = null;
        if (row == null) {
            element = this.createInitialCED(rowIndex);
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        } else {
            element = this.createConfigElementFromTableRow(row, table.getAgentIndex());
        }
        return element;
    }

    public HashMap<ParameterCodes, Object> getListOfParams() {
        return new HashMap<ParameterCodes, Object>();
    }

    protected ConfigElementData createDbCedFromVarbindList(CommVarBindList rowList) throws SrCommException {
        String key = ((CommVarBind)rowList.elementAt(0)).getIndexForCommKey();
        DataBaseCommKey commKey = new DataBaseCommKey(key);
        ConfigElementData element = new ConfigElementData(commKey, this.myClassId);
        for (int i = rowList.size() - 1; i >= 0; --i) {
            CommVarBind varBind = (CommVarBind)rowList.get(i);
            Parameter param = ElementConfigurator.convertVarBindToParam(varBind);
            if (param == null) continue;
            element.addParameter(param);
            rowList.remove(i);
        }
        this.readDiscoverPostOperation(element, rowList);
        return element;
    }

    protected ConfigElementData createInitialCED(CommVarBindList aRowList, char aAgentIndex) {
        String key = ((CommVarBind)aRowList.elementAt(0)).getIndexForCommKey();
        SnmpCommKey commKey = new SnmpCommKey(key, aAgentIndex);
        return this.createInitialCED(commKey);
    }

    protected final ConfigElementData createInitialCED(CommKey aCommKey) {
        return new ConfigElementData(aCommKey, this.myClassId);
    }

    protected ConfigElementData createConfigElementFromTableRow(CommVarBindList aRowList, char aAgentIndex) throws SrCommException {
        if (aRowList == null) {
            throw new IllegalArgumentException("Requested a null aRowList from agent num " + aAgentIndex);
        }
        ConfigElementData element = this.createInitialCED(aRowList, aAgentIndex);
        Iterator rowItr = aRowList.iterator();
        while (rowItr.hasNext()) {
            CommVarBind varBind = (CommVarBind)rowItr.next();
            Parameter param = ElementConfigurator.convertVarBindToParam(varBind);
            if (param == null) continue;
            element.addParameter(param);
            rowItr.remove();
        }
        CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(aAgentIndex);
        element.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        aRowList.setSnmpAgentIndex(aAgentIndex);
        this.readDiscoverPostOperation(element, aRowList);
        return element;
    }

    protected ConfigElementData createConfigElementFromOneVarBind(CommVarBind vb, char agentIndex) throws SrCommException {
        CommVarBindList vbList = new CommVarBindList();
        vbList.add(vb);
        vbList.setSnmpAgentIndex(agentIndex);
        ConfigElementData element = this.createConfigElementFromTableRow(vbList, agentIndex);
        return element;
    }

    protected CommVarBindList createCommVarBinds(CommKey[] commKey, Parameter param) {
        CommVarBindList varBindList = new CommVarBindList();
        CommVarBindKey[] varBindKeys = CodeToKeyMap.getInstance().getKeyByParamCode(param.getCode());
        if (varBindKeys == null) {
            return null;
        }
        if (commKey == null) {
            CommVarBind varBind;
            int j;
            for (j = 0; j < varBindKeys.length; ++j) {
                if (!(varBindKeys[j] instanceof SrOid)) continue;
                String oidName = ((SrOid)varBindKeys[j]).getVarBindName();
                SrOid srOid = new SrOid(oidName);
                varBind = new SrSnmpVarBind(srOid, (SrType)param.getValue());
                varBindList.add(varBind);
            }
            for (j = 0; j < varBindKeys.length; ++j) {
                if (!(varBindKeys[j] instanceof DBKey)) continue;
                String keyName = ((DBKey)varBindKeys[j]).getVarBindName();
                DBKey dbKey = new DBKey(keyName);
                varBind = new DBVarBind(dbKey, (SrType)param.getValue());
                varBindList.add(varBind);
            }
            return varBindList;
        }
        for (int i = 0; i < commKey.length; ++i) {
            CommVarBind varBind;
            int j;
            if (((CommKeyFetcher)((Object)commKey[i])).getSnmpCommKey() != null) {
                for (j = 0; j < varBindKeys.length; ++j) {
                    if (!(varBindKeys[j] instanceof SrOid)) continue;
                    String oidName = ((SrOid)varBindKeys[j]).getVarBindName();
                    SrOid srOid = new SrOid(oidName, commKey[i].getKey());
                    varBind = new SrSnmpVarBind(srOid, (SrType)param.getValue());
                    varBindList.add(varBind);
                }
                continue;
            }
            if (((CommKeyFetcher)((Object)commKey[i])).getDBCommKey() == null) continue;
            for (j = 0; j < varBindKeys.length; ++j) {
                if (!(varBindKeys[j] instanceof DBKey)) continue;
                String keyName = ((DBKey)varBindKeys[j]).getVarBindName();
                DBKey dbKey = new DBKey(keyName, commKey[i].getKey());
                varBind = new DBVarBind(dbKey, (SrType)param.getValue());
                varBindList.add(varBind);
            }
        }
        return varBindList;
    }

    protected static final Parameter convertVarBindToParam(CommVarBind varBind) {
        CommVarBindKey varBindKey = varBind.getVarBindKey();
        ParameterCode code = varBindKey.getParameterCode();
        if (code != null) {
            SrType value = varBind.getValue();
            if (ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY.equals(code) && value != null) {
                value = new SrBoolean(((SrInteger)value).intValue() == 1);
            }
            return new Parameter(code, value);
        }
        return null;
    }

    protected void convertParamsToVarBinds(ConfigElementData element, CommVarBindList list) {
        CommKey[] commKeys = element.getCommKey();
        for (ParameterCode parameterCode : element.keySet()) {
            Object tmpObj = element.getValue(parameterCode);
            if (tmpObj != null && !(tmpObj instanceof SrType)) continue;
            SrType value = (SrType)tmpObj;
            Parameter tmpParam = new Parameter(parameterCode, value);
            list.add(this.createCommVarBinds(commKeys, tmpParam));
        }
    }

    protected void mergeElementLists(ConfigElementDataList mainList, ConfigElementDataList secondList, boolean setClassId) {
        this.mergeElementLists(mainList, secondList, setClassId, false);
    }

    protected void mergeElementLists(ConfigElementDataList mainList, ConfigElementDataList secondList, boolean setClassId, boolean aIsDontAddMissing) {
        try {
            for (ElementData secondaryED : secondList) {
                ConfigElementData secondElem = (ConfigElementData)secondaryED;
                CommKey[] secondElemKey = secondElem.getCommKey();
                ElementData matchingMainElem = null;
                for (ElementData mainED : mainList) {
                    ConfigElementData currentMainElem = (ConfigElementData)mainED;
                    CommKey[] mainElemKey = currentMainElem.getCommKey();
                    if (!CommKey.compare(secondElemKey, mainElemKey)) continue;
                    matchingMainElem = currentMainElem;
                    break;
                }
                ElementData tmp = null;
                if (matchingMainElem == null) {
                    if (aIsDontAddMissing) continue;
                    theLogger.logAndAssert(SrLogCategories.ERROR, "Extension entry without a main table entry. Ext: " + secondElem + "; mainList: " + mainList);
                    tmp = new ConfigElementData(secondElem);
                    mainList.add(tmp);
                } else {
                    matchingMainElem.addParameter(secondElem.getParametersList());
                    tmp = matchingMainElem;
                }
                if (!setClassId) continue;
                tmp.setClassId(this.myClassId);
            }
        }
        catch (RuntimeException e) {
            String msg = "Merge Failed at: " + CommKeyUtil.getKeyForMessage(((ConfigElementData)mainList.get(0)).getCommKey());
            theLogger.error(SrLogCategories.EXCEPTION, msg, e.getMessage());
            throw e;
        }
    }

    protected void sendDiscoveredElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (ElementData data : list) {
            if (vSwitchData != null) {
                ((ConfigElementData)data).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            theLogger.trace(SrLogCategories.LEGACY, "Discover: ", data.getClassId(), " CommKey is:", CommKeyUtil.getKeyForMessage(data.getCommKey()));
        }
        SrEventHandler.getEventMgr().sendAddElementEvent(list, (Object)this);
    }

    protected void sendRefreshedElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (ElementData data : list) {
            if (vSwitchData != null) {
                ((ConfigElementData)data).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            theLogger.trace(SrLogCategories.LEGACY, "Refresh: ", data.getClassId(), " CommKey is:", CommKeyUtil.getKeyForMessage(data.getCommKey()));
        }
        SrEventHandler.getEventMgr().sendRefreshElementEvent(list, (Object)this);
    }

    protected void addCommVarBindsToCreateList(CommVarBindList list, ConfigElementData element) {
    }

    protected void addCommVarBindsToRemoveList(CommVarBindList list, ConfigElementData element) {
    }

    protected void addCommVarBindsToChangeList(CommVarBindList list, ConfigElementData element) {
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
    }

    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        if (this.myLastUpdateMib != null && !this.hasLastUpdatePerEntry) {
            SrOid oid = new SrOid(this.myLastUpdateMib.toString(), "0");
            SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
            list.add(varBind);
        }
    }

    protected void splitParameterListOfDifferentElement(ConfigElementData mainList, HashMap paramsToSplit) {
        Iterator paramsToSplitItr = paramsToSplit.keySet().iterator();
        while (paramsToSplitItr.hasNext()) {
            ParameterCode splitCode = (ParameterCode)paramsToSplitItr.next();
            if (mainList.containsParameter(splitCode)) {
                paramsToSplit.put(splitCode, mainList.removeParameter(splitCode));
                continue;
            }
            paramsToSplitItr.remove();
        }
    }

    public static SrType getVarBindValueFromList(CommVarBindList list, CommItem item) {
        for (int i = list.size() - 1; i >= 0; --i) {
            CommVarBind varBind = (CommVarBind)list.get(i);
            CommVarBindKey vbKey = varBind.getVarBindKey();
            String strKey = ((SrOid)vbKey).getOid();
            if (!strKey.equals(item.toString())) continue;
            list.remove(i);
            return varBind.getValue();
        }
        return null;
    }

    protected CommVarBindKey getVarBindFromList(CommVarBindList list, CommItem item) {
        if (item != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                CommVarBind varBind = (CommVarBind)list.get(i);
                CommVarBindKey vbKey = varBind.getVarBindKey();
                String strKey = ((SrOid)vbKey).getOid();
                if (!strKey.equals(item.toString())) continue;
                return varBind.getVarBindKey();
            }
        }
        return null;
    }

    public void handleTrap(SrTrap trap) throws SrCommException {
        Object commKey;
        ConfigElementData element = new ConfigElementData(this.myClassId);
        SrSnmpVarBindList vbList = trap.getVarBindList();
        char agentIndex = trap.getSourceIndex();
        String key = null;
        if (!this.myClassId.equals(ClassID.VSWITCH) && !this.myClassId.equals(ClassID.HARDWARE)) {
            CommItem trapCommKey = this.getCommItemForTrapCommKey(trap);
            if (trapCommKey == null) {
                return;
            }
            CommVarBindKey varBindKey = this.getVarBindFromList(vbList, trapCommKey);
            if (varBindKey == null) {
                theLogger.warn(SrLogCategories.LEGACY, "CommVarBindKey of trap ", trap, " (", trapCommKey, ") is null");
            } else {
                key = varBindKey.getIndex();
            }
        }
        if (this.myClassId.equals(ClassID.HARDWARE)) {
            commKey = CommKeyUtil.getVSwitchData(agentIndex).getCommKeys();
            element.setCommKeys((CommKey[])commKey);
        } else {
            commKey = new SnmpCommKey(key, agentIndex);
            element.setCommKey((CommKey)commKey);
        }
        Iterator itr = vbList.iterator();
        while (itr.hasNext()) {
            CommVarBind varBind = (CommVarBind)itr.next();
            Parameter parameter = ElementConfigurator.convertVarBindToParam(varBind);
            if (parameter == null) continue;
            element.addParameter(parameter);
            itr.remove();
        }
        CommKeyClassId vSwitchData = CommKeyUtil.getVSwitchData(agentIndex);
        if (vSwitchData != null) {
            element.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
            this.trapProccessingPostOperation(element, trap);
        }
    }

    protected void proccessTrapParameters(SrTrap trap, ConfigElementData element) {
        throw new UnsupportedOperationException();
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        theLogger.warn(SrLogCategories.LEGACY, "Unssuported trap: ", trap);
        return null;
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
    }

    protected void unknownElementTrapOperation(ConfigElementData element, SrTrap trap) {
    }

    public void readOneRowFromTable(ConfigElementData element) throws SrCommException {
        String[] tableList = new String[]{this.myTableName};
        CommVarBindList rowData = this.commGetOneRow(tableList, element.getSnmpKey(), element.getMyFirstSnmpAgentIndex());
        for (int i = rowData.size() - 1; i >= 0; --i) {
            Parameter param = ElementConfigurator.convertVarBindToParam((CommVarBind)rowData.get(i));
            if (param == null) continue;
            element.addParameter(param);
            rowData.remove(i);
        }
        this.readDiscoverPostOperation(element, rowData);
    }

    public ConfigElementDataList getElementsByFilter(ConfigElementData element, SrSnmpTable table) throws SrCommException {
        CommVarBindList list = new CommVarBindList();
        this.convertParamsToVarBinds(element, list);
        return this.getElementsByFilter(list, table);
    }

    public ConfigElementDataList getElementsByFilter(CommVarBindList vbList, SrSnmpTable table) throws SrCommException {
        CommVarBindList[] rows = CommMgr.getInstance(table.getAgentIndex()).filterTableRowsByValue(table, (CommVarBind)vbList.get(0));
        ConfigElementDataList elements = new ConfigElementDataList();
        for (int i = 0; i < rows.length; ++i) {
            elements.add(this.createConfigElementFromTableRow(rows[i], table.getAgentIndex()));
        }
        return elements;
    }

    public ConfigElementDataList readTableRowsByValue(String table, MibItem column, SrType value, char agentIndex) throws SrCommException {
        CommVarBindList[] rows = this.commGetTableRowsByValue(table, column.toString(), value, agentIndex);
        ConfigElementDataList elements = new ConfigElementDataList();
        for (int i = 0; i < rows.length; ++i) {
            elements.add(this.createConfigElementFromTableRow(rows[i], agentIndex));
        }
        return elements;
    }

    public ConfigElementDataList refreshTableFields(ConfigElementData fieldsData) throws SrCommException {
        char agentIndex = fieldsData.getSnmpAgentFromParameter();
        CommVarBindList varBindsToGet = new CommVarBindList();
        this.convertParamsToVarBinds(fieldsData, varBindsToGet);
        this.addCommVarBindsToReadList(varBindsToGet, fieldsData);
        CommVarBindList[] allData = this.commSnmpGetTable(varBindsToGet, agentIndex);
        ConfigElementDataList tableOfElements = this.convertDataToElements(allData, agentIndex);
        return tableOfElements;
    }

    protected ConfigElementDataList convertDataToElements(CommVarBindList[] data, char agentIndex) throws SrCommException {
        ConfigElementDataList tableOfElements = new ConfigElementDataList();
        int numOfRows = data.length;
        for (int i = 0; i < numOfRows; ++i) {
            ConfigElementData element = this.createConfigElementFromTableRow(data[i], agentIndex);
            tableOfElements.add(element);
        }
        return tableOfElements;
    }

    @Deprecated
    public ConfigElementDataList readTableColumns(ConfigElementData fieldsData) throws SrCommException {
        char agentIndex = fieldsData.getSnmpAgentFromParameter();
        CommVarBindList varBindsToGet = new CommVarBindList();
        this.convertParamsToVarBinds(fieldsData, varBindsToGet);
        this.addCommVarBindsToReadList(varBindsToGet, fieldsData);
        CommVarBindList[] getBulkData = this.commSnmpGetBulk(varBindsToGet, agentIndex);
        ConfigElementDataList listOfElements = new ConfigElementDataList();
        int numOfRows = getBulkData.length;
        for (int i = 0; i < numOfRows; ++i) {
            ConfigElementData element = this.createConfigElementFromTableRow(getBulkData[i], agentIndex);
            listOfElements.add(element);
        }
        return listOfElements;
    }

    public ConfigElementDataList readAllRawDataFromColumns(ConfigElementData fieldsData) throws SrCommException {
        char agentIndex = fieldsData.getSnmpAgentFromParameter();
        CommVarBindList varBindsToGet = new CommVarBindList();
        this.convertParamsToVarBinds(fieldsData, varBindsToGet);
        HashMap<String, ConfigElementData> resultMap = new HashMap<String, ConfigElementData>();
        for (CommVarBind varBind : varBindsToGet) {
            CommVarBindList[] columnVarBindsResponse;
            CommVarBindList columnVarBindRequest = new CommVarBindList();
            columnVarBindRequest.add(varBind);
            for (CommVarBindList row : columnVarBindsResponse = this.commSnmpGetBulk(columnVarBindRequest, agentIndex)) {
                Parameter param;
                CommVarBind resultVarBind = (CommVarBind)row.get(0);
                String keyInMap = resultVarBind.getVarBindKey().getIndex();
                ConfigElementData rowCed = (ConfigElementData)resultMap.get(keyInMap);
                if (rowCed == null) {
                    rowCed = this.createInitialCED(row, agentIndex);
                    rowCed.addParameterToElement(fieldsData, ParameterCode.VSWITCH_ID);
                    resultMap.put(keyInMap, rowCed);
                }
                if ((param = ElementConfigurator.convertVarBindToParam(resultVarBind)) == null) continue;
                rowCed.addParameter(param);
            }
        }
        return new ConfigElementDataList(resultMap.values());
    }

    public ConfigElementDataList readAllDataFromColumns(ConfigElementData fieldsData) throws SrCommException {
        ConfigElementDataList list = this.readAllRawDataFromColumns(fieldsData);
        for (ElementData ced : list) {
            this.readDiscoverPostOperation((ConfigElementData)ced, new CommVarBindList());
        }
        return list;
    }

    public CommVarBindList[] readTableColumn(char agentIndex, MibItem mibItem) throws SrCommException {
        CommVarBindList varBindsToGet = new CommVarBindList();
        SrOid oid = new SrOid(mibItem.toString(), "0");
        SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
        varBindsToGet.add(varBind);
        CommVarBindList[] getBulkData = this.commSnmpGetBulk(varBindsToGet, agentIndex);
        return getBulkData;
    }

    public void postSendCreateEvent(ConfigElementData myElement) throws SrCommException {
    }

    public void postSendRemoveEvent(ConfigElementData myElement) throws SrCommException {
    }

    protected void readVolumePosition(CommKeyClassId[] childrenCommKeys, CommKeyClassId parentData) throws SrCommException {
        CommVarBindList positions = new CommVarBindList();
        SnmpCommKey parentCommKey = CommKeyUtil.getSnmpCommKey(parentData);
        String parentIndex = parentCommKey.getKey();
        char agentIndex = parentCommKey.getSnmpAgentIndex();
        for (int i = 0; i < childrenCommKeys.length; ++i) {
            String childKey = UNKNOWN_TABLE;
            childKey = childrenCommKeys[i].getClassID().isVolume() ? CommKeyUtil.getSpecificSnmpKey(childrenCommKeys[i], agentIndex).getKey() : SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, childrenCommKeys[i]);
            String childIndex = childKey.substring(childKey.indexOf(".") + 1);
            SrOid oid = new SrOid(MibItem.VIRTUAL_VOLUME_CHILDREN_POSITION.toString(), parentIndex + "." + childIndex);
            SrSnmpVarBind vb = new SrSnmpVarBind(oid, null);
            positions.add(vb);
        }
        this.commGetList(positions, agentIndex);
        VolumeChildrenConfigurator childrenConfig = new VolumeChildrenConfigurator();
        ConfigElementDataList listOfElements = new ConfigElementDataList();
        for (int i = 0; i < positions.size(); ++i) {
            ConfigElementData element = childrenConfig.createConfigElementFromOneVarBind((CommVarBind)positions.elementAt(i), agentIndex);
            element.setClassId(childrenCommKeys[i].getClassID());
            element.setCommKeys(childrenCommKeys[i].getCommKeys());
            if (element == null) continue;
            listOfElements.add(element);
        }
        SrEventHandler.getEventMgr().sendChangeElementEvent(listOfElements, (Object)this);
    }

    protected SrDateAndTime getDate(SrDateAndTime lastReset, SrTimeTicks timeStamp) {
        if (lastReset != null && timeStamp != null) {
            Long lastResetLong = (Long)lastReset.value();
            long eventTime = lastResetLong + timeStamp.longValue() * 500L / 30L;
            SrDateAndTime dateOfEvent = new SrDateAndTime(new Long(eventTime));
            return dateOfEvent;
        }
        return null;
    }

    protected SrDateAndTime getDate(char agentIndex, SrTimeTicks timeStamp) throws SrCommException {
        SrDateAndTime lastReset = this.getLastReset(agentIndex);
        return this.getDate(lastReset, timeStamp);
    }

    protected SrDateAndTime getLastReset(SrDateAndTime currentTime, SrTimeTicks sysUpTime) {
        if (sysUpTime != null && currentTime != null) {
            Long currentDate = (Long)currentTime.value();
            long lastReset = currentDate - sysUpTime.longValue() * 10L;
            SrDateAndTime dateOfLastReset = new SrDateAndTime(new Long(lastReset));
            return dateOfLastReset;
        }
        return null;
    }

    protected SrDateAndTime getLastReset(char agentIndex) throws SrCommException {
        SnmpCommKey vSwitchKey = new SnmpCommKey("0", agentIndex);
        ConfigElementData vSwitch = new ConfigElementData(vSwitchKey, ClassID.VSWITCH);
        vSwitch.addParameter(new Parameter(ParameterCode.VSWITCH_LAST_RESET));
        VSwitchConfigurator vSwitchConfig = new VSwitchConfigurator();
        vSwitchConfig.internalReadFields(vSwitch);
        SrDateAndTime time = (SrDateAndTime)vSwitch.getValue(ParameterCode.VSWITCH_LAST_RESET);
        return time;
    }

    public SrType getScalarFromComm(MibItem valToGet, char agentIndex) throws SrCommException {
        SrOid oid = new SrOid(valToGet.toString(), "0");
        SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
        CommVarBindList vbList = new CommVarBindList();
        vbList.add(varBind);
        this.commGetList(vbList, agentIndex);
        int index = vbList.indexOf(varBind);
        return ((SrSnmpVarBind)vbList.elementAt(index)).getValue();
    }

    public void removeNotReadyRows(SrSnmpTable table, CommKeyClassId vSwitchData) throws SrCommException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        CommMgr commMgr = CommMgr.getInstance(snmpAgentIndex);
        if (table == null) {
            table = commMgr.createTableRef(this.myTableName, snmpAgentIndex);
        }
        this.commRefreshTable(table, snmpAgentIndex);
        CommVarBindList vbList = new CommVarBindList();
        SrSnmpVarBind volRs = new SrSnmpVarBind(this.myRowStatusMib.toString(), (SrType)RowStatusConstants.ROW_STATUS_NOT_READY);
        vbList.add(volRs);
        ConfigElementDataList notReadyElements = this.getElementsByFilter(vbList, table);
        for (int i = 0; i < notReadyElements.size(); ++i) {
            ConfigElementData elementToRemove = (ConfigElementData)notReadyElements.get(i);
            ElementConfigurator elementToRemoveConfig = DataMgrAOImpl.getElementConfigFromClassID(elementToRemove.getClassId());
            elementToRemoveConfig.internalRemove(elementToRemove);
            theLogger.warn(SrLogCategories.LEGACY, "Invalid Element: ", elementToRemove.getCommKeyClassId(), " was removed from ", vSwitchData);
        }
    }

    public ConfigElementData createConfigElementFromVarBindList(CommVarBindList vbList, char agentIndex) throws SrCommException {
        ConfigElementData element = this.createConfigElementFromTableRow(vbList, agentIndex);
        return element;
    }

    private CommVarBindList[] ignoreRowsWithRowStatus(char agentIndex, CommVarBindList[] table, MibItem rowStatusMibItem, RowStatusConstants rowStatus) {
        if (table != null) {
            ArrayList<CommVarBindList> varBindLists = null;
            if (rowStatusMibItem != null) {
                for (int i = 0; i < table.length; ++i) {
                    Enumeration e = table[i].elements();
                    while (e.hasMoreElements()) {
                        RowStatusConstants value;
                        CommVarBind varBind = (CommVarBind)e.nextElement();
                        String key = ((SrOid)varBind.getVarBindKey()).getKey();
                        String rsKey = key.substring(0, key.indexOf("."));
                        if (!rsKey.equals(rowStatusMibItem.toString()) || !(value = (RowStatusConstants)varBind.getValue()).equals(rowStatus)) continue;
                        CommKeyClassId vSwitchData = null;
                        if (varBindLists == null) {
                            varBindLists = new ArrayList<CommVarBindList>(Arrays.asList(table));
                            vSwitchData = CommKeyUtil.getVSwitchData(agentIndex);
                        }
                        varBindLists.remove(table[i]);
                        theLogger.warn(SrLogCategories.LEGACY, "Row status of ", key, " is ", rowStatus, " on ", vSwitchData);
                    }
                }
            }
            if (varBindLists != null) {
                CommVarBindList[] list = new CommVarBindList[varBindLists.size()];
                for (int i = 0; i < list.length; ++i) {
                    list[i] = (CommVarBindList)varBindLists.get(i);
                }
                return list;
            }
        }
        return table;
    }

    private CommVarBindList[] ignoreRowsWithRowStatus(char agentIndex, CommVarBindList[] table, RowStatusConstants rowStatus) {
        return this.ignoreRowsWithRowStatus(agentIndex, table, this.myRowStatusMib, rowStatus);
    }

    protected CommVarBindList[] ignoreNotReadyRows(char agentIndex, CommVarBindList[] table) {
        return this.ignoreRowsWithRowStatus(agentIndex, table, RowStatusConstants.ROW_STATUS_NOT_READY);
    }

    protected CommVarBindList[] ignoreDestroyedRows(char agentIndex, CommVarBindList[] table) {
        return this.ignoreRowsWithRowStatus(agentIndex, table, RowStatusConstants.ROW_STATUS_DESTROY);
    }

    protected abstract CommKeyClassId recalculateNextIndex(ConfigElementData var1) throws SrCommException;

    protected static CommKeyClassId getNextIncrementalIndex(CommKeyClassId aPrevKey) {
        CommKey[] keys = aPrevKey.getCommKeys();
        CommKey[] nextKeys = new CommKey[keys.length];
        theLogger.logAndAssert(SrLogCategories.ERROR, keys.length == 1, new Object[]{"The CommKey is not in the expected size"});
        int i = keys.length;
        while (i-- > 0) {
            CommKey prevKey = keys[i];
            long[] parsedIndex = Util.stringToLongArray(prevKey.getKey());
            int n = parsedIndex.length - 1;
            parsedIndex[n] = parsedIndex[n] + 1L;
            String newIndex = Util.longArrayToString(parsedIndex);
            if (prevKey instanceof SnmpCommKey) {
                nextKeys[i] = new SnmpCommKey(newIndex, ((SnmpCommKey)prevKey).getSnmpAgentIndex());
                continue;
            }
            if (!(prevKey instanceof DataBaseCommKey)) continue;
            nextKeys[i] = new DataBaseCommKey(newIndex);
        }
        return new CommKeyClassId(nextKeys, aPrevKey.getClassID());
    }

    protected CommKeyClassId getNextMIBIndex(CommKeyClassId aPrevIndex, MibItem aIndexNextItem) throws SrCommException {
        char agentIndex = aPrevIndex.getMyFirstSnmpAgentIndex();
        SrType indexNext = this.getScalarFromComm(aIndexNextItem, agentIndex);
        long indexNextLongValue = -1L;
        indexNextLongValue = indexNext instanceof SrInteger ? (long)((SrInteger)indexNext).intValue() : (indexNext instanceof SrGauge ? ((BigInteger)indexNext.value()).longValue() : Long.parseLong(indexNext.toString()));
        SnmpCommKey prevIndex = aPrevIndex.getSnmpCommKey();
        long[] parsedIndex = Util.stringToLongArray(prevIndex.getKey());
        parsedIndex[parsedIndex.length - 1] = indexNextLongValue;
        String newIndexStr = Util.longArrayToString(parsedIndex);
        return new CommKeyClassId(new SnmpCommKey(newIndexStr, agentIndex), aPrevIndex.getClassID());
    }

    protected final String getIndexNext(String tableName, char agentIndex) throws SrCommException {
        return this.getIndexNext(tableName, "1", null, false, agentIndex);
    }

    protected final String getIndexNext(String tableName, String firstIndex, String parent, boolean fillGaps, char agentIndex) throws SrCommException {
        String parentIndex;
        String string = parentIndex = parent == null ? UNKNOWN_TABLE : parent;
        if (firstIndex == null || firstIndex.length() == 0) {
            throw new IllegalArgumentException("You must provide first index in order to create next index");
        }
        CommVarBindList[] table = this.commGetAll(tableName, agentIndex);
        if (table.length == 0) {
            return firstIndex;
        }
        String[] tableIndices = new String[table.length];
        int i = tableIndices.length;
        while (i-- > 0) {
            tableIndices[i] = ((CommVarBind)table[i].elementAt(0)).getIndexForCommKey();
        }
        int rowCursor = 0;
        for (int i2 = 0; i2 < table.length; ++i2) {
            if (parentIndex.compareTo(tableIndices[i2]) >= 0) continue;
            rowCursor = i2;
            break;
        }
        long prevIndexPostfix = 0L;
        for (int i3 = rowCursor; i3 < tableIndices.length && SrOid.isParentOf(parentIndex, tableIndices[i3]); ++i3) {
            rowCursor = i3;
            long[] cursorIndexComponents = SrOid.getComponents(tableIndices[i3]);
            long cursorIndexPostfix = cursorIndexComponents[cursorIndexComponents.length - 1];
            if (fillGaps && cursorIndexPostfix - prevIndexPostfix > 1L) break;
            prevIndexPostfix = cursorIndexPostfix;
        }
        if (parent == null) {
            long[] cursorIndexComponents = SrOid.getComponents(tableIndices[rowCursor]);
            cursorIndexComponents[cursorIndexComponents.length - 1] = prevIndexPostfix + 1L;
            StringBuffer buff = new StringBuffer();
            for (int i4 = 0; i4 < cursorIndexComponents.length - 1; ++i4) {
                buff.append(cursorIndexComponents[i4]).append('.');
            }
            buff.append(cursorIndexComponents[cursorIndexComponents.length - 1]);
            return buff.toString();
        }
        return new StringBuffer().append(parent).append('.').append(prevIndexPostfix + 1L).toString();
    }

    public final void stimulateRefresh(char agentIndex) throws SrCommException {
        CheckListConfigElementData checkList = new CheckListConfigElementData(this.myClassId);
        ConfigElementDataList dataList = this.refreshTable(agentIndex, null, checkList);
        if (dataList != null) {
            this.sendRefreshedElementsToEventMgr(dataList, CommKeyUtil.getVSwitchData(agentIndex));
            EventMgr.getInstance().sendCheckListEvent(checkList, this);
        }
    }

    public final void executeConfiguration(ConfigElementData aElement) throws SrCommException {
        this.handleNestedCedsConfiguration(aElement);
        ConfigOperation configType = aElement.getConfigOperation();
        switch (configType) {
            case CREATE: {
                this.internalCreate(aElement);
                boolean isCreateEventSent = this.readAfterCreate(aElement);
                if (!isCreateEventSent) {
                    SrEventHandler.getEventMgr().sendAddElementEvent(aElement, (Object)this);
                }
                this.postCreateOperation(aElement);
                break;
            }
            case CHANGE: {
                this.internalChange(aElement);
                boolean isChangeEventSent = this.readAfterChange(aElement);
                if (!isChangeEventSent) {
                    SrEventHandler.getEventMgr().sendChangeElementEvent(aElement, (Object)this);
                }
                this.postChangeOperation(aElement);
                break;
            }
            case DELETE: 
            case DELETE_TREE: {
                this.internalRemove(aElement);
                SrEventHandler.getEventMgr().sendRemoveElementEvent(aElement, this);
                this.postSendRemoveEvent(aElement);
                break;
            }
            default: {
                throw new IllegalArgumentException("The value of the configuration type " + (Object)((Object)configType) + " is not valid in element " + aElement);
            }
        }
        aElement.setUsedForConfiguration(true);
    }

    private void handleNestedCedsConfiguration(ConfigElementData aParentCed) throws SrCommException {
        for (ParameterCodes codes : aParentCed.hiddenKeySet()) {
            ParameterCode code = (ParameterCode)codes;
            Object value = aParentCed.getValue(code);
            if (value instanceof ConfigElementData) {
                ConfigElementData nestedCed = (ConfigElementData)value;
                this.handleSingleNestedCed(aParentCed, nestedCed, code);
            }
            if (!(value instanceof ConfigElementDataList)) continue;
            ConfigElementDataList nestedList = (ConfigElementDataList)value;
            this.handleNestedCedList(aParentCed, nestedList, code);
        }
    }

    private void handleSingleNestedCed(ConfigElementData aParentCed, ConfigElementData aNestedCed, ParameterCode aCode) throws SrCommException {
        if (!aNestedCed.isUsedForConfiguration()) {
            ElementConfigurator config = DataMgrAOImpl.getElementConfigFromClassID(aNestedCed.getClassId());
            config.executeConfiguration(aNestedCed);
        }
        ConfigOperation configType = aNestedCed.getConfigOperation();
        switch (configType) {
            case CREATE: {
                this.updateByNestedCedCreation(aParentCed, aNestedCed, aCode);
                break;
            }
            case CHANGE: {
                this.updateByNestedCedChange(aParentCed, aNestedCed, aCode);
                break;
            }
            case DELETE: 
            case DELETE_TREE: {
                this.updateByNestedCedDeletion(aParentCed, aNestedCed, aCode);
                break;
            }
            default: {
                throw new IllegalArgumentException("The value of the configuration type " + (Object)((Object)configType) + " is not valid in element " + aNestedCed);
            }
        }
    }

    private void handleNestedCedList(ConfigElementData aParentCed, ConfigElementDataList aNestedList, ParameterCode aCode) throws SrCommException {
        ConfigOperation configType = ConfigOperation.NO_OPERATION;
        for (ElementData element : aNestedList) {
            ConfigElementData nestedCed = (ConfigElementData)element;
            if (configType == ConfigOperation.NO_OPERATION) {
                configType = nestedCed.getConfigOperation();
            }
            if (nestedCed.isUsedForConfiguration()) continue;
            ElementConfigurator config = DataMgrAOImpl.getElementConfigFromClassID(nestedCed.getClassId());
            config.executeConfiguration(nestedCed);
        }
        switch (configType) {
            case CREATE: {
                this.updateByNestedCedListCreation(aParentCed, aNestedList, aCode);
                break;
            }
            case CHANGE: {
                this.updateByNestedCedListChange(aParentCed, aNestedList, aCode);
                break;
            }
            case DELETE: 
            case DELETE_TREE: {
                this.updateByNestedCedListDeletion(aParentCed, aNestedList, aCode);
                break;
            }
            default: {
                throw new IllegalArgumentException("The value of the configuration type " + (Object)((Object)configType) + " is not valid in element " + aNestedList);
            }
        }
    }

    protected void updateByNestedCedCreation(ConfigElementData aParentCed, ConfigElementData aNestedCed, ParameterCode aCode) {
        aParentCed.setValue(aCode, aNestedCed.getCommKeyClassId());
    }

    protected void updateByNestedCedChange(ConfigElementData aParentCed, ConfigElementData aNestedCed, ParameterCode aCode) {
        aParentCed.setValue(aCode, aNestedCed.getCommKeyClassId());
    }

    protected void updateByNestedCedDeletion(ConfigElementData aParentCed, ConfigElementData aNestedCed, ParameterCode aCode) {
        aParentCed.removeParameter(aCode);
    }

    protected void updateByNestedCedListCreation(ConfigElementData aParentCed, ConfigElementDataList aNestedCeds, ParameterCode aCode) {
        aParentCed.addParameter(aCode, aNestedCeds.getArrayOfCommKeyClassId());
    }

    protected void updateByNestedCedListChange(ConfigElementData aParentCed, ConfigElementDataList aNestedCeds, ParameterCode aCode) {
        aParentCed.addParameter(aCode, aNestedCeds.getArrayOfCommKeyClassId());
    }

    protected void updateByNestedCedListDeletion(ConfigElementData aParentCed, ConfigElementDataList aNestedCeds, ParameterCode aCode) {
        aParentCed.removeParameter(aCode);
    }

    public final void create(ConfigElementData aElement) throws SrCommException {
        this.handleNestedCedsCreation(aElement);
        this.internalCreate(aElement);
    }

    private void handleNestedCedsCreation(ConfigElementData element) throws SrCommException {
        for (ParameterCode parameterCode : element.keySet()) {
            Object value = element.getValue(parameterCode);
            if (value instanceof ConfigElementData) {
                ConfigElementData nestedCed = (ConfigElementData)value;
                if (!nestedCed.isCreated()) {
                    theLogger.trace(SrLogCategories.LEGACY, "create", element, "from", nestedCed);
                    this.createNestedCed(nestedCed);
                }
                element.setValue(parameterCode, nestedCed.getCommKeyClassId());
            }
            if (!(value instanceof ConfigElementDataList)) continue;
            ConfigElementDataList nestedList = (ConfigElementDataList)value;
            for (ElementData nestedCed : nestedList) {
                if (nestedCed.isCreated()) continue;
                theLogger.trace(SrLogCategories.LEGACY, "create", nestedCed, "from", element);
                this.createNestedCed((ConfigElementData)nestedCed);
            }
            element.addParameter(parameterCode, nestedList.getArrayOfCommKeyClassId());
        }
    }

    private void createNestedCed(ConfigElementData aNestedCed) throws SrCommException {
        ElementConfigurator config = DataMgrAOImpl.getElementConfigFromClassID(aNestedCed.getClassId());
        config.create(aNestedCed);
        boolean isElementSentByEvent = config.readAfterCreate(aNestedCed);
        if (!isElementSentByEvent) {
            SrEventHandler.getEventMgr().sendAddElementEvent(aNestedCed, (Object)this);
        }
        config.postCreateOperation(aNestedCed);
    }

    protected void getParametersFromChild(ConfigElementData child, ConfigElementData element) {
        for (ParameterCode parameterCode : element.keySet()) {
            Object value = element.getValue(parameterCode);
            if (!(value instanceof ConfigElementData)) continue;
            element.setValue(parameterCode, child.getCommKeyClassId());
        }
    }

    public final void stimulateRefreshByPrefix(char agentIndex, String indexPrefix) throws SrCommException {
        ConfigElementDataList subTable = this.getAllByPrefix(agentIndex, indexPrefix);
        if (subTable != null) {
            CheckListConfigElementData checkList = new CheckListConfigElementData(this.myClassId);
            this.buildCheckListElement(subTable, checkList, agentIndex, null);
            EventMgr.getInstance().sendRefreshElementEvent(subTable, (Object)this);
            EventMgr.getInstance().sendCheckListEvent(checkList, this);
        }
    }

    protected HashMap<SnmpCommKey, ElementData> createMapFromList(ConfigElementDataList dataList) {
        HashMap<SnmpCommKey, ElementData> ret = new HashMap<SnmpCommKey, ElementData>();
        int i = dataList.size();
        while (i-- > 0) {
            ElementData elem = dataList.getElementDataAt(i);
            ret.put(elem.getSnmpKey(), elem);
        }
        return ret;
    }

    private static CommVarBind getRowStatusVarBind(CommVarBindList aVarBindList, MibItem aRowStatusMib) {
        if (aRowStatusMib == null) {
            return null;
        }
        for (CommVarBind commVarBind : aVarBindList) {
            SrOid oid;
            CommVarBindKey varBindKey = commVarBind.getVarBindKey();
            if (!(varBindKey instanceof SrOid) || !(oid = (SrOid)varBindKey).getOid().equals(aRowStatusMib.getMibName())) continue;
            return commVarBind;
        }
        return null;
    }

    private static String calculateOperationByCommVarBind(CommVarBind aCommVarBind, boolean aIsGetOrSet) {
        if (aCommVarBind == null) {
            return aIsGetOrSet ? READ_OPERATION : CHANGE_OPERATION;
        }
        SrType curVal = aCommVarBind.getValue();
        if (curVal != null) {
            if (curVal.equals(RowStatusConstants.ROW_STATUS_CREATE_AND_GO) || curVal.equals(RowStatusConstants.ROW_STATUS_CREATE_AND_WAIT)) {
                return CREATE_OPERATION;
            }
            if (curVal.equals(RowStatusConstants.ROW_STATUS_DESTROY)) {
                return REMOVE_OPERATION;
            }
        }
        throw new IllegalArgumentException("The passed in aCommVarBind has an invalid row status: " + aCommVarBind);
    }

    private static void setCommExceptionData(SrCommException aSrCommException, ClassID aClassID, Character aSnmpAgentIndex, MibItem aRowStatusMib, boolean aIsGetOrSet) {
        CommVarBind commVarBind;
        Parameter param;
        SrOperationException operationException;
        int errorIndex;
        CommVarBindList varBindList = aSrCommException.getCommVarbindList();
        ConfigElementData ced = null;
        if (varBindList.isEmpty()) {
            ced = aSnmpAgentIndex != null ? new ConfigElementData(CommKeyUtil.getVSwitchData(aSnmpAgentIndex.charValue())) : new ConfigElementData(aClassID);
        } else {
            CommKey commKey = null;
            String key = ((CommVarBind)varBindList.elementAt(0)).getIndexForCommKey();
            commKey = aSnmpAgentIndex != null ? new SnmpCommKey(key, aSnmpAgentIndex.charValue()) : new DataBaseCommKey(key);
            ced = new ConfigElementData(commKey, aClassID);
        }
        ParameterCode pc = null;
        if (aSrCommException instanceof SrOperationException && (errorIndex = (operationException = (SrOperationException)aSrCommException).getErrorIndex()) >= 0 && (param = ElementConfigurator.convertVarBindToParam(commVarBind = (CommVarBind)varBindList.get(errorIndex))) != null) {
            pc = param.getCode();
        }
        for (CommVarBind varBind : varBindList) {
            Parameter param2 = ElementConfigurator.convertVarBindToParam(varBind);
            if (param2 == null) continue;
            ced.addParameter(param2);
        }
        if (aSnmpAgentIndex != null) {
            CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(aSnmpAgentIndex.charValue());
            ced.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        }
        String operation = ElementConfigurator.calculateOperationByCommVarBind(ElementConfigurator.getRowStatusVarBind(varBindList, aRowStatusMib), aIsGetOrSet);
        aSrCommException.addMessagePrefix("Error " + operation + " " + aClassID + " on " + VSwitch.VSWITCH_DISPLAY_STRING + " ");
        aSrCommException.setErrorConfigElementAndParameterCode(ced, pc);
    }

    protected void commSetList(CommVarBindList aVarBindsToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).setList(aVarBindsToSet, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected void commSetListSnmpOnly(CommVarBindList aVarBindsToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).setListSnmpOnly(aVarBindsToSet, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected void commSetSnmpOnly(CommVarBind aVarBindToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).setSnmpOnly(aVarBindToSet, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            CommVarBindList commVarBindList = new CommVarBindList();
            commVarBindList.add(aVarBindToSet);
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected void commGetList(CommVarBindList aVarBindsToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).getList(aVarBindsToSet, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commGetListsByKeyPrefix(CommVarBindList aVarBindsToSet, String aKeyPrefix, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getListsByKeyPrefix(aVarBindsToSet, aKeyPrefix, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    public void commRefreshTable(SrSnmpTable aSnmpTable, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).refreshTable(aSnmpTable);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commGetTableRowsByValue(String aTableName, String aColumnName, SrType aValue, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getTableRowsByValue(aTableName, aColumnName, aValue, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commGetAll(String aTableName, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getAll(aTableName, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList commGetTableRow(SrSnmpTable aTable, CommKey aRowIndex) throws SrCommException {
        try {
            return CommMgr.getTableRow(aTable, aRowIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, null, this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList commGetOneRow(String[] aTableNames, CommKey aRowIndex, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getOneRow(aTableNames, aRowIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected void commAddSnmpAgent(CommVarBindList aNewAgentData) throws SrCommException {
        try {
            CommMgr.addSnmpAgent(aNewAgentData);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, null, this.myRowStatusMib, false);
            throw e;
        }
    }

    protected Map<SrIpAddress, SrInteger> commGetAndInitAllVSwitches(Integer aClusterId, VSwitchConfigurator.VSwitchDataContainer aSwitchDataContainer) throws SrCommException {
        try {
            if (aClusterId != null) {
                return CommMgr.getAndInitAllVSwitches(aClusterId, aSwitchDataContainer);
            }
            return CommMgr.getAndInitAllVSwitches(aSwitchDataContainer);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, null, this.myRowStatusMib, true);
            throw e;
        }
    }

    protected void commRemoveSnmpAgent(char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).removeSnmpAgent(aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected void commRemoveSite(Integer aVSwitchGroupId, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).removeSite(aVSwitchGroupId);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected void commRemoveCluster(Integer aVSwitchGroupId, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).removeCluster(aVSwitchGroupId);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected void commChangeClusterParams(CommVarBindList aVarBindsToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).changeClusterParams(aVarBindsToSet);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected void commChangeSiteParams(CommVarBindList aVarBindsToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).changeSiteParams(aVarBindsToSet);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected void commChangeSnmpAgentParams(CommVarBindList aVarBindsToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).changeSnmpAgentParams(aVarBindsToSet, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected CommVarBindList[] commGetAllClustersData(char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getAllClustersData();
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commGetAllSitesData(char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getAllSitesData();
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commGetEmailContactData(char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getEmailContactData();
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commGetEmailContactData(Integer aClusterId, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getEmailContactData(aClusterId);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commGetAllAlarmTypesData(char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getAllAlarmTypesData();
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commGetAllAlarmTypesData(Integer aClusterId, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getAllAlarmTypesData(aClusterId);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected void commSetToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms, char aSnmpAgentIndex) throws SrCommException {
        try {
            CommMgr.getInstance(aSnmpAgentIndex).setToFile(aFileName, aAlarms);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, false);
            throw e;
        }
    }

    protected List<HistoryAlarmData> commLoadFromFile(String aFileName, Serializable aSerializable, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).loadHistoryAlarmsFromFile(aFileName);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commSnmpGetTable(CommVarBindList aVarBindsToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).snmpGetTable(aVarBindsToSet, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected CommVarBindList[] commSnmpGetBulk(CommVarBindList aVarBindsToSet, char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).snmpGetBulk(aVarBindsToSet, aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }

    protected String commGetManagerIpAddress(char aSnmpAgentIndex) throws SrCommException {
        try {
            return CommMgr.getInstance(aSnmpAgentIndex).getManagerIpAddress(aSnmpAgentIndex);
        }
        catch (SrCommException e) {
            ElementConfigurator.setCommExceptionData(e, this.myClassId, Character.valueOf(aSnmpAgentIndex), this.myRowStatusMib, true);
            throw e;
        }
    }
}

