/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.SrTargetTestUtils;
import com.sanrad.SrTestUtils;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.concurrent.SrExecutionException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class DataMgrAOImplTest
extends TestCase {
    private static SrTestUtils myTestUtils;
    private static int theTargetCounter;
    private static final String theTargetAliasPrefix = "$target$test$";

    public DataMgrAOImplTest(String arg0) {
        super(arg0);
        if (myTestUtils == null) {
            myTestUtils = SrTestUtils.getInstance();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        SrLogger.init(new Properties());
        ClusterImpl cluster = myTestUtils.createCluster("244", SystemRootImpl.getInstance());
        cluster.addVSwitch("172.20.35.244", "255.255.255.0", 161, 162, "public", "private", 3000L, 3, SnmpVersion.V2C).get();
    }

    public void testConfigureElements() throws RemoteException {
        myTestUtils.waitMillis(2000L);
        List<ClusterImpl> allClusters = myTestUtils.getClusters();
        ClusterImpl cluster = null;
        for (ClusterImpl _cluster : allClusters) {
            if (_cluster.getConnectedVSwitches().length <= 0) continue;
            cluster = _cluster;
            break;
        }
        DataMgrAOImplTest.assertNotNull((String)"Cluster not found", cluster);
        String target1Alias = DataMgrAOImplTest.getNewTargetAlias();
        String target1AliasChanged = DataMgrAOImplTest.getNewTargetAlias();
        Target target1 = myTestUtils.createNewTarget(cluster, target1Alias);
        DataMgrAOImplTest.assertNotNull((String)"target1 not found", (Object)target1);
        ConfigElementData changeTarget1CED = new ConfigElementData(target1.getCommKeyClassId(), ConfigOperation.CHANGE);
        changeTarget1CED.setValue(ParameterCode.ISCSI_TARGET_ALIAS, new SrString(target1AliasChanged));
        String target2Alias = DataMgrAOImplTest.getNewTargetAlias();
        ConfigElementData createTarget2CED = SrTargetTestUtils.getCEDForTargetCreation(target2Alias, cluster);
        ConfigElementDataList cedList = new ConfigElementDataList(changeTarget1CED, createTarget2CED);
        try {
            DataMgrAOImpl.getInstance().configureElements(cedList).get();
        }
        catch (SrExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        myTestUtils.waitMillis(5000L);
        ISCSITargetImpl target2 = cluster.getTargetListMgr().getTargetByAlias(target2Alias);
        DataMgrAOImplTest.assertNotNull((Object)cluster.getTargetListMgr().getTargetByAlias(target1AliasChanged));
        DataMgrAOImplTest.assertNotNull((Object)target2);
        try {
            target1.deleteElement().get();
            target2.deleteElement().get();
        }
        catch (SrExecutionException e) {
            e.printStackTrace();
        }
        catch (IllegalValueException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static String getNewTargetAlias() {
        return theTargetAliasPrefix + theTargetCounter++;
    }

    static {
        theTargetCounter = (int)(Math.random() * 10000.0);
    }
}

