/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.TrapEvent;
import com.sanrad.nms.server.event.DataMgrListener;
import com.sanrad.nms.server.event.DbErrorEvent;
import com.sanrad.nms.server.event.DbErrorListener;
import com.sanrad.nms.server.event.ErrorEvent;
import com.sanrad.nms.server.event.ErrorListener;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SnmpErrorListener;
import com.sanrad.nms.server.event.SrCreateElementEvent;
import com.sanrad.nms.server.event.SrEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.AlarmTypeConfigurator;
import com.sanrad.nms.server.mgr.ClusterConfigurator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAO_AG;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.EmailContactConfigurator;
import com.sanrad.nms.server.mgr.FCIfConfigurator;
import com.sanrad.nms.server.mgr.FCNodeConfigurator;
import com.sanrad.nms.server.mgr.HardwareConfigurator;
import com.sanrad.nms.server.mgr.ISCSIRemotePortalDiscoveryConfigurator;
import com.sanrad.nms.server.mgr.IScsiConnectionConfigurator;
import com.sanrad.nms.server.mgr.IScsiInstanceConfigurator;
import com.sanrad.nms.server.mgr.IScsiRemoteInitatoresConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionConfigurator;
import com.sanrad.nms.server.mgr.IfConfigurator;
import com.sanrad.nms.server.mgr.IfStatisticConfigurator;
import com.sanrad.nms.server.mgr.IpRouteConfigurator;
import com.sanrad.nms.server.mgr.IscsiTargetQosGroupConfigurator;
import com.sanrad.nms.server.mgr.LUNConfigurator;
import com.sanrad.nms.server.mgr.NetConfigConfigurator;
import com.sanrad.nms.server.mgr.PScsiIfConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetPortalConfigurator;
import com.sanrad.nms.server.mgr.ScsiDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiInitiatorDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiPortConfigurator;
import com.sanrad.nms.server.mgr.SiteConfigurator;
import com.sanrad.nms.server.mgr.SnmpManagerConfigurator;
import com.sanrad.nms.server.mgr.SnmpTargetAddressConfigurator;
import com.sanrad.nms.server.mgr.StorageDomainConfigurator;
import com.sanrad.nms.server.mgr.TcpConnectionConfigurator;
import com.sanrad.nms.server.mgr.UDPListenerConfigurator;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthorizationConfigurator;
import com.sanrad.nms.server.mgr.config.PersistencyDataAOImpl;
import com.sanrad.nms.server.mgr.config.VSwitchDataAOImpl;
import com.sanrad.nms.server.mgr.dr.AsyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.AsyncPairPiTConfigurator;
import com.sanrad.nms.server.mgr.dr.ConsistencyGroupConfigurator;
import com.sanrad.nms.server.mgr.dr.ConsistencyGroupPiTConfigurator;
import com.sanrad.nms.server.mgr.dr.ExtendedPairConfigurator;
import com.sanrad.nms.server.mgr.dr.PairConfigurator;
import com.sanrad.nms.server.mgr.dr.SyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.AsyncPairControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.CGControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.SyncPairControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityNameConfigurator;
import com.sanrad.nms.server.mgr.identity.SRPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.lu.SCSILunConfigurator;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.policy.PolicyConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyParamConfigurator;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.raid.AttachedRaidConfigurator;
import com.sanrad.nms.server.mgr.raid.RaidTrapConfigurator;
import com.sanrad.nms.server.mgr.srv.isns.ISNSServerConfigurator;
import com.sanrad.nms.server.mgr.srv.radius.RadiusServerConfigurator;
import com.sanrad.nms.server.mgr.storage.DirectAccessDeviceConfigurator;
import com.sanrad.nms.server.mgr.storage.LUIdentifierConfigurator;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageConfigurator;
import com.sanrad.nms.server.mgr.storage.SubDirectAccessDeviceConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiPortalConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiTargetConfigurator;
import com.sanrad.nms.server.mgr.volume.ConcatVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.CubeVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.JournalVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.MirrVolConfigElementData;
import com.sanrad.nms.server.mgr.volume.MirrorVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.MirrorVolumeSyncConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SnapshotSchedulerConfigurator;
import com.sanrad.nms.server.mgr.volume.SnapshotVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.StripeVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.TransparentVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.alarm.HistoryAlarmData;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrActiveObject;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DataMgrAOImpl
extends DataMgrAO_AG {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static DataMgrAOImpl theInstance = new DataMgrAOImpl();
    private Map<CommKeyClassId, VSwitchDataAOImpl> myVswitchesMap = new HashMap<CommKeyClassId, VSwitchDataAOImpl>();
    private PersistencyDataAOImpl myPersistencyAO = new PersistencyDataAOImpl();
    protected SrEventListenerManager myListeners = new SrEventListenerManager();
    SrEventListenerManager.Informer<DbErrorListener, DbErrorEvent> myDBErrorInformer = new SrEventListenerManager.Informer<DbErrorListener, DbErrorEvent>(){

        @Override
        public void inform(DbErrorListener listener, DbErrorEvent event) {
            listener.newDBError(event);
        }
    };
    SrEventListenerManager.Informer<ErrorListener, ErrorEvent> myConfigurationErrorInformer = new SrEventListenerManager.Informer<ErrorListener, ErrorEvent>(){

        @Override
        public void inform(ErrorListener listener, ErrorEvent event) {
            listener.configurationError(event);
        }
    };
    SrEventListenerManager.Informer<ErrorListener, ErrorEvent> myFatalConfigurationErrorInformer = new SrEventListenerManager.Informer<ErrorListener, ErrorEvent>(){

        @Override
        public void inform(ErrorListener listener, ErrorEvent event) {
            listener.fatalConfigurationError(event);
        }
    };
    SrEventListenerManager.Informer<DataMgrListener, SrEvent> myElementEventInformer = new SrEventListenerManager.Informer<DataMgrListener, SrEvent>(){

        @Override
        public void inform(DataMgrListener listener, SrEvent event) {
            listener.handleElementEvent(event);
        }
    };
    SrEventListenerManager.Informer<SnmpErrorListener, SnmpErrorEvent> mySnmpErrorInformer = new SrEventListenerManager.Informer<SnmpErrorListener, SnmpErrorEvent>(){

        @Override
        public void inform(SnmpErrorListener listener, SnmpErrorEvent event) {
            listener.newSnmpError(event);
        }
    };
    SrEventListenerManager.Informer<SnmpErrorListener, SnmpErrorEvent> mySnmpTimeOutErrorInformer = new SrEventListenerManager.Informer<SnmpErrorListener, SnmpErrorEvent>(){

        @Override
        public void inform(SnmpErrorListener listener, SnmpErrorEvent event) {
            listener.newSnmpTimeOutError(event);
        }
    };

    public static DataMgrAOImpl getInstance() {
        return theInstance;
    }

    DataMgrAOImpl() {
        CommMgr.addTrapListenerToAllMonitors(this);
    }

    @Override
    protected void __load(final SrFuture<Void> aFuture) throws Exception {
        final SrFuture<ConfigElementDataList> future = this.myPersistencyAO.load();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.loadFinished(future, aFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void __loadFinished(SrFuture<ConfigElementDataList> aLoadFuture, SrFuture<Void> aFuture) throws Exception {
        try {
            try {
                ConfigElementDataList vswitchCedList = aLoadFuture.get();
            }
            finally {
                SrEventHandler.getEventMgr().sendEndOfClusterDiscovery(this);
            }
        }
        catch (Exception e) {
            aFuture.setException(e);
        }
        finally {
            if (!aFuture.isDone()) {
                aFuture.set(null);
            }
        }
        return null;
    }

    @Override
    protected void __resumeAllPolling(final SrFuture<Void> aFuture) throws Exception {
        final ArrayList<SrFuture> dependencyFutures = new ArrayList<SrFuture>();
        for (VSwitchDataAOImpl curVsAO : this.myVswitchesMap.values()) {
            if (curVsAO.isShutdown()) {
                theLogger.info(SrLogCategories.INFORMATIVE, "The polling for VS AO ", curVsAO, " will not be resumed since the AO is shutdown.");
                dependencyFutures.add(new CompleteFuture("DataMgrAOImpl.resumeAllPolling --> " + curVsAO + " is shutdown."));
                continue;
            }
            theLogger.info(SrLogCategories.INFORMATIVE, "Trying to resume polling for VS AO ", curVsAO);
            dependencyFutures.add(curVsAO.resumeAllPolling());
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                theLogger.info(SrLogCategories.INFORMATIVE, "The polling for VS AO was resumed.");
                DataMgrAOImpl.this.resumeAllPollingFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __resumeAllPollingFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aResumeFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aResumeFutures);
    }

    @Override
    protected void __suspendAllPolling(final SrFuture<Void> aFuture) throws Exception {
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        for (VSwitchDataAOImpl curVsAO : this.myVswitchesMap.values()) {
            dependencyFutures.add(curVsAO.suspendAllPolling());
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.suspendAllPollingFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __suspendAllPollingFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aSuspendFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aSuspendFutures);
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, final ConfigElementData aCed) throws Exception {
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        if (this.isPersistency(aCed)) {
            SrFuture<Void> future = this.myPersistencyAO.changeElement(aCed);
            dependencyFutures.add(future);
        } else {
            ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCed);
            for (ElementData ced : elementsAccordingToAgents) {
                VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
                SrFuture<Void> future = vswitchAo.changeElement((ConfigElementData)ced);
                dependencyFutures.add(future);
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.changeElementFinished(aCed, aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __changeElementFinished(ConfigElementData element, SrFuture<Void> aFuture, List<SrFuture<Void>> aChangeFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aChangeFutures);
    }

    @Override
    protected void __createElement(final SrFuture<Void> aFuture, final ConfigElementData aCed) throws Exception {
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        if (this.isPersistency(aCed)) {
            SrFuture<Void> future = this.myPersistencyAO.createElement(aCed);
            dependencyFutures.add(future);
        } else {
            ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCed);
            for (ElementData cedObj : elementsAccordingToAgents) {
                ConfigElementData ced = (ConfigElementData)cedObj;
                VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
                SrFuture<Void> future = vswitchAo.createElement(ced);
                dependencyFutures.add(future);
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.createElementFinished(aCed, aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __createElementFinished(ConfigElementData aCed, SrFuture<Void> aFuture, List<SrFuture<Void>> aCreateFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aCreateFutures);
    }

    @Override
    protected void __createElement(final SrFuture<Void> aFuture, ConfigElementDataList aCedList) throws Exception {
        for (ElementData cedObj : aCedList) {
            theLogger.logAndAssert(SrLogCategories.ERROR, !this.isPersistency((ConfigElementData)cedObj), new Object[]{"CED list cannot contain a ced of persistency(V-Switch, cluster or site) element, element: " + cedObj});
        }
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        Collection<ConfigElementDataList> elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCedList);
        for (ConfigElementDataList configElementDataList : elementsAccordingToAgents) {
            ConfigElementData ced = (ConfigElementData)configElementDataList.get(0);
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
            SrFuture<Void> future = vswitchAo.createElement(configElementDataList);
            dependencyFutures.add(future);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.createElementFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __createElementFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aCreateFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aCreateFutures);
    }

    @Override
    protected void __removeElement(final SrFuture<Void> aFuture, final ConfigElementData aCed) throws Exception {
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        if (this.isPersistency(aCed)) {
            SrFuture<Void> future = this.myPersistencyAO.removeElement(aCed);
            dependencyFutures.add(future);
        } else {
            ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCed);
            for (ElementData cedObj : elementsAccordingToAgents) {
                ConfigElementData ced = (ConfigElementData)cedObj;
                VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
                SrFuture<Void> future = vswitchAo.removeElement(ced);
                dependencyFutures.add(future);
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.removeElementFinished(aCed, aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void __removeElementFinished(ConfigElementData aCed, SrFuture<Void> aFuture, List<SrFuture<Void>> aRemoveFuture) throws Exception {
        if (!this.forwardExceptionsIfExist(aFuture, aRemoveFuture)) {
            try {
                if (aCed.getClassId().equals(ClassID.VSWITCH)) {
                    this.removeVSwitch(aCed.getCommKeyClassId());
                }
            }
            finally {
                if (!aFuture.isDone()) {
                    aFuture.set(null);
                }
            }
        }
        return null;
    }

    @Override
    protected void __removeElement(final SrFuture<Void> aFuture, ConfigElementDataList aCedList) throws Exception {
        for (ElementData cedObj : aCedList) {
            this.assertNotPersistency((ConfigElementData)cedObj);
        }
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        Collection<ConfigElementDataList> elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCedList);
        for (ConfigElementDataList configElementDataList : elementsAccordingToAgents) {
            ConfigElementData ced = (ConfigElementData)configElementDataList.get(0);
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
            SrFuture<Void> future = vswitchAo.removeElement(configElementDataList);
            dependencyFutures.add(future);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.removeElementFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __removeElementFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aRemoveFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aRemoveFutures);
    }

    @Override
    protected void __readElement(final SrFuture<Void> aFuture, ConfigElementData aCed) throws Exception {
        this.assertNotPersistency(aCed);
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCed);
        for (ElementData cedObj : elementsAccordingToAgents) {
            ConfigElementData ced = (ConfigElementData)cedObj;
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
            SrFuture<Void> future = vswitchAo.readElement(ced);
            dependencyFutures.add(future);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.readElementFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __readElementFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aReadFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aReadFutures);
    }

    @Override
    protected void __readElementFields(final SrFuture<Void> aFuture, ConfigElementData aCed) throws Exception {
        if (!aCed.containsParameter(ParameterCode.VSWITCH_DATE_AND_TIME)) {
            this.assertNotPersistency(aCed);
        }
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCed);
        for (ElementData cedObj : elementsAccordingToAgents) {
            ConfigElementData ced = (ConfigElementData)cedObj;
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
            SrFuture<Void> future = vswitchAo.readElementFields(ced);
            dependencyFutures.add(future);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.readElementFieldsFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __readElementFieldsFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aReadFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aReadFutures);
    }

    @Override
    protected void __refreshTableFields(final SrFuture<Void> aFuture, ConfigElementData aCed) throws Exception {
        this.assertNotPersistency(aCed);
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCed);
        for (ElementData cedObj : elementsAccordingToAgents) {
            ConfigElementData ced = (ConfigElementData)cedObj;
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
            SrFuture<Void> future = vswitchAo.refreshTableFields(ced);
            dependencyFutures.add(future);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.refreshTableFieldsFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __refreshTableFieldsFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aRefreshFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aRefreshFutures);
    }

    @Override
    protected void __executeVolumeOperation(final SrFuture<Void> aFuture, ConfigElementData aCed, VolumeOperationType anOperType) throws Exception {
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCed);
        for (ElementData cedObj : elementsAccordingToAgents) {
            ConfigElementData ced = (ConfigElementData)cedObj;
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
            SrFuture<Void> future = vswitchAo.executeVolumeOperation(ced, anOperType);
            dependencyFutures.add(future);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.executeVolumeOperationFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __executeVolumeOperationFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aOperateFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aOperateFutures);
    }

    @Override
    protected void __executeOperations(final SrFuture<Void> aFuture, ElementOperationList anOperationsList) throws Exception {
        if (anOperationsList == null || anOperationsList.isEmpty()) {
            throw new IllegalArgumentException("anOperationsList argument cannot be null or empty. anOperationsList: " + anOperationsList);
        }
        HashMap<CommKeyClassId, ElementOperationList> lists = new HashMap<CommKeyClassId, ElementOperationList>();
        ElementOperation elementOperation = (ElementOperation)anOperationsList.get(0);
        ConfigElementData element = elementOperation.getElement();
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
        for (int j = 0; j < elementsAccordingToAgents.size(); ++j) {
            ConfigElementData configElementData = (ConfigElementData)elementsAccordingToAgents.get(j);
            ElementOperationList opList = new ElementOperationList();
            ElementOperation operation = elementOperation.clone(configElementData);
            opList.addElement(operation);
            CommKeyClassId key = configElementData.getVswitchId();
            lists.put(key, opList);
        }
        for (int i = 1; i < anOperationsList.size(); ++i) {
            ElementOperation op = (ElementOperation)anOperationsList.get(i);
            ConfigElementData dataElement = op.getElement();
            elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(dataElement);
            for (int j = 0; j < elementsAccordingToAgents.size(); ++j) {
                ConfigElementData ced = (ConfigElementData)elementsAccordingToAgents.get(j);
                ElementOperation operation = op.clone(ced);
                CommKeyClassId keyChar = ced.getVswitchId();
                if (lists.containsKey(keyChar)) {
                    ((ElementOperationList)lists.get(keyChar)).addElement(operation);
                    continue;
                }
                ElementOperationList eol = new ElementOperationList();
                eol.addElement(operation);
                lists.put(keyChar, eol);
            }
        }
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        for (CommKeyClassId vsId : lists.keySet()) {
            ElementOperationList operList = (ElementOperationList)lists.get(vsId);
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(vsId);
            SrFuture<Void> future = vswitchAo.executeOperations(operList);
            dependencyFutures.add(future);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.executeOperationsFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __executeOperationsFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aExecutreOperFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aExecutreOperFutures);
    }

    @Override
    protected void __discover(final SrFuture<Void> aCtrlFuture, CommKeyClassId aVsiwtchId) throws Exception {
        VSwitchDataAOImpl vswitchAO = this.getVSwitchAO(aVsiwtchId);
        final SrFuture<Void> future = vswitchAO.discover();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.discoverFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __discoverFinished(SrFuture<Void> aDiscoverFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aDiscoverFuture);
    }

    @Override
    protected void __trapReceived(final SrFuture<Void> aCtrlFuture, TrapEvent event) throws Exception {
        SrTrap trap = event.getTrap();
        CommKeyClassId vswitchId = CommKeyUtil.getVSwitchData(trap.getSourceIndex());
        VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(vswitchId);
        final SrFuture<Void> future = vswitchAo.handleTrap(trap);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.trapReceivedFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __trapReceivedFinished(SrFuture<Void> aHandleTrapFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aHandleTrapFuture);
    }

    @Override
    protected void __startPollingProcess(final SrFuture<Void> aCtrlFuture, CommKeyClassId aVswitchId) throws Exception {
        VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(aVswitchId);
        final SrFuture<Void> future = vswitchAo.startPollingProcess();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.startPollingProcessFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __startPollingProcessFinished(SrFuture<Void> aStartPollingProcessFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aStartPollingProcessFuture);
    }

    @Override
    protected void __startPolling(final SrFuture<Void> aCtrlFuture, PollingGroupType aPollingType, CommKeyClassId aVswitchId) throws Exception {
        VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(aVswitchId);
        final SrFuture<Void> future = vswitchAo.startPolling(aPollingType);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.startPollingFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __startPollingFinished(SrFuture<Void> aStartPollingFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aStartPollingFuture);
    }

    @Override
    protected void __stopPolling(final SrFuture<Void> aCtrlFuture, PollingGroupType aPollingType, CommKeyClassId aVswitchId) throws Exception {
        VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(aVswitchId);
        final SrFuture<Void> future = vswitchAo.stopPolling(aPollingType);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.stopPollingFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __stopPollingFinished(SrFuture<Void> aStopPollingFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aStopPollingFuture);
    }

    @Override
    protected Void __addDbErrorListener(DbErrorListener listener) throws Exception {
        this.myListeners.add(listener);
        return null;
    }

    @Override
    protected Void __addErrorListener(ErrorListener listener) throws Exception {
        this.myListeners.add(listener);
        return null;
    }

    @Override
    protected Void __addEventListener(DataMgrListener listener) throws Exception {
        this.myListeners.add(listener);
        return null;
    }

    @Override
    protected Void __addSnmpErrorListener(SnmpErrorListener listener) throws Exception {
        this.myListeners.add(listener);
        return null;
    }

    @Override
    protected Void __removeDbErrorListener(DbErrorListener listener) throws Exception {
        this.myListeners.remove(listener);
        return null;
    }

    @Override
    protected Void __removeErrorListener(ErrorListener listener) throws Exception {
        this.myListeners.remove(listener);
        return null;
    }

    @Override
    protected Void __removeEventListener(DataMgrListener listener) throws Exception {
        this.myListeners.remove(listener);
        return null;
    }

    @Override
    protected Void __removeSnmpErrorListener(SnmpErrorListener listener) throws Exception {
        this.myListeners.remove(listener);
        return null;
    }

    @Override
    protected Void __sendConfigurationError(ErrorEvent event) throws Exception {
        this.myListeners.fireEvent(ErrorListener.class, event, this.myConfigurationErrorInformer);
        return null;
    }

    @Override
    protected Void __sendDBErrorEvent(DbErrorEvent event) throws Exception {
        this.myListeners.fireEvent(DbErrorListener.class, event, this.myDBErrorInformer);
        return null;
    }

    @Override
    protected Void __sendEvent(SrEvent event) throws Exception {
        if (event.getType() == 1) {
            SrCreateElementEvent createEvt = (SrCreateElementEvent)event;
            ConfigElementDataList ceds = createEvt.getElements();
            for (ElementData ced : ceds) {
                if (!ClassID.VSWITCH.equals(ced.getClassId())) continue;
                this.addVSwitch((ConfigElementData)ced);
            }
        }
        this.myListeners.fireEvent(DataMgrListener.class, event, this.myElementEventInformer);
        return null;
    }

    @Override
    protected Void __sendFatalConfigurationError(ErrorEvent event) throws Exception {
        this.myListeners.fireEvent(ErrorListener.class, event, this.myFatalConfigurationErrorInformer);
        return null;
    }

    @Override
    protected Void __sendSnmpErrorEvent(SnmpErrorEvent event) throws Exception {
        this.myListeners.fireEvent(SnmpErrorListener.class, event, this.mySnmpErrorInformer);
        return null;
    }

    @Override
    protected Void __sendSnmpTimeOutEvent(SnmpErrorEvent aEvent) throws Exception {
        this.myListeners.fireEvent(SnmpErrorListener.class, aEvent, this.mySnmpTimeOutErrorInformer);
        return null;
    }

    @Override
    protected void __attachIdentityToTargetACL(final SrFuture<Void> aCtrlFuture, ConfigElementData aIdentityCed, CommKeyClassId aTargetId) throws Exception {
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        ConfigElementDataList identityCedList = this.splitElementAccordingToAgentIndices(aIdentityCed);
        for (ElementData ced : identityCedList) {
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(((ConfigElementData)ced).getVswitchId());
            SrFuture<Void> future = vswitchAo.attachIdentityToTargetACL((ConfigElementData)ced, aTargetId);
            dependencyFutures.add(future);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.attachIdentityToTargetACLFinished(dependencyFutures, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected Void __attachIdentityToTargetACLFinished(Collection<SrFuture<Void>> aAttachIdentityFutures, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aAttachIdentityFutures);
    }

    @Override
    protected void __postPairCreationRefreshOperation(final SrFuture<Void> aCtrlFuture, char aSnmpAgent) throws Exception {
        VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(CommKeyUtil.getVSwitchData(aSnmpAgent));
        final SrFuture<Void> future = vswitchAo.postPairCreationRefreshOperation();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.postPairCreationRefreshOperationFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __postPairCreationRefreshOperationFinished(SrFuture<Void> aPostPairCreationFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aPostPairCreationFuture);
    }

    @Override
    protected void __loadFromFile(final SrFuture<List<HistoryAlarmData>> aCtrlFuture, String aFileName) throws Exception {
        final SrFuture<List<HistoryAlarmData>> future = this.myPersistencyAO.loadFromFile(aFileName);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.loadFromFileFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    public List<HistoryAlarmData> synchLoadHistoryAlarmsFromFile(String aFileName) {
        try {
            return this.myPersistencyAO.synchLoadFromFile(aFileName);
        }
        catch (SrDatabaseException exp) {
            return new ArrayList<HistoryAlarmData>();
        }
    }

    @Override
    protected Void __loadFromFileFinished(SrFuture<List<HistoryAlarmData>> aLoadFromFileFuture, SrFuture<List<HistoryAlarmData>> aCtrlFuture) throws Exception {
        return SrActiveObject.updateFutureByGivenFuture(aLoadFromFileFuture, aCtrlFuture);
    }

    @Override
    protected void __setPropertiesToFile(final SrFuture<Void> aCtrlFuture, String aFileName, Properties aProperties) throws Exception {
        final SrFuture<Void> future = this.myPersistencyAO.setPropertiesToFile(aFileName, aProperties);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.setPropertiesToFileFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __setPropertiesToFileFinished(SrFuture<Void> aSetToFileFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aSetToFileFuture);
    }

    @Override
    protected void __loadPropertiesFromFile(final SrFuture<Properties> aCtrlFuture, String aFileName) throws Exception {
        final SrFuture<Properties> future = this.myPersistencyAO.loadPropertiesFromFile(aFileName);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.loadPropertiesFromFileFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, future);
    }

    @Override
    protected Void __loadPropertiesFromFileFinished(SrFuture<Properties> aLoadFromFileFuture, SrFuture<Properties> aCtrlFuture) throws Exception {
        return SrActiveObject.updateFutureByGivenFuture(aLoadFromFileFuture, aCtrlFuture);
    }

    @Override
    protected void __setToFile(final SrFuture<Void> aCtrlFuture, String aFileName, Iterable<? extends HistoryAlarmData> aAlarm) throws Exception {
        final SrFuture<Void> future = this.myPersistencyAO.setToFile(aFileName, aAlarm);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.setToFileFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    public void syncSetToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms) {
        try {
            this.myPersistencyAO.synchSetToFile(aFileName, aAlarms);
        }
        catch (SrDatabaseException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not save alarms: ", aAlarms, " in the file: ", aFileName);
        }
    }

    @Override
    protected Void __setToFileFinished(SrFuture<Void> aSetToFileFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aSetToFileFuture);
    }

    @Override
    protected void __handleColdReset(final SrFuture<Void> aCtrlFuture, CommKeyClassId aVswitchId) throws Exception {
        VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(aVswitchId);
        final SrFuture<Void> future = vswitchAo.handleColdReset();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.handleColdResetFinished(future, aCtrlFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __handleColdResetFinished(SrFuture<Void> aHandleColdResetFuture, SrFuture<Void> aCtrlFuture) throws Exception {
        return this.handleForwardVoidFuture(aCtrlFuture, aHandleColdResetFuture);
    }

    @Override
    protected String __getSnmpManagerIPAddress(CommKey[] vSwitchCommKeys) throws Exception {
        char snmpAgentIndex = CommKeyUtil.getSnmpAgentIndex(vSwitchCommKeys);
        return new SnmpManagerConfigurator().commGetManagerIpAddress(snmpAgentIndex);
    }

    @Override
    protected void __loadCluster(final SrFuture<ConfigElementDataList> aFuture, String aCluster) throws Exception {
        final SrFuture<ConfigElementDataList> future = this.myPersistencyAO.loadCluster(aCluster);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.loadClusterFinished(future, aFuture);
            }
        };
        DefaultFutureListener.listenTo(run, future);
    }

    @Override
    protected Void __loadClusterFinished(SrFuture<ConfigElementDataList> aLoadFuture, SrFuture<ConfigElementDataList> aFuture) throws Exception {
        try {
            aFuture.set(aLoadFuture.get());
        }
        catch (Throwable exp) {
            aFuture.setException(exp);
        }
        return null;
    }

    @Override
    protected void __getAllVSs(final SrFuture<List<String>> aFuture, String aCluster, String aSite) throws Exception {
        final SrFuture<List<String>> persisFuture = this.myPersistencyAO.getAllVSs(aCluster, aSite);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.getAllVSsFinished(aFuture, persisFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, persisFuture);
    }

    @Override
    protected Void __getAllVSsFinished(SrFuture<List<String>> aFutureToUpdate, SrFuture<List<String>> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __configureElements(final SrFuture<Void> aFuture, ConfigElementDataList aCedList) throws Exception {
        final ArrayList<SrFuture<Void>> configurationFutures = new ArrayList<SrFuture<Void>>();
        for (ElementData cedObj : aCedList) {
            if (!this.isPersistency((ConfigElementData)cedObj)) continue;
            throw new IllegalArgumentException("CED list cannot contain a ced of persistency(V-Switch, cluster or site) element, element: " + cedObj);
        }
        Collection<ConfigElementDataList> elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(aCedList);
        for (ConfigElementDataList configElementDataList : elementsAccordingToAgents) {
            ConfigElementData ced = (ConfigElementData)configElementDataList.get(0);
            VSwitchDataAOImpl vswitchAo = this.getVSwitchAO(ced.getVswitchId());
            SrFuture<Void> future = vswitchAo.configureElements(configElementDataList);
            configurationFutures.add(future);
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.configureElementsFinished(aFuture, configurationFutures);
            }
        };
        DefaultFutureListener.listenTo(toRun, configurationFutures);
    }

    @Override
    protected Void __configureElementsFinished(SrFuture<Void> aFuture, List<SrFuture<Void>> aConfigurationFutures) throws Exception {
        return this.handleForwardVoidFuture(aFuture, aConfigurationFutures);
    }

    private void addVSwitch(ConfigElementData aVswitchCed) {
        this.myVswitchesMap.put(aVswitchCed.getVswitchId(), new VSwitchDataAOImpl(aVswitchCed));
    }

    private void removeVSwitch(CommKeyClassId aVswitchId) {
        VSwitchDataAOImpl vswitchAO = this.getVSwitchAO(aVswitchId);
        vswitchAO.shutdown();
        this.myVswitchesMap.remove(aVswitchId);
    }

    private <T> boolean forwardExceptionsIfExist(SrFuture<T> aDestFuture, Collection<? extends SrFuture<?>> aSrcFutures) {
        try {
            ArrayList<Throwable> excList = new ArrayList<Throwable>();
            for (SrFuture<?> srcFuture : aSrcFutures) {
                try {
                    srcFuture.get();
                }
                catch (Exception e) {
                    excList.add(e);
                    theLogger.error(SrLogCategories.ERROR, e, new Object[0]);
                }
                catch (Throwable e) {
                    excList.add(e);
                    theLogger.logAndAssert(SrLogCategories.ERROR, e);
                }
            }
            if (!excList.isEmpty()) {
                aDestFuture.setException(new SrExecutionException(excList));
                return true;
            }
        }
        catch (Throwable th) {
            aDestFuture.setException(th);
            return true;
        }
        return false;
    }

    private Void handleForwardVoidFuture(SrFuture<Void> aDestFuture, SrFuture<?> ... aSrcFutures) {
        return this.handleForwardVoidFuture(aDestFuture, Arrays.asList(aSrcFutures));
    }

    private Void handleForwardVoidFuture(SrFuture<Void> aDestFuture, Collection<? extends SrFuture<?>> aSrcFutures) {
        if (!this.forwardExceptionsIfExist(aDestFuture, aSrcFutures)) {
            aDestFuture.set(null);
        }
        return null;
    }

    private void assertNotPersistency(ConfigElementData aCed) {
        theLogger.logAndAssert(SrLogCategories.ERROR, !this.isPersistency(aCed), new Object[]{"CED cannot be a persistency(V-Switch, cluster or site) element, element:" + aCed});
    }

    private Collection<ConfigElementDataList> splitElementAccordingToAgentIndices(ConfigElementDataList elementList) {
        HashMap<CommKeyClassId, ConfigElementDataList> vswitchToCedListmap = new HashMap<CommKeyClassId, ConfigElementDataList>();
        for (ElementData ed : elementList) {
            ConfigElementData element = (ConfigElementData)ed;
            ConfigElementDataList splittedElementResultList = this.splitElementAccordingToAgentIndices(element);
            for (ElementData splitEd : splittedElementResultList) {
                ConfigElementData vswitchElement = (ConfigElementData)splitEd;
                CommKeyClassId vswitchId = vswitchElement.getVswitchId();
                ConfigElementDataList vswitchList = (ConfigElementDataList)vswitchToCedListmap.get(vswitchId);
                if (vswitchList == null) {
                    vswitchList = new ConfigElementDataList();
                    vswitchToCedListmap.put(vswitchId, vswitchList);
                }
                vswitchList.add(vswitchElement);
            }
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, vswitchToCedListmap.values().size() > 0, new Object[]{"splitElement(ConfigElementDataList) method returned an empty collection"});
        return vswitchToCedListmap.values();
    }

    private ConfigElementDataList splitElementAccordingToAgentIndices(ConfigElementData element) {
        Object vswitchDataObject = element.getValue(ParameterCode.VSWITCH_ID);
        if (vswitchDataObject instanceof ConfigElementDataList) {
            return (ConfigElementDataList)vswitchDataObject;
        }
        if (ClassID.VSWITCH.equals(element.getClassId())) {
            element.setValue(ParameterCode.VSWITCH_ID, element.getCommKeyClassId());
            ConfigElementDataList elementsList = new ConfigElementDataList();
            elementsList.add(element);
            return elementsList;
        }
        vswitchDataObject = element.getVswitchIds();
        CommKey[] elementKeys = element.getCommKey();
        if (vswitchDataObject == null && elementKeys == null) {
            throw new IllegalArgumentException("CED doesn't contain V-Switch data, " + element);
        }
        if (this.isPersistency(element)) {
            throw new IllegalArgumentException("CED shouldn't be splitted, " + element);
        }
        if (elementKeys != null && element.getCommKeyClassId().getDBCommKey() != null) {
            throw new IllegalArgumentException("CED contains DB CommKey, " + element);
        }
        CommKeyClassId[] vSwitchesData = null;
        vSwitchesData = vswitchDataObject != null ? (vswitchDataObject instanceof CommKeyClassId[] ? (CommKeyClassId[])vswitchDataObject : new CommKeyClassId[]{(CommKeyClassId)vswitchDataObject}) : CommKeyUtil.getVSwitchCommKeyClassIDs(elementKeys);
        ConfigElementDataList elementsList = new ConfigElementDataList();
        for (CommKeyClassId vsId : vSwitchesData) {
            ConfigElementData newCed;
            if (!this.isCkidValuesValidOnVswitch(element, vsId)) continue;
            if (element instanceof MirrVolConfigElementData) {
                MirrVolConfigElementData mirrCed = (MirrVolConfigElementData)element;
                MirrVolConfigElementData newMirrCed = new MirrVolConfigElementData(element.getClassId(), mirrCed.getActiveVswitch(), mirrCed.getAutoSync());
                newCed = newMirrCed;
            } else {
                newCed = new ConfigElementData(element.getClassId(), element.getConfigOperation());
            }
            newCed.setValue(ParameterCode.VSWITCH_ID, vsId);
            elementsList.add(newCed);
            Set<ParameterCodes> keySet = element.hiddenKeySet();
            keySet.remove(ParameterCode.VSWITCH_ID);
            for (ParameterCodes code : keySet) {
                ParameterCode pCode = (ParameterCode)code;
                Object value = element.getValue(pCode);
                if (value instanceof CommKeyClassId) {
                    CommKeyClassId newCkid = CommKeyUtil.getSpecificCommKeyClassId((CommKeyClassId)value, vsId);
                    if (newCkid != null) {
                        newCed.setValue(pCode, newCkid);
                        continue;
                    }
                    theLogger.logAndAssert(SrLogCategories.ILLEGAL_STATE, "The value ", value, " for parameter ", pCode, " in the CED ", element, " is not redundant for VS ", vsId);
                    continue;
                }
                if (value instanceof CommKeyClassId[]) {
                    CommKeyClassId[] ckidArray = (CommKeyClassId[])value;
                    SrType[] newArray = new CommKeyClassId[ckidArray.length];
                    for (int i = 0; i < ckidArray.length; ++i) {
                        CommKeyClassId newCkid = CommKeyUtil.getSpecificCommKeyClassId(ckidArray[i], vsId);
                        if (newCkid != null) {
                            newArray[i] = newCkid;
                            continue;
                        }
                        theLogger.logAndAssert(SrLogCategories.ILLEGAL_STATE, "The value ", value, " for parameter ", pCode, " in the CED ", element, " is not redundant for VS ", vsId);
                    }
                    newCed.setValues(pCode, newArray);
                    continue;
                }
                newCed.addParameter(pCode, value);
            }
            this.splitNestedCeds(newCed);
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, elementsList.size() > 0, new Object[]{"The split method returned an empty split list. The parameter it received is: " + element});
        element.setValue(ParameterCode.VSWITCH_ID, elementsList);
        return elementsList;
    }

    private boolean isCkidValuesValidOnVswitch(ElementData element, CommKeyClassId vsData) {
        for (ParameterCode parameterCode : element.hiddenKeySet()) {
            CommKeyClassId[] keys;
            Object value = element.getValue(parameterCode);
            if (value instanceof ConfigElementData) {
                if (this.isCkidValuesValidOnVswitch((ConfigElementData)value, vsData)) continue;
                return false;
            }
            if (value instanceof ConfigElementDataList && !parameterCode.equals(ParameterCode.VSWITCH_ID)) {
                ConfigElementDataList list = (ConfigElementDataList)value;
                int index = list.size();
                while (index-- > 0) {
                    if (this.isCkidValuesValidOnVswitch(list.getElementDataAt(index), vsData)) continue;
                    return false;
                }
                continue;
            }
            if (value instanceof CommKeyClassId) {
                CommKeyClassId key = (CommKeyClassId)value;
                ClassID classId = key.getClassID();
                if (classId.isPolicyClassId() || classId.equals(ClassID.ISCSI_TARGET_QOS_GROUP) || CommKeyUtil.getSpecificCommKeyClassId(key, vsData) != null) continue;
                theLogger.warn(SrLogCategories.INFORMATIVE, "In element ", element.getClassId(), " the code ", parameterCode, " is not redundant for V-Switch ", vsData);
                return false;
            }
            if (!(value instanceof CommKeyClassId[])) continue;
            for (CommKeyClassId key : keys = (CommKeyClassId[])value) {
                ClassID classId = key.getClassID();
                if (classId.isPolicyClassId() || classId.equals(ClassID.ISCSI_TARGET_QOS_GROUP) || parameterCode.equals(ParameterCode.VSWITCH_ID) || CommKeyUtil.getSpecificCommKeyClassId(key, vsData) != null) continue;
                theLogger.warn(SrLogCategories.INFORMATIVE, "In element ", element.getClassId(), " the code ", parameterCode, " is not redundant for V-Switch ", vsData);
                return false;
            }
        }
        return true;
    }

    private void splitNestedCeds(ConfigElementData element) {
        CommKeyClassId vswitchId = element.getVswitchId();
        theLogger.logAndAssert(SrLogCategories.ERROR, vswitchId != null, new Object[]{"should have been set before calling this method. element: " + element});
        for (ParameterCode parameterCode : element.hiddenKeySet()) {
            Object value = element.getValue(parameterCode);
            if (value instanceof ConfigElementData) {
                ConfigElementDataList list = this.splitElementAccordingToAgentIndices((ConfigElementData)value);
                for (ConfigElementData elem : list) {
                    if (!elem.getValue(ParameterCode.VSWITCH_ID).equals(vswitchId)) continue;
                    elem.setValue(ParameterCode.VSWITCH_ID, vswitchId);
                    element.setValue(parameterCode, elem);
                }
            }
            if (!(value instanceof ConfigElementDataList)) continue;
            ConfigElementDataList elementList = new ConfigElementDataList();
            Iterator listIter = ((ConfigElementDataList)value).iterator();
            while (listIter.hasNext()) {
                ConfigElementDataList list = this.splitElementAccordingToAgentIndices((ConfigElementData)listIter.next());
                for (ConfigElementData elem : list) {
                    if (!elem.getValue(ParameterCode.VSWITCH_ID).equals(vswitchId)) continue;
                    elementList.add(elem);
                }
            }
            element.setValue(parameterCode, elementList);
        }
    }

    public static ElementConfigurator getElementConfigFromElementData(ConfigElementData element) {
        ClassID classId = element.getClassId();
        return DataMgrAOImpl.getElementConfigFromClassID(classId);
    }

    public static ElementConfigurator getElementConfigFromClassID(ClassID classId) {
        if (ClassID.DIRECT_ACCESS_DEVICE.equals(classId)) {
            return new DirectAccessDeviceConfigurator();
        }
        if (ClassID.SUB_DIRECT_ACCESS_DEVICE.equals(classId)) {
            return new SubDirectAccessDeviceConfigurator();
        }
        if (ClassID.SIMPLE_VOLUME.equals(classId)) {
            return new SimpleVolumeConfigurator();
        }
        if (ClassID.TRANSPARENT_VOLUME.equals(classId)) {
            return new TransparentVolumeConfigurator();
        }
        if (ClassID.MIRROR_VOLUME.equals(classId)) {
            return new MirrorVolumeConfigurator();
        }
        if (ClassID.CONCAT_VOLUME.equals(classId)) {
            return new ConcatVolumeConfigurator();
        }
        if (ClassID.CUBE_VOLUME.equals(classId)) {
            return new CubeVolumeConfigurator();
        }
        if (ClassID.STRIPE_VOLUME.equals(classId)) {
            return new StripeVolumeConfigurator();
        }
        if (ClassID.JOURNAL_VOLUME.equals(classId)) {
            return new JournalVolumeConfigurator();
        }
        if (ClassID.GENERAL_VOLUME.equals(classId)) {
            return new VolumeConfigurator();
        }
        if (ClassID.DIRECT_ACCESS_DEVICE.equals(classId)) {
            return new PhysicalStorageConfigurator();
        }
        if (ClassID.ISCSI_TARGET.equals(classId)) {
            return new IscsiTargetConfigurator();
        }
        if (ClassID.ISCSI_TARGET_QOS_GROUP.equals(classId)) {
            return new IscsiTargetQosGroupConfigurator();
        }
        if (ClassID.LUN.equals(classId)) {
            return new LUNConfigurator();
        }
        if (ClassID.SCSI_LUN.equals(classId)) {
            return new SCSILunConfigurator();
        }
        if (ClassID.VSWITCH.equals(classId)) {
            return new VSwitchConfigurator();
        }
        if (ClassID.CLUSTER.equals(classId)) {
            return new ClusterConfigurator();
        }
        if (ClassID.SITE.equals(classId)) {
            return new SiteConfigurator();
        }
        if (ClassID.INTERFACE.equals(classId)) {
            return new IfConfigurator();
        }
        if (ClassID.FC_INTERFACE.equals(classId)) {
            return new FCIfConfigurator();
        }
        if (ClassID.PSCSI_INTERFACE.equals(classId)) {
            return new PScsiIfConfigurator();
        }
        if (ClassID.NETWORK_CONFIGURATION.equals(classId)) {
            return new NetConfigConfigurator();
        }
        if (ClassID.PORTAL.equals(classId)) {
            return new IscsiPortalConfigurator();
        }
        if (ClassID.IP_ROUTE.equals(classId)) {
            return new IpRouteConfigurator();
        }
        if (ClassID.STORAGE_DOMAIN.equals(classId)) {
            return new StorageDomainConfigurator();
        }
        if (ClassID.NEIGHBORE.equals(classId)) {
            return new SnmpTargetAddressConfigurator();
        }
        if (ClassID.SNMP_MANAGER.equals(classId)) {
            return new SnmpManagerConfigurator();
        }
        if (ClassID.IDENTITY.equals(classId)) {
            return new IdentityConfigurator();
        }
        if (ClassID.SRP_CREDENTIALS.equals(classId)) {
            return new SRPCredentialsConfigurator();
        }
        if (ClassID.CHAP_CREDENTIALS.equals(classId)) {
            return new CHAPCredentialsConfigurator();
        }
        if (ClassID.VOLUME_OPERATION.equals(classId)) {
            return new VolumeOperationConfigurator();
        }
        if (ClassID.MIRROR_SYNC.equals(classId)) {
            return new MirrorVolumeSyncConfigurator();
        }
        if (ClassID.COPY_OPERATION.equals(classId)) {
            return new VolumeOperationConfigurator();
        }
        if (ClassID.IDENTITY_NAME.equals(classId)) {
            return new IdentityNameConfigurator();
        }
        if (ClassID.ACL_ENTRY.equals(classId)) {
            return new TargetAuthorizationConfigurator();
        }
        if (ClassID.ALARM_TYPE.equals(classId)) {
            return new AlarmTypeConfigurator();
        }
        if (ClassID.EMAIL_CONTACT.equals(classId)) {
            return new EmailContactConfigurator();
        }
        if (ClassID.LU_IDENTIFIER.equals(classId)) {
            return new LUIdentifierConfigurator();
        }
        if (ClassID.RADIUS_SERVER.equals(classId)) {
            return new RadiusServerConfigurator();
        }
        if (ClassID.ISNS_SERVER.equals(classId)) {
            return new ISNSServerConfigurator();
        }
        if (ClassID.SEQUENTIAL_ACCESS_DEVICE.equals(classId) || ClassID.GENERAL_SCSI_DEVICE.equals(classId) || ClassID.GENERAL_PHYSICAL_STORAGE.equals(classId)) {
            return new PhysicalStorageConfigurator();
        }
        if (ClassID.SNAPSHOT_VOLUME.equals(classId)) {
            return new SnapshotVolumeConfigurator();
        }
        if (ClassID.FC_NODE.equals(classId)) {
            return new FCNodeConfigurator();
        }
        if (ClassID.HARDWARE.equals(classId)) {
            return new HardwareConfigurator();
        }
        if (ClassID.STATISTIC_INTERFACE.equals(classId)) {
            return new IfStatisticConfigurator();
        }
        if (ClassID.ISCSI_CONNECTION.equals(classId)) {
            return new IScsiConnectionConfigurator();
        }
        if (ClassID.ISCSI_INSTANCE.equals(classId)) {
            return new IScsiInstanceConfigurator();
        }
        if (ClassID.ISCSI_SESSION.equals(classId)) {
            return new IScsiSessionConfigurator();
        }
        if (ClassID.ISCSI_REMOTE_INITIATOR.equals(classId)) {
            return new IScsiRemoteInitatoresConfigurator();
        }
        if (ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS.equals(classId)) {
            return new IScsiRemoteInitatoresConfigurator();
        }
        if (ClassID.ISCSI_SESSION_STATISTICS.equals(classId)) {
            return new IScsiSessionConfigurator();
        }
        if (ClassID.STATISTIC_TCP_CONNECTION.equals(classId)) {
            return new TcpConnectionConfigurator();
        }
        if (ClassID.STATISTIC_UDP_LISTENER.equals(classId)) {
            return new UDPListenerConfigurator();
        }
        if (ClassID.SCSI_DEVICE.equals(classId)) {
            return new ScsiDeviceConfigurator();
        }
        if (ClassID.SCSI_INITIATOR.equals(classId)) {
            return new ScsiInitiatorDeviceConfigurator();
        }
        if (ClassID.SCSI_PORT.equals(classId)) {
            return new ScsiPortConfigurator();
        }
        if (ClassID.ISCSI_REMOTE_TARGET.equals(classId)) {
            return new SCSIRemoteTargetConfigurator();
        }
        if (ClassID.ISCSI_REMOTE_TARGET_PORTAL.equals(classId)) {
            return new SCSIRemoteTargetPortalConfigurator();
        }
        if (ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL.equals(classId)) {
            return new ISCSIRemotePortalDiscoveryConfigurator();
        }
        if (ClassID.CONSISTENCY_GROUP.equals(classId)) {
            return new ConsistencyGroupConfigurator();
        }
        if (ClassID.DR_CONSISTENCY_GROUP_PIT.equals(classId)) {
            return new ConsistencyGroupPiTConfigurator();
        }
        if (ClassID.GENERAL_PAIR.equals(classId)) {
            return new PairConfigurator();
        }
        if (ClassID.SYNC_PAIR.equals(classId)) {
            return new SyncPairConfigurator();
        }
        if (ClassID.ASYNC_PAIR.equals(classId)) {
            return new AsyncPairConfigurator();
        }
        if (ClassID.DR_ASYNC_PAIR_PIT.equals(classId)) {
            return new AsyncPairPiTConfigurator();
        }
        if (ClassID.POLICY_START.equals(classId)) {
            return new PolicyConfigurator();
        }
        if (ClassID.POLICY_PARAMS.equals(classId)) {
            return new PolicyParamConfigurator();
        }
        if (ClassID.EXTENDED_PAIR.equals(classId)) {
            return new ExtendedPairConfigurator();
        }
        if (ClassID.CF_SYNC_PAIR.equals(classId)) {
            return new SyncPairControlFunctionsConfigurator();
        }
        if (ClassID.CF_ASYNC_PAIR.equals(classId)) {
            return new AsyncPairControlFunctionsConfigurator();
        }
        if (ClassID.CF_CONSISTENCY_GROUP.equals(classId)) {
            return new CGControlFunctionsConfigurator();
        }
        if (ClassID.ETHERNET_INTERFACE.equals(classId)) {
            return new IfConfigurator();
        }
        if (ClassID.STORAGE_NOTIFICATION.equals(classId)) {
            return new RaidTrapConfigurator();
        }
        if (ClassID.ATTACHED_RAID.equals(classId)) {
            return new AttachedRaidConfigurator();
        }
        if (ClassID.SNAPSHOT_SCHEDULER.equals(classId)) {
            return new SnapshotSchedulerConfigurator();
        }
        throw new UnsupportedClassVersionError("Unknown ClassID: " + classId);
    }

    private VSwitchDataAOImpl getVSwitchAO(CommKeyClassId aVswitchId) {
        VSwitchDataAOImpl vswitchAo = this.myVswitchesMap.get(aVswitchId);
        if (vswitchAo == null) {
            throw new IllegalArgumentException("Couldn't find the VS, vs ID from the map: " + aVswitchId + "; myVswitchesMap: " + this.myVswitchesMap);
        }
        return vswitchAo;
    }

    private boolean isPersistency(ConfigElementData aCED) {
        ClassID cid = aCED.getClassId();
        if (ClassID.CLUSTER.equals(cid) || ClassID.SITE.equals(cid) || ClassID.ALARM_TYPE.equals(cid) || ClassID.EMAIL_CONTACT.equals(cid)) {
            return true;
        }
        return ClassID.VSWITCH.equals(cid) && aCED.getCommKey() == null;
    }

    public static synchronized String getSnmpManagerIp(CommKeyClassId aVS) throws SrCommException {
        if (aVS == null) {
            throw new IllegalArgumentException("The given VS's CKCI should not be null.");
        }
        return CommMgr.getSnmpManagerIp(aVS.getMyFirstSnmpAgentIndex());
    }

    public static synchronized int getManagerTrapPort(CommKeyClassId aVS) {
        if (aVS == null) {
            throw new IllegalArgumentException("The given VS's CKCI should not be null.");
        }
        return CommMgr.getManagerTrapPort(aVS.getMyFirstSnmpAgentIndex());
    }

    @Override
    protected void __suspendPolling(final SrFuture<Void> aFuture, PollingGroupType aPollingType) throws Exception {
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        for (VSwitchDataAOImpl curVsAO : this.myVswitchesMap.values()) {
            dependencyFutures.add(curVsAO.suspendPolling(aPollingType));
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.suspendAllPollingFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }

    @Override
    protected void __resumePolling(final SrFuture<Void> aFuture, PollingGroupType aPollingType) throws Exception {
        final ArrayList<SrFuture<Void>> dependencyFutures = new ArrayList<SrFuture<Void>>();
        for (VSwitchDataAOImpl curVsAO : this.myVswitchesMap.values()) {
            dependencyFutures.add(curVsAO.resumePolling(aPollingType));
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataMgrAOImpl.this.suspendAllPollingFinished(aFuture, dependencyFutures);
            }
        };
        DefaultFutureListener.listenTo(run, dependencyFutures);
    }
}

