/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ElementData;
import java.util.HashMap;

public class ConfigElementData
extends ElementData {
    private ConfigOperation myConfigOperation = ConfigOperation.NO_OPERATION;
    private boolean myIsUsedForConfiguration = false;
    private static SrLogger theLogger = SrLogger.getLogger();
    private CommKeyClassId operationInvoker = null;

    public ConfigElementData(CommKey key, ClassID classId) {
        this(key, classId, ConfigOperation.NO_OPERATION);
    }

    public ConfigElementData(CommKey key, ClassID classId, ConfigOperation aConfigType) {
        super(key, classId);
        this.setConfigurationType(aConfigType);
    }

    public ConfigElementData(CommKeyClassId data) {
        this(data, ConfigOperation.NO_OPERATION);
    }

    public ConfigElementData(CommKeyClassId data, ConfigOperation aConfigType) {
        super(data);
        this.setConfigurationType(aConfigType);
    }

    public ConfigElementData(ConfigElementData element) {
        super(element);
    }

    public ConfigElementData(CommKey[] key, ClassID classId) {
        this(key, classId, ConfigOperation.NO_OPERATION);
    }

    public ConfigElementData(CommKey[] key, ClassID classId, ConfigOperation aConfigType) {
        super(key, classId);
        this.setConfigurationType(aConfigType);
    }

    public ConfigElementData(CommKey key, ClassID classId, HashMap<ParameterCodes, Object> parameters) {
        super(key, classId, parameters);
    }

    public ConfigElementData(CommKey[] key, ClassID classId, HashMap<ParameterCodes, Object> parameters) {
        super(key, classId, parameters);
    }

    public ConfigElementData(CommKey[] key, ClassID classId, HashMap<ParameterCodes, Object> parameters, CommKeyClassId operInvoker) {
        super(key, classId, parameters);
        this.operationInvoker = operInvoker;
    }

    public ConfigElementData(ClassID classId) {
        this(classId, ConfigOperation.NO_OPERATION);
    }

    public ConfigElementData(ClassID classId, ConfigOperation aConfigType) {
        this((CommKey[])null, classId, aConfigType);
    }

    private void setConfigurationType(ConfigOperation aConfigType) {
        this.myConfigOperation = aConfigType != null ? aConfigType : ConfigOperation.NO_OPERATION;
    }

    public ConfigOperation getConfigOperation() {
        return this.myConfigOperation;
    }

    public void setUsedForConfiguration(boolean aIsUsedForConfiguration) {
        this.myIsUsedForConfiguration = aIsUsedForConfiguration;
    }

    public boolean isUsedForConfiguration() {
        if (ConfigOperation.CREATE.equals((Object)this.myConfigOperation) && this.getCommKey() != null && this.getCommKey().length > 0) {
            return true;
        }
        return this.myIsUsedForConfiguration;
    }

    public void setOperationInvoker(CommKeyClassId invoker) {
        this.operationInvoker = invoker;
    }

    public CommKeyClassId getOperationInvoker() {
        return this.operationInvoker;
    }

    @Override
    public Object clone() {
        ConfigElementData newElement = new ConfigElementData(this.getCommKey(), this.getClassId(), this.getParametersList(), this.operationInvoker);
        newElement.setConfigurationType(this.getConfigOperation());
        return newElement;
    }

    public char getMyFirstSnmpAgentIndex() {
        CommKey[] keys = this.getCommKey();
        if (keys == null || CommKeyUtil.getSnmpCommKeys(keys).length > 1) {
            theLogger.error(SrLogCategories.ERROR, new IllegalStateException("SHOULDN'T BE HERE: calling getMyFirstSnmpAgentIndex() where there is more then 1 index (yet no exception was thrown), CED: " + this), new Object[0]);
        }
        return CommKeyUtil.getSnmpCommKey(this.getCommKey()).getSnmpAgentIndex();
    }

    public char getSnmpAgentFromParameter() {
        Object vsObj = this.getValue(ParameterCode.VSWITCH_ID);
        CommKeyClassId vSwitch = null;
        if (vsObj instanceof CommKeyClassId[]) {
            CommKeyClassId[] vSwitchArr = (CommKeyClassId[])vsObj;
            vSwitch = vSwitchArr[0];
        } else if (vsObj instanceof CommKeyClassId) {
            vSwitch = (CommKeyClassId)vsObj;
        } else {
            throw new IllegalStateException("There is no VS ID in the current CED: " + this);
        }
        return CommKeyUtil.getSnmpCommKey(vSwitch).getSnmpAgentIndex();
    }

    public void addParameter(Parameter param) {
        this.addParameter(param.getCode(), param.getValue());
    }

    public void addParameter(ParameterCodes code, Object value) {
        this.put(code, value);
    }

    public void addParameter(Parameter[] params) {
        for (int i = params.length - 1; i >= 0; --i) {
            this.addParameter(params[i]);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConfigElementData) {
            ConfigElementData other = (ConfigElementData)obj;
            return super.equals(other) && this.myConfigOperation.equals((Object)other.myConfigOperation);
        }
        return false;
    }
}

