/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrInteger;

public class ClusterConfigurator
extends ElementConfigurator {
    public ClusterConfigurator() {
        super(ClassID.CLUSTER, "", null, null);
    }

    public ConfigElementDataList getAll() throws SrCommException {
        CommVarBindList[] clusterList = this.commGetAllClustersData('z');
        ConfigElementDataList elementList = new ConfigElementDataList();
        for (int i = 0; i < clusterList.length; ++i) {
            ConfigElementData element = this.createDbCedFromVarbindList(clusterList[i]);
            SrInteger key = (SrInteger)element.getValue(ParameterCode.VSWITCH_GROUP_ID);
            element.setCommKey(new DataBaseCommKey(key.toString()));
            SrInteger parentKey = (SrInteger)element.getValue(ParameterCode.PARENT_SITE_ID);
            if (parentKey != null) {
                CommKey[] parentKeys = new CommKey[]{new DataBaseCommKey(parentKey.toString())};
                element.setValue(ParameterCode.PARENT_SITE_ID, new CommKeyClassId(parentKeys, ClassID.SITE));
            }
            elementList.add(element);
        }
        this.sendDiscoveredElementsToEventMgr(elementList, null);
        return elementList;
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        SrInteger clusterId = (SrInteger)element.getValue(ParameterCode.VSWITCH_GROUP_ID);
        element.setCommKey(new DataBaseCommKey(clusterId.toString()));
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        CommMgr.getInstance('z').addCluster(varBindList);
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        return false;
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        CommKey[] commKey = element.getCommKey();
        Integer vSwitchGroupId = new Integer(commKey[0].getKey());
        this.commRemoveCluster(vSwitchGroupId, 'z');
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        this.addCommVarBindsToChangeList(varBindList, element);
        this.commChangeClusterParams(varBindList, 'z');
    }

    @Override
    public boolean readAfterChange(ConfigElementData element) throws SrCommException {
        return false;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        SrInteger clusterId = (SrInteger)aElement.getValue(ParameterCode.VSWITCH_GROUP_ID);
        if (clusterId == null) {
            throw new IllegalArgumentException("ConfigElementData doesn't contains VSWITCH_GROUP_ID, element: " + aElement);
        }
        DataBaseCommKey dbKey = new DataBaseCommKey(clusterId.toString());
        return new CommKeyClassId(dbKey, aElement.getClassId());
    }
}

