/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.AnnexData;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;

public abstract class AnnexConfigurator
extends ElementConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected ClassID m_baseClassId;

    public AnnexConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib, ClassID baseClassId) {
        super(classId, tableName, rowStatusMib, lastUpdateMib);
        this.m_baseClassId = baseClassId;
    }

    protected void delay(ConfigElementData baseElement, CheckListConfigElementData annexElement) throws SrCommException {
    }

    public void mergeAnnexToBase(ConfigElementData baseElement) throws SrCommException {
        CheckListConfigElementData annexElement = new CheckListConfigElementData(this.myClassId);
        annexElement.addParameter(this.getListOfParams());
        ConfigElementDataList annexValues = this.getAll(baseElement.getMyFirstSnmpAgentIndex(), null, annexElement);
        for (ConfigElementData elem : annexValues) {
            if (!elem.getCommKeyClassId().equals(baseElement.getCommKeyClassId())) continue;
            for (ParameterCode parameterCode : elem.keySet()) {
                if (baseElement.getParametersList().get(parameterCode) instanceof ConfigElementDataList) {
                    ((ConfigElementDataList)baseElement.getParametersList().get(parameterCode)).addAll((ConfigElementDataList)elem.getParametersList().get(parameterCode));
                    continue;
                }
                baseElement.addParameter(parameterCode, elem.getParametersList().get(parameterCode));
            }
        }
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        this.readDiscoverPostOperation(element, null);
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        theLogger.trace(SrLogCategories.LEGACY, "build source element from depended");
        AnnexData annex = this.generateAnnexValuesFromBase(element);
        ConfigElementDataList elementList = new ConfigElementDataList();
        elementList.add(annex);
        element.setValue(annex.getParameterCode(this.getBaseParameterCodes()), elementList);
        element.setCommKeys(new CommKey[]{this.calculateCommKeyOfBase(element)});
        element.setClassId(this.m_baseClassId);
    }

    @Override
    protected void sendDiscoveredElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (ElementData data : list) {
            if (vSwitchData != null) {
                ((ConfigElementData)data).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            theLogger.trace(SrLogCategories.LEGACY, "Discover: ", data.getClassId(), " CommKey is:", CommKeyUtil.getKeyForMessage(data.getCommKey()));
        }
        SrEventHandler.getEventMgr().sendChangeElementEvent(list, (Object)this);
    }

    @Override
    protected void sendRefreshedElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (ElementData data : list) {
            if (vSwitchData != null) {
                ((ConfigElementData)data).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            theLogger.trace(SrLogCategories.LEGACY, "Discover: ", data.getClassId(), " CommKey is:", CommKeyUtil.getKeyForMessage(data.getCommKey()));
        }
        SrEventHandler.getEventMgr().sendChangeElementEvent(list, (Object)this);
    }

    protected abstract SnmpCommKey calculateCommKeyOfBase(ConfigElementData var1);

    protected abstract ParameterCode[] getBaseParameterCodes();

    protected abstract AnnexData generateAnnexValuesFromBase(ConfigElementData var1);
}

