/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.NetworkingStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatistics;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TCPStatisticsImpl
extends NetworkingStatisticsImpl
implements TCPStatistics {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> parametersToCalculateCodeMap;

    public TCPStatisticsImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.STATISTIC_TCP, aCED, (HashMap)parametersToCalculateCodeMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        StringBuffer sb = new StringBuffer(this.getParentVSwitch().getName());
        sb.append(" TCP Statistics");
        this.toStringValue = sb.toString();
        return changedValues;
    }

    @Override
    protected PollingGroupType getGroupType() {
        return PollingGroupType.TCP_GROUP_TYPE;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.TCP_OUT_RSTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_IN_ERRORS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_RETRANS_SEGS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_OUT_SEGS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_IN_SEGS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_ESTAB_RESETS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_ATTEMPT_FAILS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_PASSIVE_OPENS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_ACTIVE_OPENS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_CURR_ESTAB, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        parametersToCalculateCodeMap = new HashMap();
        parametersToCalculateCodeMap.put(ParameterCode.TCP_IN_SEGS, ClientParameterCode.TCP_STATISTICS_SEGMENTS_RECEIVED_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.TCP_RETRANS_SEGS, ClientParameterCode.TCP_STATISTICS_SEGMENTS_RETRANSMITTED_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.TCP_OUT_SEGS, ClientParameterCode.TCP_STATISTICS_SEGMENTS_SENT_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.TCP_IN_ERRORS, ClientParameterCode.TCP_STATISTICS_ERRORS_RECEIVED_PER_SEC);
    }
}

