/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRow;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TCPConnectionStatisticsTableRowImpl
extends TableRowImpl
implements TCPConnectionStatisticsTableRow {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public TCPConnectionStatisticsTableRowImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.STATISTIC_TCP_CONNECTION, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        String localIP = this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.TCP_CONN_LOCAL_ADDRESS);
        Integer localPort = (Integer)this.getValueOf(null, ParameterCode.TCP_CONN_LOCAL_PORTS, true);
        String remoteIP = this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.TCP_CONN_REMOTE_ADDRESS);
        Integer remotePort = (Integer)this.getValueOf(null, ParameterCode.TCP_CONN_REMOTE_PORT, true);
        StringBuffer sb = new StringBuffer(this.getParentVSwitch().getName());
        sb.append(" TCP connection statistics ");
        sb.append(localIP);
        sb.append(":");
        sb.append(localPort);
        sb.append("<->");
        sb.append(remoteIP);
        sb.append(":");
        sb.append(remotePort);
        this.toStringValue = sb.toString();
        return changedValues;
    }

    @Override
    protected String canBeDeleted() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.TCP_CONN_LOCAL_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_CONN_LOCAL_PORTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_CONN_REMOTE_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_CONN_REMOTE_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.TCP_CONN_STATE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

