/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.NetworkingStatisticsImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class InterfacesGroupStatisticsImpl
extends NetworkingStatisticsImpl
implements InterfacesGroupStatistics {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> emptyHashMap;
    private VSwitchImpl vswitch = null;

    public InterfacesGroupStatisticsImpl(VSwitchImpl vswitch, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(vswitch, vswitch.getCluster(), ClassID.STATISTIC_INTERFACES_GROUP, aCED, emptyHashMap);
        this.vswitch = vswitch;
        this.addCommKeys(vswitch.getCommKeys());
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public VSwitchImpl getParentVSwitch() {
        return this.vswitch;
    }

    @Override
    protected PollingGroupType getGroupType() {
        return PollingGroupType.INTERFACE_GROUP_TYPE;
    }

    @Override
    public SrFuture<Integer> stopPolling() throws RemoteException, IllegalValueException {
        final SrFuture<Integer> retFuture = new SrFuture<Integer>("InterfacesGroupStatisticsImpl.stopPolling");
        final SrFuture<Integer> baseFuture = super.stopPolling();
        final InterfacesGroupStatisticsImpl curInstance = this;
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().stopPollingFollowUp(curInstance, retFuture, baseFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, baseFuture);
        return retFuture;
    }

    public void clearInterfacesData() throws RemoteException {
        VSwitchImpl vSwitch = this.getParentVSwitch();
        Vector<InterfaceStatisticsTableRowImpl> interfaces = vSwitch.getInterfacesStatisticsTable();
        for (InterfaceStatisticsTableRowImpl currInterface : interfaces) {
            currInterface.clearParameterListExceptForVSwitchID(vSwitch);
        }
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        emptyHashMap = new HashMap();
    }
}

