/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.fc;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.logic.vswitch.fc.FCNode;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrOctetStringFormat;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FCNodeImpl
extends TableRowImpl
implements FCNode {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public FCNodeImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.FC_NODE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        if (this.getValueOf(ParameterCode.FC_NODE_WWNN) != null) {
            this.toStringValue = this.getValueOf(ParameterCode.FC_NODE_WWNN).toString();
        }
        return changedValues;
    }

    @Override
    protected void setParentVSwitch(VSwitchImpl vSwitch) {
        super.setParentVSwitch(vSwitch);
        if (vSwitch != null) {
            vSwitch.setFCNode(this);
        }
    }

    @Override
    public String getWWNN() {
        return this.getWWNN(null);
    }

    public String getWWNN(VSwitchImpl vSwitch) {
        SrOctetStringFormat wwnnValue = (SrOctetStringFormat)this.getSrValueOf(vSwitch, ParameterCode.FC_NODE_WWNN, vSwitch == null);
        if (wwnnValue == null) {
            return null;
        }
        return wwnnValue.toDisplayString();
    }

    @Override
    public String getFunctions() {
        return this.getFunctions(null);
    }

    public String getFunctions(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.FC_NODE_FUNCTIONS, vSwitch == null);
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.FC_NODE_WWNN, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.FC_NODE_FUNCTIONS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

